/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.util.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.MARLoader;

public class MARImageTest {
    static String TestFileFolder;
    static String testfile1;
    static String testfile2;
    static String testfile3;
    static String testfile4;

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            junit.framework.Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        TestFileFolder = String.valueOf(TestFileFolder) + "MARImageTest/";
        testfile1 = String.valueOf(TestFileFolder) + "in1187_sample1.mccd";
        testfile2 = String.valueOf(TestFileFolder) + "mar225_001.mccd";
        testfile3 = String.valueOf(TestFileFolder) + "mar165_001.mccd";
        testfile4 = String.valueOf(TestFileFolder) + "ins2-foc_MS_2_001.mccd";
    }

    @Test
    public void testLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData(testfile1, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        dataHolder = LoaderFactory.getData(testfile2, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        dataHolder = LoaderFactory.getData(testfile3, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        dataHolder = LoaderFactory.getData(testfile4, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
        Assert.assertTrue((boolean)dataHolder.getName(0).contains("ins2-foc_MS_2_001.mccd"));
        AbstractDataset abstractDataset = dataHolder.getDataset(0);
        Assert.assertEquals((double)299.0, (double)abstractDataset.getDouble(1500, 1514), (double)1.0);
        Assert.assertEquals((double)89.0, (double)abstractDataset.getDouble(3009, 2168), (double)1.0);
    }

    @Test
    public void testLoadFile() throws Exception {
        new MARLoader(testfile1).loadFile();
    }

    @Test
    public void testLoadFile2() throws Exception {
        new MARLoader(testfile2).loadFile();
    }

    @Test
    public void testLoadFile3() throws Exception {
        new MARLoader(testfile3).loadFile();
    }

    @Test
    public void testLoadFile4() throws Exception {
        new MARLoader(testfile4).loadFile();
    }
}

