/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.LoaderThreadTestBase;

public class MARImageLoaderThreadTest
extends LoaderThreadTestBase {
    private static String TestFileFolder;
    private static String testfile1;
    private static String testfile2;
    private static String testfile3;
    private static String testfile4;

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        TestFileFolder = String.valueOf(TestFileFolder) + "MARImageTest/";
        testfile1 = String.valueOf(TestFileFolder) + "in1187_sample1.mccd";
        testfile2 = String.valueOf(TestFileFolder) + "mar225_001.mccd";
        testfile3 = String.valueOf(TestFileFolder) + "mar165_001.mccd";
        testfile4 = String.valueOf(TestFileFolder) + "ins2-foc_MS_2_001.mccd";
    }

    @Override
    @Test
    public void testInTestThread() throws Exception {
        super.testInTestThread();
    }

    @Test
    public void testWithTwentyThreads() {
        String string;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "";
        }
        if (string.startsWith("p99-ws100")) {
            TestUtils.skipTest((String)(String.valueOf(this.getClass().getCanonicalName()) + ".testWithTwentyThreads skipped, since test takes forever on our under-powered Ubuntu test box (" + string + ")"));
        }
        try {
            super.testWithNThreads(20);
        }
        catch (ScanFileHolderException scanFileHolderException) {
            if (!(scanFileHolderException.getCause() instanceof OutOfMemoryError)) {
                Assert.fail((String)"Something other than an out of memory exception was thrown.");
            }
            System.out.println("This test is expected to throw an exception as the loaders run out of memory");
        }
        catch (Exception exception) {
            Assert.fail((String)"Loading failed for reasons other than out of memory");
        }
    }

    @Override
    public void doTestOfDataSet(int n) throws Exception {
        LoaderFactory.getData(testfile1, null);
        LoaderFactory.getData(testfile2, null);
        LoaderFactory.getData(testfile3, null);
        LoaderFactory.getData(testfile4, null);
    }
}

