/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.ADSCImageLoader;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.CBFLoader;
import uk.ac.diamond.scisoft.analysis.io.CBZip2InputStream;
import uk.ac.diamond.scisoft.analysis.io.CompressedLoader;
import uk.ac.diamond.scisoft.analysis.io.CrysalisLoader;
import uk.ac.diamond.scisoft.analysis.io.DatLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ExtendedSRSLoader;
import uk.ac.diamond.scisoft.analysis.io.HDF5Loader;
import uk.ac.diamond.scisoft.analysis.io.IDataSetLoader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.ISliceLoader;
import uk.ac.diamond.scisoft.analysis.io.JPEGLoader;
import uk.ac.diamond.scisoft.analysis.io.MARLoader;
import uk.ac.diamond.scisoft.analysis.io.NumPyFileLoader;
import uk.ac.diamond.scisoft.analysis.io.PNGLoader;
import uk.ac.diamond.scisoft.analysis.io.PgmLoader;
import uk.ac.diamond.scisoft.analysis.io.PilatusEdfLoader;
import uk.ac.diamond.scisoft.analysis.io.PilatusTiffLoader;
import uk.ac.diamond.scisoft.analysis.io.PixiumLoader;
import uk.ac.diamond.scisoft.analysis.io.RAxisImageLoader;
import uk.ac.diamond.scisoft.analysis.io.RawBinaryLoader;
import uk.ac.diamond.scisoft.analysis.io.RawTextLoader;
import uk.ac.diamond.scisoft.analysis.io.SRSLoader;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;
import uk.ac.diamond.scisoft.analysis.io.TIFFImageLoader;
import uk.ac.diamond.scisoft.analysis.io.XMapLoader;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.util.io.FileUtils;

public class LoaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(LoaderFactory.class);
    private static final Map<String, List<Class<? extends AbstractFileLoader>>> LOADERS = new HashMap<String, List<Class<? extends AbstractFileLoader>>>(19);
    private static final Map<String, Class<? extends InputStream>> UNZIPERS = new HashMap<String, Class<? extends InputStream>>(3);
    private static boolean searchingAllowed;

    static {
        try {
            LoaderFactory.registerLoader("npy", NumPyFileLoader.class);
            LoaderFactory.registerLoader("img", ADSCImageLoader.class);
            LoaderFactory.registerLoader("osc", RAxisImageLoader.class);
            LoaderFactory.registerLoader("cbf", CBFLoader.class);
            LoaderFactory.registerLoader("img", CrysalisLoader.class);
            LoaderFactory.registerLoader("tif", PixiumLoader.class);
            LoaderFactory.registerLoader("jpeg", JPEGLoader.class);
            LoaderFactory.registerLoader("jpg", JPEGLoader.class);
            LoaderFactory.registerLoader("mccd", MARLoader.class);
            LoaderFactory.registerLoader("nxs", HDF5Loader.class);
            LoaderFactory.registerLoader("h5", HDF5Loader.class);
            LoaderFactory.registerLoader("hdf", HDF5Loader.class);
            LoaderFactory.registerLoader("hdf5", HDF5Loader.class);
            LoaderFactory.registerLoader("hd5", HDF5Loader.class);
            LoaderFactory.registerLoader("nexus", HDF5Loader.class);
            LoaderFactory.registerLoader("tif", PilatusTiffLoader.class);
            LoaderFactory.registerLoader("png", PNGLoader.class);
            LoaderFactory.registerLoader("raw", RawBinaryLoader.class);
            LoaderFactory.registerLoader("srs", ExtendedSRSLoader.class);
            LoaderFactory.registerLoader("srs", SRSLoader.class);
            LoaderFactory.registerLoader("dat", DatLoader.class);
            LoaderFactory.registerLoader("dat", ExtendedSRSLoader.class);
            LoaderFactory.registerLoader("dat", SRSLoader.class);
            LoaderFactory.registerLoader("txt", DatLoader.class);
            LoaderFactory.registerLoader("txt", SRSLoader.class);
            LoaderFactory.registerLoader("txt", RawTextLoader.class);
            LoaderFactory.registerLoader("mca", DatLoader.class);
            LoaderFactory.registerLoader("mca", SRSLoader.class);
            LoaderFactory.registerLoader("mca", RawTextLoader.class);
            LoaderFactory.registerLoader("tif", TIFFImageLoader.class);
            LoaderFactory.registerLoader("tiff", TIFFImageLoader.class);
            LoaderFactory.registerLoader("zip", XMapLoader.class);
            LoaderFactory.registerLoader("edf", PilatusEdfLoader.class);
            LoaderFactory.registerLoader("pgm", PgmLoader.class);
            LoaderFactory.registerUnzip("gz", GZIPInputStream.class);
            LoaderFactory.registerUnzip("zip", ZipInputStream.class);
            LoaderFactory.registerUnzip("bz2", CBZip2InputStream.class);
        }
        catch (Exception exception) {
            logger.error("Cannot register loader - ALL loader registration aborted!", (Throwable)exception);
        }
        searchingAllowed = false;
    }

    public static Collection<String> getSupportedExtensions() {
        return LOADERS.keySet();
    }

    public static DataHolder getData(String string) throws Exception {
        return LoaderFactory.getData(string, true, new IMonitor(){

            public void worked(int n) {
            }

            public boolean isCancelled() {
                return false;
            }
        });
    }

    public static DataHolder getData(String string, IMonitor iMonitor) throws Exception {
        return LoaderFactory.getData(string, true, iMonitor);
    }

    public static DataHolder getData(String string, boolean bl, IMonitor iMonitor) throws Exception {
        if (!new File(string).exists()) {
            throw new FileNotFoundException(string);
        }
        Iterator<Class<? extends AbstractFileLoader>> iterator = LoaderFactory.getIterator(string);
        while (iterator.hasNext()) {
            Class<? extends AbstractFileLoader> clazz = iterator.next();
            AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz, string);
            abstractFileLoader.setLoadMetadata(bl);
            try {
                DataHolder dataHolder = abstractFileLoader.loadFile(iMonitor);
                return dataHolder;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.error("There was not enough memory to load " + string);
                throw new ScanFileHolderException("Out of memory in loader factory", outOfMemoryError);
            }
            catch (Throwable throwable) {
                logger.trace("Loader error " + abstractFileLoader, throwable);
            }
        }
        return null;
    }

    public static IMetaData getMetaData(String string, IMonitor iMonitor) throws Exception {
        Iterator<Class<? extends AbstractFileLoader>> iterator = LoaderFactory.getIterator(string);
        while (iterator.hasNext()) {
            Class<? extends AbstractFileLoader> clazz = iterator.next();
            AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz, string);
            if (!IMetaLoader.class.isInstance(abstractFileLoader)) continue;
            try {
                ((IMetaLoader)((Object)abstractFileLoader)).loadMetaData(iMonitor);
                IMetaData iMetaData = ((IMetaLoader)((Object)abstractFileLoader)).getMetaData();
                return iMetaData;
            }
            catch (Throwable throwable) {
                logger.trace("Cannot load nexus meta data", throwable);
            }
        }
        return null;
    }

    public static AbstractDataset getDataSet(String string, String string2, IMonitor iMonitor) throws Exception {
        Iterator<Class<? extends AbstractFileLoader>> iterator = LoaderFactory.getIterator(string);
        while (iterator.hasNext()) {
            Class<? extends AbstractFileLoader> clazz = iterator.next();
            AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz, string);
            try {
                AbstractDataset abstractDataset = ((IDataSetLoader)((Object)abstractFileLoader)).loadSet(string, string2, iMonitor);
                return abstractDataset;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static Map<String, ILazyDataset> getDataSets(String string, List<String> list, IMonitor iMonitor) throws Exception {
        Iterator<Class<? extends AbstractFileLoader>> iterator = LoaderFactory.getIterator(string);
        while (iterator.hasNext()) {
            Class<? extends AbstractFileLoader> clazz = iterator.next();
            AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz, string);
            try {
                return ((IDataSetLoader)((Object)abstractFileLoader)).loadSets(string, list, iMonitor);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static AbstractDataset getSlice(SliceObject sliceObject, IMonitor iMonitor) throws Exception {
        Iterator<Class<? extends AbstractFileLoader>> iterator = LoaderFactory.getIterator(sliceObject.getPath());
        while (iterator.hasNext()) {
            Class<? extends AbstractFileLoader> clazz = iterator.next();
            AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz, sliceObject.getPath());
            if (!ISliceLoader.class.isInstance(abstractFileLoader)) continue;
            AbstractDataset abstractDataset = ((ISliceLoader)((Object)abstractFileLoader)).slice(sliceObject, iMonitor);
            return abstractDataset;
        }
        return null;
    }

    public boolean isMetaLoader(String string) throws Exception {
        return this.isInstanceSupported(string, IMetaLoader.class);
    }

    public boolean isDataSetLoader(String string) throws Exception {
        return this.isInstanceSupported(string, IDataSetLoader.class);
    }

    private boolean isInstanceSupported(String string, Class<?> clazz) throws Exception {
        String string2 = FileUtils.getFileExtension((String)string).toLowerCase();
        if (LOADERS.containsKey(string2)) {
            Collection collection = LOADERS.get(string2);
            for (Class clazz2 : collection) {
                AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz2, string);
                if (!clazz.isInstance(abstractFileLoader)) continue;
                return true;
            }
        }
        return false;
    }

    public static AbstractFileLoader getLoader(Class<? extends AbstractFileLoader> clazz, String string) throws Exception {
        AbstractFileLoader abstractFileLoader;
        try {
            Constructor<? extends AbstractFileLoader> constructor = clazz.getConstructor(String.class);
            abstractFileLoader = constructor.newInstance(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            abstractFileLoader = clazz.newInstance();
            Method method = abstractFileLoader.getClass().getMethod("setFile", String.class);
            method.invoke((Object)abstractFileLoader, string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            abstractFileLoader = null;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            abstractFileLoader = null;
        }
        return abstractFileLoader;
    }

    public static Class<? extends AbstractFileLoader> getLoaderClass(String string) {
        return LOADERS.get(string).get(0);
    }

    private static Iterator<Class<? extends AbstractFileLoader>> getIterator(String string) throws IllegalAccessException {
        if (new File(string).isDirectory()) {
            throw new IllegalAccessException("Cannot load directories with LoaderFactory!");
        }
        String string2 = FileUtils.getFileExtension((String)string).toLowerCase();
        Iterator<Class<AbstractFileLoader>> iterator = null;
        if (LOADERS.containsKey(string2)) {
            iterator = LOADERS.get(string2).iterator();
        } else {
            Object object;
            File file = new File(string);
            String string3 = ".+\\." + LoaderFactory.getLoaderExpression() + "\\." + LoaderFactory.getZipExpression();
            Matcher matcher = Pattern.compile(string3).matcher(file.getName());
            if (matcher.matches()) {
                object = matcher.group(1);
                if (LOADERS.keySet().contains(object)) {
                    ArrayList<Class<CompressedLoader>> arrayList = new ArrayList<Class<CompressedLoader>>(1);
                    arrayList.add(CompressedLoader.class);
                    return arrayList.iterator();
                }
            }
            if (!searchingAllowed) {
                return null;
            }
            object = new HashSet();
            for (String string4 : LOADERS.keySet()) {
                object.addAll((Collection)LOADERS.get(string4));
            }
            iterator = object.iterator();
        }
        return iterator;
    }

    public static void registerUnzip(String string, Class<? extends InputStream> clazz) {
        UNZIPERS.put(string, clazz);
    }

    protected static String getZipExpression() {
        return LoaderFactory.getExpression(UNZIPERS.keySet().iterator());
    }

    protected static String getLoaderExpression() {
        return LoaderFactory.getExpression(LOADERS.keySet().iterator());
    }

    private static String getExpression(Iterator<String> iterator) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("|");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static void registerLoader(String string, Class<? extends AbstractFileLoader> clazz) throws Exception {
        List<Class<? extends AbstractFileLoader>> list = LoaderFactory.prepareRegistration(string, clazz);
        if (!list.contains(clazz)) {
            list.add(clazz);
        }
    }

    public static void registerLoader(String string, Class<? extends AbstractFileLoader> clazz, int n) throws Exception {
        List<Class<? extends AbstractFileLoader>> list = LoaderFactory.prepareRegistration(string, clazz);
        if (!list.contains(clazz)) {
            list.add(n, clazz);
        }
    }

    private static List<Class<? extends AbstractFileLoader>> prepareRegistration(String string, Class<? extends AbstractFileLoader> clazz) throws Exception {
        block4: {
            try {
                clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clazz.getMethod("setFile", String.class) == null) {
                    throw new Exception("Loaders must have method setFile(String path)");
                }
                if (clazz.getConstructor(new Class[0]) != null) break block4;
                throw new Exception("Loaders must have a no argument constructor!");
            }
        }
        List<Class<? extends AbstractFileLoader>> list = LOADERS.get(string);
        if (list == null) {
            list = new ArrayList<Class<? extends AbstractFileLoader>>();
            LOADERS.put(string, list);
        }
        return list;
    }

    public static List<Class<? extends AbstractFileLoader>> clearLoader(String string) {
        return LOADERS.remove(string);
    }

    public static void setLoaderSearching(boolean bl) {
        searchingAllowed = bl;
    }

    protected static Class<? extends InputStream> getZipStream(String string) {
        return UNZIPERS.get(string);
    }
}

