/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import uk.ac.diamond.scisoft.analysis.dataset.AWTImageUtils;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class JavaImageSaver
implements IFileSaver {
    private String fileName = "";
    private String fileType = "";
    protected double maxVal;
    protected boolean unsigned = false;
    private int numBits;

    static {
        ImageIO.scanForPlugins();
    }

    public JavaImageSaver(String string, String string2, int n, boolean bl) {
        this.fileName = string;
        this.fileType = string2;
        this.numBits = n;
        if (this.numBits <= 32) {
            this.maxVal = (double)(1L << n) - 1.0;
            this.unsigned = bl;
        } else {
            this.maxVal = 1.0;
        }
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        File file = null;
        if (this.numBits <= 0) {
            throw new ScanFileHolderException("Number of bits specified must be greater than 0");
        }
        int n = 0;
        int n2 = dataHolder.size();
        while (n < n2) {
            try {
                boolean bl;
                Object object;
                String string = null;
                if (n2 == 1) {
                    string = this.fileName;
                } else {
                    try {
                        string = this.fileName.substring(0, this.fileName.lastIndexOf("."));
                    }
                    catch (Exception exception) {
                        string = this.fileName;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("00000");
                    string = String.valueOf(string) + decimalFormat.format(n + 1);
                }
                int n3 = string.lastIndexOf(".");
                if (n3 < 0) {
                    string = String.valueOf(string) + "." + this.fileType;
                }
                file = new File(string);
                AbstractDataset abstractDataset = dataHolder.getDataset(n);
                if (this.numBits <= 16) {
                    if (this.maxVal > 0.0 && abstractDataset.max().doubleValue() > this.maxVal) {
                        throw new ScanFileHolderException("The value of a pixel exceeds the maximum value that " + this.fileType + " is capable of handling. To save a " + this.fileType + " it is recommended to use a ScaledSaver class. File " + this.fileName + " not written");
                    }
                    if (this.unsigned && abstractDataset.min().doubleValue() < 0.0) {
                        throw new ScanFileHolderException("The value of a pixel is less than 0. Recommended using a ScaledSaver class.");
                    }
                    object = AWTImageUtils.makeBufferedImage(abstractDataset, this.numBits);
                    if (object == null) {
                        throw new ScanFileHolderException("Unable to create a buffered image to save file type");
                    }
                    bl = this.writeImageLocked((RenderedImage)object, this.fileType, file);
                    if (!bl) {
                        throw new ScanFileHolderException("No writer for '" + this.fileName + "' of type " + this.fileType);
                    }
                } else {
                    object = AWTImageUtils.makeTiledImage(abstractDataset, this.numBits);
                    if (object == null) {
                        throw new ScanFileHolderException("Unable to create a tiled image to save file type");
                    }
                    bl = this.writeImageLocked((RenderedImage)object, this.fileType, file);
                    if (!bl) {
                        throw new ScanFileHolderException("No writer for '" + this.fileName + "' of type " + this.fileType);
                    }
                }
            }
            catch (ScanFileHolderException scanFileHolderException) {
                throw scanFileHolderException;
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Error saving file '" + this.fileName + "'", exception);
            }
            ++n;
        }
    }

    private boolean writeImageLocked(RenderedImage renderedImage, String string, File file) throws Exception {
        return ImageIO.write(renderedImage, string, file);
    }
}

