/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AWTImageUtils;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class JavaImageLoader
extends AbstractFileLoader {
    protected static final transient Logger logger = LoggerFactory.getLogger(JavaImageLoader.class);
    protected String fileName = "";
    private String fileType = "";
    private boolean asGrey;
    private boolean keepBitWidth = false;

    public void setFile(String string) {
        this.fileName = string;
    }

    public boolean isKeepBitWidth() {
        return this.keepBitWidth;
    }

    public void setKeepBitWidth(boolean bl) {
        this.keepBitWidth = bl;
    }

    public JavaImageLoader(String string, String string2) {
        this(string, string2, false);
    }

    public JavaImageLoader(String string, String string2, boolean bl) {
        this(string, string2, bl, false);
    }

    public JavaImageLoader(String string, String string2, boolean bl, boolean bl2) {
        this.fileName = string;
        this.fileType = string2;
        this.asGrey = bl;
        this.keepBitWidth = bl2;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        AbstractDataset abstractDataset = null;
        File file = null;
        BufferedImage bufferedImage = null;
        file = new File(this.fileName);
        if (!file.exists()) {
            logger.warn("File, {}, did not exist. Now trying to replace suffix", (Object)this.fileName);
            file = this.findCorrectSuffix();
        }
        try {
            file = new File(this.fileName);
            bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                throw new ScanFileHolderException("File format in '" + this.fileName + "' cannot be read");
            }
        }
        catch (IOException iOException) {
            throw new ScanFileHolderException("IOException loading file '" + this.fileName + "'", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ScanFileHolderException("IllegalArgumentException interpreting file '" + this.fileName + "'", illegalArgumentException);
        }
        abstractDataset = this.createDataset(bufferedImage);
        abstractDataset.setName("image-01");
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset(this.fileName, abstractDataset);
        return dataHolder;
    }

    protected AbstractDataset createDataset(BufferedImage bufferedImage) throws ScanFileHolderException {
        AbstractDataset abstractDataset = null;
        try {
            AbstractDataset[] abstractDatasetArray = AWTImageUtils.makeDatasets(bufferedImage, this.keepBitWidth);
            int n = bufferedImage.getData().getNumBands();
            if (n == 1) {
                abstractDataset = abstractDatasetArray[0];
            } else {
                if (bufferedImage.getColorModel().getColorSpace().getType() != 5) {
                    throw new ScanFileHolderException("File does not contain RGB data");
                }
                if (n < 3) {
                    throw new ScanFileHolderException("Number of colour channels is less than three so cannot load and convert");
                }
                abstractDataset = new RGBDataset(abstractDatasetArray[0], abstractDatasetArray[1], abstractDatasetArray[2]);
                if (this.asGrey) {
                    abstractDataset = ((RGBDataset)abstractDataset).createGreyDataset(abstractDatasetArray[0].getDtype());
                }
            }
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("There was a problem loading the image", exception);
        }
        return abstractDataset;
    }

    protected File findCorrectSuffix() throws ScanFileHolderException {
        String string;
        int n;
        String[] stringArray = ImageIO.getReaderFileSuffixes();
        String string2 = this.fileName.substring(this.fileName.lastIndexOf(".") + 1);
        File file = null;
        if (!string2.equals(this.fileName)) {
            String[] stringArray2 = stringArray;
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = stringArray2[n2];
                if (!string2.equalsIgnoreCase(string)) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else if ((file = new File(string = String.valueOf(this.fileName) + "." + this.fileType)).exists()) {
            this.fileName = string;
        } else {
            String[] stringArray3 = stringArray;
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String string3 = stringArray3[n];
                string = String.valueOf(this.fileName) + "." + string3;
                file = new File(string);
                if (file.exists()) {
                    this.fileName = string;
                    break;
                }
                ++n;
            }
        }
        if (file == null || !file.exists()) {
            throw new ScanFileHolderException("Does not exist", new FileNotFoundException(this.fileName));
        }
        return file;
    }
}

