/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import java.io.FileNotFoundException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Comparisons;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.JPEGLoader;
import uk.ac.diamond.scisoft.analysis.io.JPEGSaver;
import uk.ac.diamond.scisoft.analysis.io.JPEGScaledSaver;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class JPEGTest {
    static String testScratchDirectoryName = null;
    AbstractDataset data;
    DataHolder dh = new DataHolder();
    DataHolder dhLoad = new DataHolder();
    int sizex = 500;
    int sizey = 500;
    int range = this.sizex * this.sizey;
    double abserr = 2.0;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)JPEGTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void testSaveFile() throws Exception {
        String string = "testSaveFile.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 255.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        AbstractDataset abstractDataset = dataHolder2.getDataset(0);
        Number number = abstractDataset.min();
        Number number2 = abstractDataset.peakToPeak();
        abstractDataset = Maths.multiply(Maths.subtract((Object)abstractDataset, number), this.data.max().doubleValue() / number2.doubleValue());
        Assert.assertTrue((String)"Saved and loaded datasets are not equal", (boolean)Comparisons.allTrue(Comparisons.almostEqualTo(abstractDataset, this.data, 1.0E-5, 2.0)));
    }

    @Test
    public void testLoaderFactory() throws Exception {
        String string = "testLoaderFactory.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 255.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = LoaderFactory.getData(String.valueOf(testScratchDirectoryName) + string, null);
        if (dataHolder2 == null || dataHolder2.getNames().length < 1) {
            throw new Exception();
        }
    }

    @Test
    public void manyImages() throws ScanFileHolderException {
        String string = "manyImages.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 255.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new JPEGSaver(String.valueOf(testScratchDirectoryName) + "ManyImages" + string).saveFile(dataHolder);
    }

    @Test
    public void manyImagesScaled() throws ScanFileHolderException {
        String string = "manyImagesScaled.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 3);
        this.data.setShape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + "ManyImagesScaled" + string).saveFile(dataHolder);
    }

    @Test
    public void compareDataset() throws ScanFileHolderException {
        String string = "compareDataset.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 255.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        AbstractDataset abstractDataset = dataHolder2.getDataset(0);
        Number number = abstractDataset.min();
        Number number2 = abstractDataset.peakToPeak();
        abstractDataset = Maths.multiply(Maths.subtract((Object)abstractDataset, number), this.data.max().doubleValue() / number2.doubleValue());
        Assert.assertTrue((String)"Saved and loaded datasets are not equal", (boolean)Comparisons.allTrue(Comparisons.almostEqualTo(abstractDataset, this.data, 1.0E-5, 2.0)));
    }

    @Test
    public void compareScaledDataset() throws ScanFileHolderException {
        String string = "compareScaledDataset.jpg";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 5);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        AbstractDataset abstractDataset = DatasetUtils.norm(this.data);
        abstractDataset.imultiply(255);
        Assert.assertTrue((String)"Saved and loaded datasets are not equal", (boolean)Comparisons.allTrue(Comparisons.almostEqualTo(abstractDataset, dataHolder2.getDataset(0), 1.0E-5, 2.0)));
    }

    @Test
    public void noEnding() throws Exception {
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 5);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + "noEnding.jpg").saveFile(dataHolder);
        this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + "noEnding").loadFile();
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + "noEnding1").saveFile(this.dh);
    }

    @Test
    public void incorrectEnding() throws Exception {
        String string = "incorrectEnding.txt";
        String string2 = "incorrectEnding1.txt";
        this.data = DatasetUtils.linSpace(0.0, 126.0, this.range, 1);
        this.data.setShape(this.sizex, this.sizey);
        DataHolder dataHolder = new DataHolder();
        dataHolder.addDataset("testing data", this.data);
        new JPEGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        new JPEGSaver(String.valueOf(testScratchDirectoryName) + string2).saveFile(dataHolder);
        this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + string2).loadFile();
    }

    @Test
    public void testNoFile() throws ScanFileHolderException {
        block2: {
            try {
                this.dh = new JPEGLoader(String.valueOf(testScratchDirectoryName) + "NoFile.jpeg").loadFile();
            }
            catch (ScanFileHolderException scanFileHolderException) {
                if (scanFileHolderException.getCause() instanceof FileNotFoundException) break block2;
                throw scanFileHolderException;
            }
        }
    }
}

