/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ImageStackLoaderEx;
import uk.ac.diamond.scisoft.analysis.io.TIFFImageSaver;

public class ImageStackLoaderExTest {
    static final int sizex = 10;
    static final int sizey = 20;
    static final int range = 200;
    static final double abserr = 2.0;

    @Before
    public void setUp() {
    }

    @Test
    public void testInvalidArguments() throws Exception {
        try {
            String[] stringArray = null;
            int[] nArray = null;
            ImageStackLoaderEx imageStackLoaderEx = new ImageStackLoaderEx(nArray, stringArray);
            int[] nArray2 = null;
            int[] nArray3 = null;
            int[] nArray4 = null;
            int[] nArray5 = null;
            imageStackLoaderEx.getDataset(null, nArray3, nArray5, nArray4, nArray2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void makeFile(String string, Object object) throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        AbstractDataset abstractDataset = DatasetUtils.eye(10, 20, 0, 2);
        abstractDataset.setShape(10, 20);
        abstractDataset.imultiply(object);
        dataHolder.addDataset("testing data", abstractDataset);
        new TIFFImageSaver(string, 16, false).saveFile(dataHolder);
    }

    @Test
    public void test1DFiles() throws Exception {
        int n;
        AbstractDataset abstractDataset;
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        String string = TestUtils.setUpTest(ImageStackLoaderExTest.class, (String)"test1DFiles", (boolean)true);
        int[] nArray4 = new int[]{2, 3};
        String[] stringArray = this.makeFiles(string, nArray4);
        int[] nArray5 = new int[]{stringArray.length};
        ImageStackLoaderEx imageStackLoaderEx = new ImageStackLoaderEx(nArray5, stringArray);
        Assert.assertEquals((long)3L, (long)imageStackLoaderEx.getDtype());
        int[] nArray6 = imageStackLoaderEx.getShape();
        Assert.assertArrayEquals((int[])new int[]{2, 10, 20}, (int[])nArray6);
        int n2 = 0;
        while (n2 < nArray4.length) {
            nArray3 = null;
            nArray2 = new int[]{n2 + 1, 10, 20};
            int[] nArray7 = new int[3];
            nArray7[0] = n2;
            nArray7[1] = 9;
            nArray = nArray7;
            abstractDataset = imageStackLoaderEx.getDataset(null, nArray6, nArray, nArray2, nArray3);
            Assert.assertArrayEquals((int[])new int[]{1, 1, 20}, (int[])abstractDataset.getShape());
            n = abstractDataset.getInt(0, 0, 9);
            Assert.assertEquals((long)nArray4[n2], (long)n);
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray4.length) {
            nArray3 = null;
            nArray2 = new int[]{n2 + 1, 10, 20};
            int[] nArray8 = new int[3];
            nArray8[0] = n2;
            nArray8[1] = 9;
            nArray = nArray8;
            abstractDataset = imageStackLoaderEx.getDataset(null, nArray6, nArray, nArray2, nArray3);
            Assert.assertArrayEquals((int[])new int[]{1, 1, 20}, (int[])abstractDataset.getShape());
            n = abstractDataset.getInt(0, 0, 9);
            Assert.assertEquals((long)nArray4[n2], (long)n);
            ++n2;
        }
    }

    @Test
    public void test1DFilesSliceAcrossFiles() throws Exception {
        String string = TestUtils.setUpTest(ImageStackLoaderExTest.class, (String)"test1DFilesSliceAcrossFiles", (boolean)true);
        int[] nArray = new int[]{2, 3, 4, 5, 6};
        String[] stringArray = this.makeFiles(string, nArray);
        int[] nArray2 = new int[]{stringArray.length};
        ImageStackLoaderEx imageStackLoaderEx = new ImageStackLoaderEx(nArray2, stringArray);
        Assert.assertEquals((long)3L, (long)imageStackLoaderEx.getDtype());
        int[] nArray3 = imageStackLoaderEx.getShape();
        Assert.assertArrayEquals((int[])new int[]{nArray.length, 10, 20}, (int[])nArray3);
        int[] nArray4 = null;
        int[] nArray5 = new int[]{nArray.length, 10, 20};
        int[] nArray6 = new int[3];
        AbstractDataset abstractDataset = imageStackLoaderEx.getDataset(null, nArray3, nArray6, nArray5, nArray4);
        Assert.assertArrayEquals((int[])nArray5, (int[])abstractDataset.getShape());
        int n = abstractDataset.getInt(0, 9, 9);
        Assert.assertEquals((long)nArray[0], (long)n);
        int n2 = abstractDataset.getInt(nArray.length - 1, 9, 9);
        Assert.assertEquals((long)nArray[nArray.length - 1], (long)n2);
        nArray4 = new int[]{1, 1, 2};
        nArray5 = new int[]{nArray.length, 10, 20};
        nArray6 = new int[3];
        abstractDataset = imageStackLoaderEx.getDataset(null, nArray3, nArray6, nArray5, nArray4);
        Assert.assertArrayEquals((int[])new int[]{nArray.length, 10, 10}, (int[])abstractDataset.getShape());
        n = abstractDataset.getInt(0, 8, 4);
        Assert.assertEquals((long)nArray[0], (long)n);
        n2 = abstractDataset.getInt(nArray.length - 1, 8, 4);
        Assert.assertEquals((long)nArray[nArray.length - 1], (long)n2);
        nArray4 = new int[]{1, 2, 1};
        nArray5 = new int[]{nArray.length, 10, 20};
        nArray6 = new int[3];
        abstractDataset = imageStackLoaderEx.getDataset(null, nArray3, nArray6, nArray5, nArray4);
        Assert.assertArrayEquals((int[])new int[]{nArray.length, 5, 20}, (int[])abstractDataset.getShape());
        n = abstractDataset.getInt(0, 4, 8);
        Assert.assertEquals((long)nArray[0], (long)n);
        n2 = abstractDataset.getInt(nArray.length - 1, 4, 8);
        Assert.assertEquals((long)nArray[nArray.length - 1], (long)n2);
        nArray4 = null;
        nArray5 = new int[]{nArray.length, 10, 10};
        int[] nArray7 = new int[3];
        nArray7[1] = 9;
        nArray7[2] = 9;
        nArray6 = nArray7;
        abstractDataset = imageStackLoaderEx.getDataset(null, nArray3, nArray6, nArray5, nArray4);
        Assert.assertArrayEquals((int[])new int[]{nArray.length, 1, 1}, (int[])abstractDataset.getShape());
        n = 0;
        while (n < nArray.length) {
            n2 = abstractDataset.getInt(n, 0, 0);
            Assert.assertEquals((long)nArray[n], (long)n2);
            ++n;
        }
    }

    String[] makeFiles(String string, int[] nArray) throws ScanFileHolderException {
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = String.valueOf(string) + File.separatorChar + "test" + n + ".tif";
            this.makeFile(stringArray[n], new Integer(nArray[n]));
            ++n;
        }
        return stringArray;
    }

    @Test
    public void test2DFiles() throws Exception {
        int n;
        AbstractDataset abstractDataset;
        int[] nArray;
        Object object;
        int[] nArray2;
        int n2;
        String string = TestUtils.setUpTest(ImageStackLoaderExTest.class, (String)"test2DFiles", (boolean)true);
        int[] nArray3 = new int[]{1, 2, 3, 4, 5, 6};
        String[] stringArray = this.makeFiles(string, nArray3);
        int[] nArray4 = new int[]{2, 3};
        ImageStackLoaderEx imageStackLoaderEx = new ImageStackLoaderEx(nArray4, stringArray);
        Assert.assertEquals((long)3L, (long)imageStackLoaderEx.getDtype());
        int[] nArray5 = imageStackLoaderEx.getShape();
        Assert.assertArrayEquals((int[])new int[]{2, 3, 10, 20}, (int[])nArray5);
        int n3 = 0;
        while (n3 < 2) {
            n2 = 0;
            while (n2 < 3) {
                nArray2 = null;
                object = new int[]{n3 + 1, n2 + 1, 10, 20};
                int[] nArray6 = new int[4];
                nArray6[0] = n3;
                nArray6[1] = n2;
                nArray = nArray6;
                abstractDataset = imageStackLoaderEx.getDataset(null, nArray5, nArray, (int[])object, nArray2);
                Assert.assertArrayEquals((int[])new int[]{1, 1, 10, 20}, (int[])abstractDataset.getShape());
                n = abstractDataset.getInt(0, 0, 9, 9);
                Assert.assertEquals((String)("Check value for image i:" + n3 + " j:" + n2), (long)nArray3[n3 * 3 + n2], (long)n);
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < 2) {
            n2 = 0;
            while (n2 < 3) {
                nArray2 = null;
                object = new int[]{n3 + 1, n2 + 1, 10, 20};
                int[] nArray7 = new int[4];
                nArray7[0] = n3;
                nArray7[1] = n2;
                nArray7[2] = 9;
                nArray = nArray7;
                abstractDataset = imageStackLoaderEx.getDataset(null, nArray5, nArray, (int[])object, nArray2);
                Assert.assertArrayEquals((int[])new int[]{1, 1, 1, 20}, (int[])abstractDataset.getShape());
                n = abstractDataset.getInt(0, 0, 0, 9);
                Assert.assertEquals((String)("Check value for image i:" + n3 + " j:" + n2), (long)nArray3[n3 * 3 + n2], (long)n);
                ++n2;
            }
            ++n3;
        }
        int[] nArray8 = null;
        int[] nArray9 = new int[]{2, 3, 10, 20};
        nArray2 = new int[4];
        object = imageStackLoaderEx.getDataset(null, nArray5, nArray2, nArray9, nArray8);
        Assert.assertArrayEquals((int[])nArray9, (int[])((AbstractDataset)object).getShape());
        int n4 = object.getInt(0, 0, 9, 9);
        Assert.assertEquals((long)nArray3[0], (long)n4);
        int n5 = object.getInt(1, 2, 9, 9);
        Assert.assertEquals((long)nArray3[nArray3.length - 1], (long)n5);
        nArray8 = new int[]{1, 1, 1, 2};
        nArray9 = new int[]{2, 3, 10, 20};
        nArray2 = new int[4];
        object = imageStackLoaderEx.getDataset(null, nArray5, nArray2, nArray9, nArray8);
        Assert.assertArrayEquals((int[])new int[]{2, 3, 10, 10}, (int[])((AbstractDataset)object).getShape());
        n4 = object.getInt(0, 0, 8, 4);
        Assert.assertEquals((long)nArray3[0], (long)n4);
        n5 = object.getInt(1, 2, 8, 4);
        Assert.assertEquals((long)nArray3[nArray3.length - 1], (long)n5);
        nArray8 = null;
        nArray9 = new int[]{2, 3, 10, 10};
        int[] nArray10 = new int[4];
        nArray10[2] = 9;
        nArray10[3] = 9;
        nArray2 = nArray10;
        object = imageStackLoaderEx.getDataset(null, nArray5, nArray2, nArray9, nArray8);
        Assert.assertArrayEquals((int[])new int[]{2, 3, 1, 1}, (int[])((AbstractDataset)object).getShape());
        n4 = 0;
        while (n4 < 2) {
            n5 = 0;
            while (n5 < 3) {
                n = object.getInt(n4, n5, 0, 0);
                Assert.assertEquals((long)nArray3[n4 * 3 + n5], (long)n);
                ++n5;
            }
            ++n4;
        }
    }
}

