/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.util.Arrays;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractDatasetRecord;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ILazyLoader;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.gda.monitor.IMonitor;

public class ImageStackLoaderEx
implements ILazyLoader {
    String[] imageFilenames;
    int[] shape;
    int dtype;
    int[] dimensions;
    private int[] data_shapes;
    AbstractDatasetRecord cache;
    String parent;

    public int getDtype() {
        return this.dtype;
    }

    public ImageStackLoaderEx(int[] nArray, String[] stringArray) throws Exception {
        this(nArray, stringArray, null);
    }

    public ImageStackLoaderEx(int[] nArray, String[] stringArray, String string) throws Exception {
        Object object;
        if (nArray == null || nArray.length < 1 || nArray.length > 2) {
            throw new IllegalArgumentException("dimensions invalid");
        }
        int n = AbstractDataset.calcSize(nArray);
        if (stringArray == null || stringArray.length != n) {
            throw new IllegalArgumentException("imageFilenames.length != " + n);
        }
        if (string != null && !((File)(object = new File(string))).isDirectory()) {
            throw new IllegalArgumentException("Given directory is not a directory");
        }
        this.parent = string;
        this.imageFilenames = stringArray;
        this.dimensions = nArray;
        object = new int[nArray.length];
        Arrays.fill((int[])object, 0);
        AbstractDataset abstractDataset = this.getDataSetFromFile((int[])object, null);
        this.dtype = abstractDataset.getDtype();
        this.data_shapes = abstractDataset.getShape();
        this.shape = Arrays.copyOf(nArray, nArray.length + this.data_shapes.length);
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < this.data_shapes.length) {
            this.shape[n3 + n2] = this.data_shapes[n3];
            ++n3;
        }
    }

    String getFilename(int[] nArray) {
        if (this.dimensions.length == 1) {
            return this.imageFilenames[nArray[0]];
        }
        if (this.dimensions.length == 2) {
            return this.imageFilenames[nArray[0] * this.dimensions[1] + nArray[1]];
        }
        return null;
    }

    private AbstractDataset getDataSetFromFile(int[] nArray, IMonitor iMonitor) throws ScanFileHolderException {
        if (this.cache == null || !Arrays.equals(nArray, this.cache.location)) {
            Object object;
            String string = this.getFilename(nArray);
            if (this.parent != null) {
                object = new File(string);
                if (((File)object).isAbsolute()) {
                    string = ((File)object).getName();
                }
                string = new File(this.parent, string).getAbsolutePath();
            }
            object = null;
            try {
                object = LoaderFactory.getData(string, iMonitor);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Cannot load image in image stack", exception);
            }
            if (object == null) {
                throw new ScanFileHolderException("Cannot load image in image stack");
            }
            AbstractDataset abstractDataset = ((DataHolder)object).getDataset(0);
            abstractDataset.setName(string);
            this.cache = new AbstractDatasetRecord(abstractDataset, nArray);
        }
        return this.cache.dataset;
    }

    @Override
    public boolean isFileReadable() {
        return true;
    }

    @Override
    public AbstractDataset getDataset(IMonitor iMonitor, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) throws ScanFileHolderException {
        if (nArray4 == null) {
            nArray4 = new int[nArray.length];
            Arrays.fill(nArray4, 1);
        }
        AbstractDataset.checkSlice(this.shape, nArray2, nArray3, nArray2, nArray3, nArray4);
        int[] nArray5 = AbstractDataset.checkSlice(nArray, nArray2, nArray3, nArray2, nArray3, nArray4);
        AbstractDataset abstractDataset = AbstractDataset.zeros(nArray5, this.dtype);
        int[] nArray6 = new int[nArray5.length];
        Arrays.fill(nArray6, 0);
        int[] nArray7 = new int[nArray4.length];
        Arrays.fill(nArray7, 1);
        int[] nArray8 = new int[nArray2.length];
        Arrays.fill(nArray8, 0);
        int[] nArray9 = new int[nArray2.length];
        Arrays.fill(nArray9, 1);
        int n = this.dimensions.length;
        while (n < nArray2.length) {
            nArray9[n] = nArray5[n];
            ++n;
        }
        do {
            int[] nArray10 = Arrays.copyOfRange(nArray2, 0, this.dimensions.length);
            int n2 = 0;
            while (n2 < nArray10.length) {
                int n3 = n2;
                nArray10[n3] = nArray10[n3] + nArray8[n2];
                ++n2;
            }
            AbstractDataset abstractDataset2 = this.getDataSetFromFile(nArray10, iMonitor);
            int[] nArray11 = Arrays.copyOfRange(nArray2, this.dimensions.length, nArray2.length);
            int[] nArray12 = Arrays.copyOfRange(nArray3, this.dimensions.length, nArray2.length);
            int[] nArray13 = Arrays.copyOfRange(nArray4, this.dimensions.length, nArray2.length);
            AbstractDataset abstractDataset3 = abstractDataset2.getSlice(nArray11, nArray12, nArray13);
            try {
                abstractDataset.setSlice((Object)abstractDataset3, nArray8, nArray9, nArray7);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error adding slice", exception);
            }
        } while (this.addStep(nArray8, nArray9, nArray6, nArray5, nArray4, this.dimensions.length - 1));
        return abstractDataset;
    }

    private boolean addStep(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n) {
        if (n < 0) {
            return false;
        }
        int n2 = nArray[n] + nArray5[n];
        if (n2 < nArray4[n]) {
            nArray[n] = n2;
            nArray2[n] = n2 + 1;
            return true;
        }
        nArray[n] = nArray3[n];
        nArray2[n] = nArray3[n] + 1;
        return this.addStep(nArray, nArray2, nArray3, nArray4, nArray5, n - 1);
    }

    public int[] getShape() {
        return this.shape;
    }
}

