/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.util.Arrays;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ILazyLoader;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.gda.monitor.IMonitor;

public class ImageStackLoader
implements ILazyLoader {
    List<String> imageFilenames;
    int[] shape;
    int dtype;

    public int getDtype() {
        return this.dtype;
    }

    public ImageStackLoader(List<String> list) throws Exception {
        this.imageFilenames = list;
        int n = list.size();
        DataHolder dataHolder = LoaderFactory.getData(list.get(0), null);
        if (dataHolder == null) {
            throw new ScanFileHolderException("Unable to load " + list.get(0));
        }
        AbstractDataset abstractDataset = dataHolder.getDataset(0);
        this.dtype = abstractDataset.getDtype();
        int[] nArray = abstractDataset.getShape();
        this.shape = new int[nArray.length + 1];
        this.shape[0] = n;
        int n2 = 0;
        while (n2 < nArray.length) {
            this.shape[n2 + 1] = nArray[n2];
            ++n2;
        }
    }

    @Override
    public boolean isFileReadable() {
        return true;
    }

    @Override
    public AbstractDataset getDataset(IMonitor iMonitor, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) throws ScanFileHolderException {
        if (nArray4 == null) {
            nArray4 = new int[nArray.length];
            Arrays.fill(nArray4, 1);
        }
        int[] nArray5 = AbstractDataset.checkSlice(nArray, nArray2, nArray3, nArray2, nArray3, nArray4);
        AbstractDataset abstractDataset = AbstractDataset.zeros(nArray5, this.dtype);
        int n = nArray2[0];
        int n2 = 0;
        while (n < nArray3[0]) {
            DataHolder dataHolder;
            try {
                dataHolder = LoaderFactory.getData(this.imageFilenames.get(n), iMonitor);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Cannot load image in image stack", exception);
            }
            AbstractDataset abstractDataset2 = dataHolder.getDataset(0);
            int[] nArray6 = new int[]{nArray2[1], nArray2[2]};
            int[] nArray7 = new int[]{nArray3[1], nArray3[2]};
            int[] nArray8 = new int[]{nArray4[1], nArray4[2]};
            AbstractDataset abstractDataset3 = abstractDataset2.getSlice(nArray6, nArray7, nArray8);
            int[] nArray9 = new int[3];
            nArray9[0] = n2;
            int[] nArray10 = nArray9;
            int[] nArray11 = new int[]{n2 + 1, nArray5[1], nArray5[2]};
            int[] nArray12 = new int[]{1, 1, 1};
            abstractDataset.setSlice((Object)abstractDataset3, nArray10, nArray11, nArray12);
            n += nArray4[0];
            ++n2;
        }
        return abstractDataset;
    }

    public int[] getShape() {
        return this.shape;
    }
}

