/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ncsa.hdf.object.h5.H5File;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;
import uk.ac.diamond.scisoft.analysis.dataset.StringDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.HDF5Loader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;

public class HDF5LoaderTest {
    static final String TestFileFolder = "testfiles/gda/analysis/io/NexusLoaderTest/";

    private void checkDataset(String string, IDataset iDataset, int[] nArray) {
        int[] nArray2 = iDataset.getShape();
        Assert.assertEquals((String)("Rank of " + string), (long)nArray.length, (long)nArray2.length);
        int n = 0;
        while (n < nArray.length) {
            Assert.assertEquals((String)("Dim of " + string), (long)nArray[n], (long)nArray2[n]);
            ++n;
        }
    }

    @Test
    public void testLoadingSpeed() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        String string = "testfiles/gda/analysis/io/NexusLoaderTest/manygroups.h5";
        int n = 0;
        while (n < 3) {
            long l = -System.currentTimeMillis();
            try {
                HDF5Loader hDF5Loader = new HDF5Loader(string);
                hDF5Loader.loadTree(null);
            }
            catch (ScanFileHolderException scanFileHolderException) {}
            arrayList.add(l += System.currentTimeMillis());
            l = -System.currentTimeMillis();
            try {
                new H5File(string, 0).open();
            }
            catch (Exception exception) {}
            arrayList2.add(l += System.currentTimeMillis());
            ++n;
        }
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        System.out.printf("Load took %d ms cf %d ms", arrayList.get(0), arrayList2.get(0));
    }

    @Test
    public void testLoadingStrings() throws ScanFileHolderException {
        String string = "testfiles/gda/analysis/io/NexusLoaderTest/strings1d.h5";
        HDF5Loader hDF5Loader = new HDF5Loader(string);
        hDF5Loader.loadTree(null);
        string = "testfiles/gda/analysis/io/NexusLoaderTest/strings2d.h5";
        hDF5Loader = new HDF5Loader(string);
        hDF5Loader.loadTree(null);
    }

    @Test
    public void testLoadingTest() throws ScanFileHolderException {
        String string = "testfiles/gda/analysis/io/NexusLoaderTest/testlinks.nxs";
        HDF5Loader hDF5Loader = new HDF5Loader(string);
        HDF5File hDF5File = hDF5Loader.loadTree(null);
        System.out.println(hDF5File.getNodeLink());
        String string2 = "original";
        List<ILazyDataset> list = hDF5File.getGroup().getDatasets("d1");
        Assert.assertEquals((String)("Number of " + string2), (long)1L, (long)list.size());
        IDataset iDataset = list.get(0).getSlice(new Slice[0]);
        this.checkDataset(string2, iDataset, new int[]{25, 3});
        Assert.assertEquals((String)("Value in " + string2), (long)1L, (long)iDataset.getInt(0, 1));
        Assert.assertEquals((String)("Value in " + string2), (long)5L, (long)iDataset.getInt(1, 2));
        Assert.assertEquals((String)("Value in " + string2), (long)37L, (long)iDataset.getInt(12, 1));
        string2 = "hard link";
        list = hDF5File.getGroup().getDatasets("d_hl");
        Assert.assertEquals((String)("Number of " + string2), (long)1L, (long)list.size());
        iDataset = list.get(0).getSlice(new Slice[0]);
        this.checkDataset(string2, iDataset, new int[]{25, 3});
        Assert.assertEquals((String)("Value in " + string2), (long)1L, (long)iDataset.getInt(0, 1));
        Assert.assertEquals((String)("Value in " + string2), (long)5L, (long)iDataset.getInt(1, 2));
        Assert.assertEquals((String)("Value in " + string2), (long)37L, (long)iDataset.getInt(12, 1));
        string2 = "soft link";
        list = hDF5File.getGroup().getDatasets("d_sl");
        Assert.assertEquals((String)("Number of " + string2), (long)1L, (long)list.size());
        iDataset = list.get(0).getSlice(new Slice[0]);
        this.checkDataset(string2, iDataset, new int[]{25, 3});
        Assert.assertEquals((String)("Value in " + string2), (long)1L, (long)iDataset.getInt(0, 1));
        Assert.assertEquals((String)("Value in " + string2), (long)5L, (long)iDataset.getInt(1, 2));
        Assert.assertEquals((String)("Value in " + string2), (long)37L, (long)iDataset.getInt(12, 1));
        string2 = "external link";
        list = hDF5File.getGroup().getDatasets("d_el");
        Assert.assertEquals((String)("Number of " + string2), (long)1L, (long)list.size());
        iDataset = list.get(0).getSlice(new Slice[0]);
        this.checkDataset(string2, iDataset, new int[]{2, 5});
        Assert.assertEquals((String)("Value of " + string2), (double)1.0, (double)iDataset.getDouble(0, 1), (double)1.0E-8);
        Assert.assertEquals((String)("Value of " + string2), (double)9.0, (double)iDataset.getDouble(1, 4), (double)1.0E-8);
        string2 = "NAPI";
        list = hDF5File.getGroup().getDatasets("extdst");
        Assert.assertEquals((String)("Number of " + string2), (long)1L, (long)list.size());
        iDataset = list.get(0).getSlice(new Slice[0]);
        this.checkDataset(string2, iDataset, new int[]{2, 5});
        Assert.assertEquals((String)("Value of " + string2), (double)1.0, (double)iDataset.getDouble(0, 1), (double)1.0E-8);
        Assert.assertEquals((String)("Value of " + string2), (double)9.0, (double)iDataset.getDouble(1, 4), (double)1.0E-8);
        System.out.println(hDF5File.findNodeLink("/entry1/to/this/level"));
    }

    @Test
    public void testLoading() throws ScanFileHolderException {
        String string = "testfiles/gda/analysis/io/NexusLoaderTest/FeKedge_1_15.nxs";
        HDF5Loader hDF5Loader = new HDF5Loader(string);
        HDF5File hDF5File = hDF5Loader.loadTree(null);
        System.out.println(hDF5File.getNodeLink());
        HDF5NodeLink hDF5NodeLink = hDF5File.findNodeLink("/");
        Assert.assertTrue((String)"Not a group", (boolean)hDF5NodeLink.isDestinationAGroup());
        Assert.assertTrue((String)"Wrong name", (boolean)hDF5NodeLink.getName().equals("/"));
        hDF5NodeLink = hDF5File.findNodeLink("/entry1");
        Assert.assertTrue((String)"Not a group", (boolean)hDF5NodeLink.isDestinationAGroup());
        Assert.assertTrue((String)"Wrong name", (boolean)hDF5NodeLink.getName().equals("entry1"));
        hDF5NodeLink = hDF5File.findNodeLink("/entry1/FFI0");
        Assert.assertTrue((String)"Not a group", (boolean)hDF5NodeLink.isDestinationAGroup());
        Assert.assertTrue((String)"Wrong name", (boolean)hDF5NodeLink.getName().equals("FFI0"));
        hDF5NodeLink = hDF5File.findNodeLink("/entry1/FFI0/Energy");
        Assert.assertTrue((String)"Not a group", (boolean)hDF5NodeLink.isDestinationADataset());
        Assert.assertTrue((String)"Wrong name", (boolean)hDF5NodeLink.getName().equals("Energy"));
        hDF5NodeLink = hDF5File.getGroup().getNodeLink("entry1");
        System.out.println(hDF5NodeLink);
        hDF5NodeLink = ((HDF5Group)hDF5NodeLink.getDestination()).getNodeLink("FFI0");
        System.out.println(hDF5NodeLink);
        String string2 = "Energy";
        hDF5NodeLink = ((HDF5Group)hDF5NodeLink.getDestination()).getNodeLink(string2);
        System.out.println(hDF5NodeLink);
        List<ILazyDataset> list = hDF5File.getGroup().getDatasets(string2);
        Assert.assertEquals((String)("Number of " + string2), (long)1L, (long)list.size());
        IDataset iDataset = list.get(0).getSlice(new Slice[0]);
        this.checkDataset(string2, iDataset, new int[]{489});
        Assert.assertEquals((String)("Value of " + string2), (double)6922.0, (double)iDataset.getDouble(2), (double)6.922E-5);
        Assert.assertEquals((String)("Value of " + string2), (double)7944.5, (double)iDataset.getDouble(479), (double)7.9445E-5);
        hDF5NodeLink = hDF5File.findNodeLink("/entry1/user01/username");
        System.out.println(hDF5NodeLink);
        HDF5Node hDF5Node = hDF5NodeLink.getDestination();
        Assert.assertTrue((String)"Dataset node", (boolean)(hDF5Node instanceof HDF5Dataset));
        HDF5Dataset hDF5Dataset = (HDF5Dataset)hDF5Node;
        Assert.assertTrue((String)"String dataset", (boolean)hDF5Dataset.isString());
        AbstractDataset abstractDataset = (AbstractDataset)hDF5Dataset.getDataset();
        Assert.assertEquals((String)"Username", (Object)"rjw82", (Object)abstractDataset.getString(0));
    }

    @Test
    public void testLoadingMetadata() throws Exception {
        String string = "testfiles/gda/analysis/io/NexusLoaderTest/FeKedge_1_15.nxs";
        HDF5Loader hDF5Loader = new HDF5Loader(string);
        IMetaData iMetaData = hDF5Loader.loadFile().getMetadata();
        System.out.println(iMetaData.getMetaNames());
        Assert.assertTrue((String)"Wrong version", (boolean)iMetaData.getMetaValue("/@NeXus_version").equals("4.2.0"));
        Assert.assertTrue((String)"Wrong axis value", (boolean)iMetaData.getMetaValue("/entry1/FFI0/Energy@axis").equals("1"));
        Assert.assertTrue((String)"Wrong name", (boolean)iMetaData.getMetaValue("/entry1/instrument/source/name").equals("DLS"));
        Assert.assertTrue((String)"Wrong voltage", (boolean)iMetaData.getMetaValue("/entry1/instrument/source/voltage").equals("-1000.0000"));
    }

    @Test
    public void testLoadingChunked() throws ScanFileHolderException {
        String string = String.valueOf(TestUtils.getGDALargeTestFilesLocation()) + "/NexusUITest/sino.h5";
        HDF5Loader hDF5Loader = new HDF5Loader(string);
        HDF5File hDF5File = hDF5Loader.loadTree(null);
        HDF5NodeLink hDF5NodeLink = hDF5File.findNodeLink("/RawDCT/data");
        HDF5Node hDF5Node = hDF5NodeLink.getDestination();
        Assert.assertTrue((String)"Dataset node", (boolean)(hDF5Node instanceof HDF5Dataset));
        HDF5Dataset hDF5Dataset = (HDF5Dataset)hDF5Node;
        AbstractDataset abstractDataset = (AbstractDataset)hDF5Dataset.getDataset().getSlice(new Slice(1), new Slice(1), null);
        this.checkDataset("data", abstractDataset, new int[]{1, 1, 1481});
        double d = ((Number)abstractDataset.sum()).doubleValue();
        System.err.println(d);
        Assert.assertEquals((String)"Value of sum", (double)164.12514, (double)d, (double)(d * 1.0E-5));
        abstractDataset = (AbstractDataset)hDF5Dataset.getDataset().getSlice(new Slice(1), new Slice(null, null, 3), null);
        this.checkDataset("data", abstractDataset, new int[]{1, 75, 1481});
        d = ((Number)abstractDataset.sum()).doubleValue();
        System.err.println(d);
        Assert.assertEquals((String)"Value of sum", (double)40271.562, (double)d, (double)(d * 1.0E-5));
        abstractDataset = (AbstractDataset)hDF5Dataset.getDataset().getSlice(new Slice(1), new Slice(null, null, 3), new Slice(2));
        this.checkDataset("data", abstractDataset, new int[]{1, 75, 2});
        d = ((Number)abstractDataset.sum()).doubleValue();
        System.err.println(d);
        Assert.assertEquals((String)"Value of sum", (double)3.7149904, (double)d, (double)(d * 1.0E-5));
        abstractDataset = (AbstractDataset)hDF5Dataset.getDataset().getSlice(new Slice(null, null, 2), new Slice(1), null);
        this.checkDataset("data", abstractDataset, new int[]{31, 1, 1481});
        d = ((Number)abstractDataset.sum()).doubleValue();
        System.err.println(d);
        Assert.assertEquals((String)"Value of sum", (double)10522.864, (double)d, (double)(d * 1.0E-5));
        abstractDataset = (AbstractDataset)hDF5Dataset.getDataset().getSlice(new Slice(null, null, 2), new Slice(null, null, 3), null);
        this.checkDataset("data", abstractDataset, new int[]{31, 75, 1481});
        d = ((Number)abstractDataset.sum()).doubleValue();
        System.err.println(d);
        Assert.assertEquals((String)"Value of sum", (double)1640010.1, (double)d, (double)(d * 0.001));
        abstractDataset = (AbstractDataset)hDF5Dataset.getDataset().getSlice(new Slice(null, null, 2), new Slice(null, null, 3), new Slice(2));
        this.checkDataset("data", abstractDataset, new int[]{31, 75, 2});
        d = ((Number)abstractDataset.sum()).doubleValue();
        System.err.println(d);
        Assert.assertEquals((String)"Value of sum", (double)137.25012, (double)d, (double)(d * 1.0E-5));
        abstractDataset = (AbstractDataset)hDF5Dataset.getDataset().getSlice(new Slice(null, null, 2), new Slice(null, null, 3), new Slice(1, 2));
        this.checkDataset("data", abstractDataset, new int[]{31, 75, 1});
        d = ((Number)abstractDataset.sum()).doubleValue();
        System.err.println(d);
        Assert.assertEquals((String)"Value of sum", (double)64.191261, (double)d, (double)(d * 1.0E-5));
    }

    @Test
    public void testCanonicalization() {
        String[] stringArray = new String[]{"/asd/sdf/dfg/../ds/../../gfd", "/asd/asd/../as", "/asd/as/.././bad", "/asd/..", "/abal/."};
        String[] stringArray2 = new String[]{"/asd/gfd", "/asd/as", "/asd/bad", "/", "/abal"};
        int n = 0;
        while (n < stringArray.length) {
            Assert.assertEquals((String)"Path", (Object)stringArray2[n], (Object)HDF5File.canonicalizePath(stringArray[n]));
            ++n;
        }
    }

    @Test
    public void testScanFileHolderLoading() throws ScanFileHolderException {
        String string = "testfiles/gda/analysis/io/NexusLoaderTest/FeKedge_1_15.nxs";
        HDF5Loader hDF5Loader = new HDF5Loader(string);
        DataHolder dataHolder = hDF5Loader.loadFile();
        Assert.assertEquals((String)"File does not have the correct number of datasets", (long)51L, (long)dataHolder.getNames().length);
        if (dataHolder.contains("/entry1/xspress2system/data")) {
            ILazyDataset iLazyDataset = dataHolder.getLazyDataset("/entry1/xspress2system/data");
            Assert.assertEquals((String)"Dataset is not the right shape", (long)3L, (long)iLazyDataset.getShape().length);
            Assert.assertEquals((String)"Dataset dimention 0 is not of the correct shape", (long)489L, (long)iLazyDataset.getShape()[0]);
            Assert.assertEquals((String)"Dataset dimention 1 is not of the correct shape", (long)1L, (long)iLazyDataset.getShape()[1]);
            Assert.assertEquals((String)"Dataset dimention 2 is not of the correct shape", (long)64L, (long)iLazyDataset.getShape()[2]);
        }
    }

    @Test
    public void testLoadingDatasets() throws ScanFileHolderException {
        String string = "testfiles/gda/analysis/io/NexusLoaderTest/FeKedge_1_15.nxs";
        HDF5Loader hDF5Loader = new HDF5Loader(string);
        List<ILazyDataset> list = hDF5Loader.findDatasets(new String[]{"scan_command", "title"}, 1, null);
        Assert.assertEquals((String)"File does not have the correct number of datasets", (long)1L, (long)list.size());
        ILazyDataset iLazyDataset = list.get(0);
        Assert.assertTrue((boolean)(iLazyDataset instanceof StringDataset));
    }
}

