/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.io.HDF5Loader;
import uk.ac.diamond.scisoft.analysis.io.LoaderThreadTestBase;

public class HDF5LoaderSliceThreadTest
extends LoaderThreadTestBase {
    private static String filename = String.valueOf(System.getProperty("GDALargeTestFilesLocation")) + "/NexusUITest/DCT_201006-good.h5";
    private ILazyDataset dataset;

    @Before
    public void createLazyDataset() {
        HDF5File hDF5File;
        Assert.assertTrue((boolean)new File(filename).canRead());
        HDF5Loader hDF5Loader = new HDF5Loader(filename);
        try {
            hDF5File = hDF5Loader.loadTree();
        }
        catch (ScanFileHolderException scanFileHolderException) {
            throw new IllegalArgumentException("Could not load tree");
        }
        HDF5NodeLink hDF5NodeLink = hDF5File.findNodeLink("/RawDCT/data");
        Assert.assertTrue((boolean)hDF5NodeLink.isDestinationADataset());
        HDF5Dataset hDF5Dataset = (HDF5Dataset)hDF5NodeLink.getDestination();
        this.dataset = hDF5Dataset.getDataset();
    }

    @Override
    @Test
    public void testInTestThread() throws Exception {
        super.testInTestThread();
    }

    @Override
    @Test
    public void testWithTenThreads() throws Exception {
        super.testWithTenThreads();
    }

    @Test
    public void testWithNThreads() throws Exception {
        super.testWithNThreads(60);
    }

    @Override
    public void doTestOfDataSet(int n) throws Exception {
        Slice[] sliceArray = new Slice[3];
        sliceArray[0] = new Slice(n, n + 1);
        Slice[] sliceArray2 = sliceArray;
        IDataset iDataset = this.dataset.getSlice(sliceArray2);
        Assert.assertEquals((String)("Thd " + n + " is not correct size"), (int)289332, (int)iDataset.getSize());
    }
}

