/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;
import ncsa.hdf.object.h5.H5Group;
import ncsa.hdf.object.h5.H5Link;
import ncsa.hdf.object.h5.H5ScalarDS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ExternalFiles;
import uk.ac.diamond.scisoft.analysis.io.ILazyLoader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.ISliceLoader;
import uk.ac.diamond.scisoft.analysis.io.ImageStackLoaderEx;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;
import uk.ac.gda.monitor.IMonitor;

public class HDF5Loader
extends AbstractFileLoader
implements IMetaLoader,
ISliceLoader {
    protected static final Logger logger = LoggerFactory.getLogger(HDF5Loader.class);
    private static Map<String, ReentrantLock> openFiles = new ConcurrentHashMap<String, ReentrantLock>();
    private String fileName;
    private boolean keepBitWidth = false;
    private boolean async = false;
    private int syncLimit;
    private int syncNodes;
    private ScanFileHolderException syncException = null;
    private String host = null;
    private static final int HASH_MULTIPLIER = 139;
    public static final String DATA_FILENAME_ATTR_NAME = "data_filename";
    HDF5File tFile = null;
    private static int LIMIT = 10240;
    private static final String NAPIMOUNT = "napimount";
    private static final String NAPISCHEME = "nxfile";

    private static ReentrantLock acquireLock(String string) {
        ReentrantLock reentrantLock = openFiles.get(string);
        if (reentrantLock == null) {
            reentrantLock = new ReentrantLock();
            openFiles.put(string, reentrantLock);
        }
        reentrantLock.lock();
        return reentrantLock;
    }

    private static void releaseLock(ReentrantLock reentrantLock) {
        reentrantLock.unlock();
        if (reentrantLock.getHoldCount() == 0 && openFiles.containsValue(reentrantLock)) {
            for (Map.Entry<String, ReentrantLock> entry : openFiles.entrySet()) {
                if (!entry.getValue().equals(reentrantLock)) continue;
                openFiles.remove(entry.getKey());
            }
        }
    }

    public HDF5Loader() {
        this.setHost();
    }

    public HDF5Loader(String string) {
        this.setHost();
        this.setFile(string);
    }

    public void setAsyncLoad(boolean bl) {
        this.setAsyncLoad(bl, 200);
    }

    public void setAsyncLoad(boolean bl, int n) {
        this.async = bl;
        this.syncLimit = n;
    }

    public synchronized void stopAsyncLoading() {
        this.syncNodes = this.syncLimit;
    }

    private void setHost() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            logger.error("Could not find host name", (Throwable)unknownHostException);
        }
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        DataHolder dataHolder = null;
        dataHolder = new DataHolder();
        HDF5File hDF5File = this.loadTree(iMonitor);
        Map<String, ILazyDataset> map = HDF5Loader.createDatasetsMap(hDF5File.getGroup());
        for (String string : map.keySet()) {
            dataHolder.addDataset(string, map.get(string));
        }
        if (this.loadMetadata) {
            dataHolder.setMetadata(this.getMetaData());
        }
        return dataHolder;
    }

    public static Map<String, ILazyDataset> createDatasetsMap(HDF5Group hDF5Group) {
        HashMap<String, ILazyDataset> hashMap = new HashMap<String, ILazyDataset>();
        HDF5Loader.addAllDatasetsToMap(hDF5Group, hashMap);
        return hashMap;
    }

    private static void addAllDatasetsToMap(HDF5Group hDF5Group, Map<String, ILazyDataset> map) {
        for (HDF5NodeLink hDF5NodeLink : hDF5Group) {
            if (hDF5NodeLink.isDestinationAGroup()) {
                HDF5Loader.addAllDatasetsToMap((HDF5Group)hDF5NodeLink.getDestination(), map);
            }
            if (!hDF5NodeLink.isDestinationADataset()) continue;
            ILazyDataset iLazyDataset = ((HDF5Dataset)hDF5NodeLink.getDestination()).getDataset();
            map.put(hDF5NodeLink.getFullName(), iLazyDataset);
        }
    }

    public HDF5File loadTree() throws ScanFileHolderException {
        return this.loadTree(null);
    }

    private synchronized void waitForSyncLimit() throws ScanFileHolderException {
        while (this.syncNodes < this.syncLimit) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.syncException != null) {
            throw this.syncException;
        }
    }

    private synchronized boolean checkSyncNodes() {
        return this.syncNodes >= this.syncLimit;
    }

    private synchronized void updateSyncNodes(int n) throws ScanFileHolderException {
        this.syncNodes = n;
        if (this.syncNodes >= this.syncLimit) {
            this.notifyAll();
        }
        if (this.syncException != null) {
            throw this.syncException;
        }
    }

    public HDF5File loadTree(IMonitor iMonitor) throws ScanFileHolderException {
        if (!this.monitorIncrement(iMonitor)) {
            return null;
        }
        File file = new File(this.fileName);
        if (!file.exists()) {
            throw new ScanFileHolderException("File, " + this.fileName + ", does not exist");
        }
        if (this.async) {
            new LoadFileThread(iMonitor).start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            this.waitForSyncLimit();
        } else {
            int n;
            ReentrantLock reentrantLock;
            block19: {
                reentrantLock = HDF5Loader.acquireLock(this.fileName);
                n = -1;
                n = H5.H5Fopen((String)this.fileName, (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
                if (this.monitorIncrement(iMonitor)) break block19;
                try {
                    H5.H5Fclose((int)n);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Fclose((int)n);
                }
                catch (Exception exception) {}
                HDF5Loader.releaseLock(reentrantLock);
                return null;
            }
            try {
                try {
                    this.tFile = this.createTree(n, this.keepBitWidth);
                }
                catch (Exception exception) {
                    throw new ScanFileHolderException("Problem loading file: " + this.fileName, exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    H5.H5Fclose((int)n);
                }
                catch (Exception exception) {}
                HDF5Loader.releaseLock(reentrantLock);
                throw throwable;
            }
            try {
                H5.H5Fclose((int)n);
            }
            catch (Exception exception) {}
            HDF5Loader.releaseLock(reentrantLock);
        }
        return this.tFile;
    }

    private HDF5File createTree(int n, boolean bl) throws Exception {
        long l = this.fileName.hashCode();
        HDF5File hDF5File = new HDF5File(l, this.fileName);
        hDF5File.setHostname(this.host);
        HDF5Group hDF5Group = (HDF5Group)HDF5Loader.createGroup(n, hDF5File, -1L, new HashMap<Long, HDF5Node>(), null, "/", bl);
        if (hDF5Group == null) {
            throw new ScanFileHolderException("Could not copy root group");
        }
        hDF5File.setGroup(hDF5Group);
        return hDF5File;
    }

    private HDF5File createTreeBF(int n, boolean bl) throws Exception {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        long l = this.fileName.hashCode();
        HDF5File hDF5File = new HDF5File(l, this.fileName);
        hDF5File.setHostname(this.host);
        HashMap<Long, HDF5Node> hashMap = new HashMap<Long, HDF5Node>();
        LinkedList<String> linkedList = new LinkedList<String>();
        HDF5Group hDF5Group = (HDF5Group)HDF5Loader.createGroup(n, hDF5File, -1L, hashMap, linkedList, "/", bl);
        if (hDF5Group == null) {
            throw new ScanFileHolderException("Could not copy root group");
        }
        hDF5File.setGroup(hDF5Group);
        Object object4 = new LinkedList();
        while (linkedList.size() > 0) {
            object3 = (String)linkedList.remove();
            object2 = HDF5Loader.createGroup(n, hDF5File, -1L, hashMap, (Queue<String>)object4, (String)object3, bl);
            if (object2 == null) {
                logger.error("Could not find group {}", object3);
                continue;
            }
            int n2 = ((String)(object3 = ((String)object3).substring(0, ((String)object3).length() - 1))).lastIndexOf("/");
            String string = n2 == 0 ? "/" : ((String)object3).substring(0, n2);
            object = hDF5File.findNodeLink(string);
            serializable = (HDF5Group)((HDF5NodeLink)object).getDestination();
            ((HDF5Group)serializable).addNode(hDF5File, string, ((String)object3).substring(n2 + 1), (HDF5Node)object2);
        }
        this.tFile = hDF5File;
        block1: do {
            object3 = linkedList;
            linkedList = object4;
            object4 = object3;
            while (linkedList.size() > 0) {
                this.updateSyncNodes(hashMap.size());
                object2 = (String)linkedList.remove();
                HDF5Node hDF5Node = HDF5Loader.createGroup(n, hDF5File, -1L, hashMap, (Queue<String>)object4, (String)object2, bl);
                if (hDF5Node == null) {
                    logger.error("Could not find group {}", object2);
                    continue;
                }
                int n3 = ((String)(object2 = ((String)object2).substring(0, ((String)object2).length() - 1))).lastIndexOf("/");
                object = n3 == 0 ? "/" : ((String)object2).substring(0, n3);
                serializable = hDF5File.findNodeLink((String)object);
                HDF5Group hDF5Group2 = (HDF5Group)((HDF5NodeLink)serializable).getDestination();
                hDF5Group2.addNode(hDF5File, (String)object, ((String)object2).substring(n3 + 1), hDF5Node);
                if (this.checkSyncNodes()) continue block1;
            }
        } while (!this.checkSyncNodes() && object4.size() > 0);
        this.updateSyncNodes(this.syncLimit);
        return hDF5File;
    }

    private static HDF5Node createNode(int n, HDF5File hDF5File, HashMap<Long, HDF5Node> hashMap, Queue<String> queue, String string, boolean bl) throws Exception {
        try {
            H5O_info_t h5O_info_t = H5.H5Oget_info_by_name((int)n, (String)string, (int)HDF5Constants.H5P_DEFAULT);
            int n2 = h5O_info_t.type;
            if (n2 == HDF5Constants.H5O_TYPE_GROUP) {
                return HDF5Loader.createGroup(n, hDF5File, -1L, hashMap, queue, string, bl);
            }
            if (n2 == HDF5Constants.H5O_TYPE_DATASET) {
                return HDF5Loader.createDataset(n, hDF5File, -1L, hashMap, string, null, bl);
            }
            if (n2 == HDF5Constants.H5O_TYPE_NAMED_DATATYPE) {
                logger.error("Named datatype not supported");
            } else {
                logger.error("Unknown object type");
            }
        }
        catch (HDF5Exception hDF5Exception) {
            logger.error("Could not find info about object {}" + string);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static HDF5Node createGroup(int var0, HDF5File var1_1, long var2_2, HashMap<Long, HDF5Node> var4_3, Queue<String> var5_4, String var6_5, boolean var7_6) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK], 4[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HDF5Node createDataset(int n, HDF5File hDF5File, long l, HashMap<Long, HDF5Node> hashMap, String string, String string2, boolean bl) throws Exception {
        int n2;
        int n3;
        block38: {
            block41: {
                HDF5Dataset hDF5Dataset;
                block42: {
                    int n4;
                    HDF5Dataset hDF5Dataset2;
                    block39: {
                        HDF5Node hDF5Node;
                        block40: {
                            byte[] byArray = null;
                            if (l == -1L) {
                                try {
                                    byArray = H5.H5Rcreate((int)n, (String)string, (int)HDF5Constants.H5R_OBJECT, (int)-1);
                                    l = hDF5File.getID() * 139L + HDFNativeData.byteToLong((byte[])byArray, (int)0);
                                }
                                catch (HDF5Exception hDF5Exception) {
                                    throw new ScanFileHolderException("Could not find object reference", hDF5Exception);
                                }
                                if (l >= 0L && hashMap != null && hashMap.containsKey(l)) {
                                    HDF5Node hDF5Node2 = hashMap.get(l);
                                    if (hDF5Node2 instanceof HDF5Dataset) return hDF5Node2;
                                    throw new IllegalStateException("Matching pooled node is not a dataset");
                                }
                            }
                            n3 = -1;
                            n2 = -1;
                            int n5 = -1;
                            n3 = H5.H5Dopen((int)n, (String)(string2 == null ? string : string2), (int)HDF5Constants.H5P_DEFAULT);
                            n2 = H5.H5Dget_type((int)n3);
                            n5 = H5.H5Tget_class((int)n2);
                            if (n5 == HDF5Constants.H5T_ARRAY || n5 == HDF5Constants.H5T_VLEN) {
                                int n6 = H5.H5Tget_super((int)n2);
                                n5 = H5.H5Tget_class((int)n6);
                                try {
                                    H5.H5Tclose((int)n6);
                                }
                                catch (HDF5Exception hDF5Exception) {}
                            }
                            if (n5 == HDF5Constants.H5T_COMPOUND) {
                                logger.error("Compound dataset not supported");
                                break block38;
                            }
                            hDF5Dataset2 = new HDF5Dataset(l);
                            if (!HDF5Loader.copyAttributes(string, hDF5Dataset2, n3)) break block39;
                            String string3 = hDF5Dataset2.getAttribute(NAPIMOUNT).getFirstElement();
                            hDF5Node = HDF5Loader.copyNAPIMountNode(hDF5File, hashMap, string3, bl);
                            if (n2 < 0) break block40;
                            try {
                                H5.H5Tclose((int)n2);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                        }
                        if (n3 < 0) return hDF5Node;
                        try {
                            H5.H5Dclose((int)n3);
                            return hDF5Node;
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        return hDF5Node;
                    }
                    String string4 = string2 == null ? ((n4 = string.lastIndexOf("/")) >= 0 ? string.substring(n4 + 1) : string) : string2;
                    if (!HDF5Loader.createLazyDataset(hDF5File, hDF5Dataset2, string, string4, n3, n2, bl, hDF5Dataset2.containsAttribute(DATA_FILENAME_ATTR_NAME))) break block41;
                    if (hashMap != null) {
                        hashMap.put(l, hDF5Dataset2);
                    }
                    hDF5Dataset = hDF5Dataset2;
                    if (n2 < 0) break block42;
                    try {
                        H5.H5Tclose((int)n2);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                }
                if (n3 < 0) return hDF5Dataset;
                try {
                    H5.H5Dclose((int)n3);
                    return hDF5Dataset;
                }
                catch (HDF5Exception hDF5Exception) {}
                return hDF5Dataset;
            }
            try {
                try {
                    logger.error("Could not create a lazy dataset from {}", (Object)string);
                }
                catch (HDF5Exception hDF5Exception) {
                    logger.error("Could not open dataset", (Throwable)hDF5Exception);
                    if (n2 >= 0) {
                        try {
                            H5.H5Tclose((int)n2);
                        }
                        catch (HDF5Exception hDF5Exception2) {}
                    }
                    if (n3 < 0) return null;
                    try {
                        H5.H5Dclose((int)n3);
                        return null;
                    }
                    catch (HDF5Exception hDF5Exception3) {}
                    return null;
                }
            }
            catch (Throwable throwable) {
                if (n2 >= 0) {
                    try {
                        H5.H5Tclose((int)n2);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                }
                if (n3 < 0) throw throwable;
                try {
                    H5.H5Dclose((int)n3);
                    throw throwable;
                }
                catch (HDF5Exception hDF5Exception) {}
                throw throwable;
            }
        }
        if (n2 >= 0) {
            try {
                H5.H5Tclose((int)n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        if (n3 < 0) return null;
        try {
            H5.H5Dclose((int)n3);
            return null;
        }
        catch (HDF5Exception hDF5Exception) {}
        return null;
    }

    private static boolean copyAttributes(HDF5Node hDF5Node, HObject hObject) {
        boolean bl = false;
        try {
            if (hObject.hasAttribute()) {
                List list = hObject.getMetadata();
                String string = hObject instanceof H5Group && ((H5Group)hObject).isRoot() ? "/" : hObject.getFullName();
                for (Attribute attribute : list) {
                    HDF5Attribute hDF5Attribute = new HDF5Attribute(string, attribute.getName(), attribute.getValue(), attribute.isUnsigned());
                    hDF5Attribute.setTypeName(HDF5Loader.getTypeName(attribute.getType()));
                    hDF5Node.addAttribute(hDF5Attribute);
                    if (!attribute.getName().equals(NAPIMOUNT)) continue;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Problem with attributes on {}: {}", (Object)hObject.getFullName(), (Object)exception.getMessage());
        }
        return bl;
    }

    private static boolean copyAttributes(String string, HDF5Node hDF5Node, int n) {
        boolean bl = false;
        try {
            List list = H5File.getAttribute((int)n);
            for (Attribute attribute : list) {
                HDF5Attribute hDF5Attribute = new HDF5Attribute(string, attribute.getName(), attribute.getValue(), attribute.isUnsigned());
                hDF5Attribute.setTypeName(HDF5Loader.getTypeName(attribute.getType()));
                hDF5Node.addAttribute(hDF5Attribute);
                if (!attribute.getName().equals(NAPIMOUNT)) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.warn("Problem with attributes on {}: {}", (Object)string, (Object)exception.getMessage());
        }
        return bl;
    }

    private static HDF5Node getExternalNode(HashMap<Long, HDF5Node> hashMap, String string, String string2, String string3, boolean bl) throws Exception {
        HDF5Node hDF5Node = null;
        if (!string3.startsWith("/")) {
            string3 = "/" + string3;
        }
        ReentrantLock reentrantLock = HDF5Loader.acquireLock(string2);
        int n = -1;
        try {
            try {
                n = H5.H5Fopen((String)string2, (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
                long l = string2.hashCode();
                HDF5File hDF5File = new HDF5File(l, string2);
                hDF5File.setHostname(string);
                hDF5Node = HDF5Loader.createNode(n, hDF5File, hashMap, null, string3, bl);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Problem loading file: " + string2, exception);
            }
        }
        catch (Throwable throwable) {
            try {
                H5.H5Fclose((int)n);
            }
            catch (Exception exception) {}
            HDF5Loader.releaseLock(reentrantLock);
            throw throwable;
        }
        try {
            H5.H5Fclose((int)n);
        }
        catch (Exception exception) {}
        HDF5Loader.releaseLock(reentrantLock);
        return hDF5Node;
    }

    private static HDF5Node copyNAPIMountNode(HDF5File hDF5File, HashMap<Long, HDF5Node> hashMap, String string, boolean bl) throws Exception {
        URI uRI = new URI(string);
        HDF5Node hDF5Node = null;
        if (uRI.getScheme().equals(NAPISCHEME)) {
            String string2 = uRI.getPath();
            String string3 = uRI.getFragment();
            File file = new File(string2);
            if (!file.exists()) {
                logger.debug("File, {}, does not exist!", (Object)string2);
                file = new File(hDF5File.getParentDirectory(), file.getName());
                if (!file.exists()) {
                    throw new ScanFileHolderException("File, " + string2 + ", does not exist");
                }
                string2 = file.getAbsolutePath();
            }
            if ((hDF5Node = HDF5Loader.getExternalNode(hashMap, hDF5File.getHostname(), string2, string3, bl)) == null) {
                logger.warn("Could not find external node: {}", (Object)string3);
            }
        } else {
            System.err.println("Wrong scheme: " + uRI.getScheme());
        }
        return hDF5Node;
    }

    public static HDF5Node copyNode(HDF5File hDF5File, HashMap<Long, HDF5Node> hashMap, HObject hObject, boolean bl) throws Exception {
        if (hObject instanceof H5Link) {
            H5Link h5Link = (H5Link)hObject;
            h5Link.getMetadata();
            String string = h5Link.getLinkTargetObjName();
            if (string == null) {
                throw new IllegalArgumentException("No link target defined in link object");
            }
            throw new IllegalArgumentException("Link target cannot be resolved: " + string);
        }
        Long l = hObject.getOID()[0] + (long)(hDF5File.getFilename().hashCode() * 17);
        if (hObject instanceof Dataset) {
            if (hashMap != null && hashMap.containsKey(l)) {
                HDF5Node hDF5Node = hashMap.get(l);
                if (!(hDF5Node instanceof HDF5Dataset)) {
                    throw new IllegalStateException("Matching pooled node is not a dataset");
                }
                return hDF5Node;
            }
            HDF5Dataset hDF5Dataset = new HDF5Dataset(l);
            if (HDF5Loader.copyAttributes(hDF5Dataset, hObject)) {
                String string = hDF5Dataset.getAttribute(NAPIMOUNT).getFirstElement();
                return HDF5Loader.copyNAPIMountNode(hDF5File, hashMap, string, bl);
            }
            Datatype datatype = ((Dataset)hObject).getDatatype();
            int n = datatype.getDatatypeClass();
            if (n == 6) {
                return hDF5Dataset;
            }
            hDF5Dataset.setTypeName(HDF5Loader.getTypeName(datatype));
            if (!(hObject instanceof H5ScalarDS)) {
                throw new IllegalArgumentException("Dataset unsupported");
            }
            H5ScalarDS h5ScalarDS = (H5ScalarDS)hObject;
            if (n == 3) {
                h5ScalarDS.setConvertByteToString(true);
                if (hDF5Dataset.containsAttribute(DATA_FILENAME_ATTR_NAME)) {
                    ExternalFiles externalFiles = HDF5Loader.extractExternalFileNames(h5ScalarDS);
                    try {
                        ILazyDataset iLazyDataset = HDF5Loader.createStackedDatasetFromStrings(externalFiles);
                        hDF5Dataset.setDataset(iLazyDataset);
                    }
                    catch (Throwable throwable) {
                        logger.warn("Could not find {}, trying in {}", (Object)externalFiles.files[0], (Object)hDF5File.getParentDirectory());
                        try {
                            ILazyDataset iLazyDataset = HDF5Loader.createStackedDatasetFromStrings(externalFiles, hDF5File.getParentDirectory());
                            hDF5Dataset.setDataset(iLazyDataset);
                        }
                        catch (Throwable throwable2) {
                            logger.error("Unable to create lazydataset for" + h5ScalarDS, throwable2);
                            hDF5Dataset.setString(externalFiles.getAsText());
                        }
                    }
                } else {
                    hDF5Dataset.setDataset(HDF5Loader.createLazyDataset(hDF5File.getHostname(), h5ScalarDS, bl));
                    hDF5Dataset.setMaxShape(h5ScalarDS.getMaxDims());
                }
            } else {
                hDF5Dataset.setDataset(HDF5Loader.createLazyDataset(hDF5File.getHostname(), h5ScalarDS, bl));
                hDF5Dataset.setMaxShape(h5ScalarDS.getMaxDims());
            }
            if (hashMap != null) {
                hashMap.put(l, hDF5Dataset);
            }
            return hDF5Dataset;
        }
        if (hObject instanceof H5Group) {
            if (hashMap != null && hashMap.containsKey(l)) {
                HDF5Node hDF5Node = hashMap.get(l);
                if (!(hDF5Node instanceof HDF5Group)) {
                    throw new IllegalStateException("Matching pooled node is not a group");
                }
                return hDF5Node;
            }
            H5Group h5Group = (H5Group)hObject;
            HDF5Group hDF5Group = new HDF5Group(l);
            if (HDF5Loader.copyAttributes(hDF5Group, (HObject)h5Group)) {
                String string = hDF5Group.getAttribute(NAPIMOUNT).getFirstElement();
                return HDF5Loader.copyNAPIMountNode(hDF5File, hashMap, string, bl);
            }
            List list = h5Group.getMemberList();
            for (HObject hObject2 : list) {
                String string = hObject2.getPath();
                String string2 = hObject2.getName();
                hDF5Group.addNode(hDF5File, string, string2, HDF5Loader.copyNode(hDF5File, hashMap, hObject2, bl));
            }
            if (hashMap != null) {
                hashMap.put(l, hDF5Group);
            }
            return hDF5Group;
        }
        return null;
    }

    public static int getDtype(int n, int n2) {
        switch (n) {
            case 3: {
                return 9;
            }
            case 0: 
            case 2: {
                switch (n2) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 4: {
                        return 3;
                    }
                    case 8: {
                        return 4;
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 4: {
                        return 5;
                    }
                    case 8: {
                        return 6;
                    }
                }
            }
        }
        return -1;
    }

    public static String getTypeName(Datatype datatype) {
        int n = datatype.getDatatypeClass();
        int n2 = datatype.getDatatypeSize();
        switch (n) {
            case 0: 
            case 2: {
                String string = datatype.isUnsigned() ? "U" : "";
                switch (n2) {
                    case 1: {
                        return String.valueOf(string) + "INT8";
                    }
                    case 2: {
                        return String.valueOf(string) + "INT16";
                    }
                    case 4: {
                        return String.valueOf(string) + "INT32";
                    }
                    case 8: {
                        return String.valueOf(string) + "INT64";
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 4: {
                        return "FLOAT32";
                    }
                    case 8: {
                        return "FLOAT64";
                    }
                }
                break;
            }
            case 3: {
                return "STRING";
            }
        }
        return datatype.getDatatypeDescription();
    }

    public static AbstractDataset createDataset(Object object, int[] nArray, int n, boolean bl) {
        AbstractDataset abstractDataset = null;
        switch (n) {
            case 5: {
                float[] fArray = (float[])object;
                abstractDataset = new FloatDataset(fArray, nArray);
                break;
            }
            case 6: {
                double[] dArray = (double[])object;
                abstractDataset = new DoubleDataset(dArray, nArray);
                break;
            }
            case 1: {
                byte[] byArray = (byte[])object;
                abstractDataset = new ByteDataset(byArray, nArray);
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                abstractDataset = new ShortDataset(sArray, nArray);
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                abstractDataset = new IntegerDataset(nArray2, nArray);
                break;
            }
            case 4: {
                long[] lArray = (long[])object;
                abstractDataset = new LongDataset(lArray, nArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or unsupported dataset type");
            }
        }
        if (bl) {
            switch (n) {
                case 3: {
                    abstractDataset = new LongDataset(abstractDataset);
                    DatasetUtils.unwrapUnsigned(abstractDataset, 32);
                    break;
                }
                case 2: {
                    abstractDataset = new IntegerDataset(abstractDataset);
                    DatasetUtils.unwrapUnsigned(abstractDataset, 16);
                    break;
                }
                case 1: {
                    abstractDataset = new ShortDataset(abstractDataset);
                    DatasetUtils.unwrapUnsigned(abstractDataset, 8);
                }
            }
        }
        return abstractDataset;
    }

    public static ILazyDataset createLazyDataset(final String string, H5ScalarDS h5ScalarDS, boolean bl) throws Exception {
        long[] lArray = h5ScalarDS.getDims();
        if (lArray == null) {
            h5ScalarDS.init();
            lArray = h5ScalarDS.getDims();
        }
        final int[] nArray = new int[lArray.length];
        int n = 0;
        while (n < lArray.length) {
            long l = lArray[n];
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Dimension larger than ints");
            }
            nArray[n] = (int)l;
            ++n;
        }
        if (nArray.length == 1 && nArray[0] == 1) {
            AbstractDataset abstractDataset = AbstractDataset.array(h5ScalarDS.read());
            abstractDataset.setName(h5ScalarDS.getName());
            return abstractDataset;
        }
        final String string2 = h5ScalarDS.getFile();
        final String string3 = h5ScalarDS.getFullName();
        final String string4 = h5ScalarDS.getName();
        Datatype datatype = h5ScalarDS.getDatatype();
        final boolean bl2 = !bl && datatype.isUnsigned();
        final int n2 = HDF5Loader.getDtype(datatype.getDatatypeClass(), datatype.getDatatypeSize());
        ILazyLoader iLazyLoader = new ILazyLoader(){

            @Override
            public boolean isFileReadable() {
                try {
                    if (string != null && string.length() > 0 && !string.equals(InetAddress.getLocalHost().getHostName())) {
                        return false;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    logger.warn("Problem finding local host so ignoring check", (Throwable)unknownHostException);
                }
                return new File(string2).canRead();
            }

            public String toString() {
                return String.valueOf(string2) + ":" + string3;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public AbstractDataset getDataset(IMonitor var1_1, int[] var2_2, int[] var3_3, int[] var4_4, int[] var5_5) throws ScanFileHolderException {
                var6_6 = var2_2.length;
                if (var5_5 == null) {
                    var9_7 = new int[var6_6];
                    var10_8 = 0;
                    while (var10_8 < var6_6) {
                        var9_7[var10_8] = 1;
                        ++var10_8;
                    }
                } else {
                    var9_7 = var5_5;
                }
                var7_10 = var3_3 == null ? new int[var6_6] : var3_3;
                var8_11 = var4_4 == null ? new int[var6_6] : var4_4;
                var10_9 = AbstractDataset.checkSlice(var2_2, var3_3, var4_4, var7_10, var8_11, var9_7);
                var11_12 = null;
                try {
                    block15: {
                        block11: {
                            block14: {
                                block12: {
                                    if (Arrays.equals(nArray, var2_2)) break block11;
                                    var12_13 = nArray.length;
                                    var13_15 = new int[var12_13];
                                    var14_16 = new int[var12_13];
                                    var15_17 = new int[var12_13];
                                    if (var6_6 <= var12_13) break block12;
                                    var16_18 = 0;
                                    var17_20 = 0;
                                    while (var17_20 < var12_13) {
                                        block13: {
                                            if (nArray[var17_20] != 1) ** GOTO lbl31
                                            var13_15[var17_20] = 0;
                                            var14_16[var17_20] = 1;
                                            var15_17[var17_20] = 1;
                                            break block13;
lbl-1000:
                                            // 1 sources

                                            {
                                                ++var16_18;
lbl31:
                                                // 2 sources

                                                ** while (var2_2[var16_18] == 1 && var6_6 - var16_18 > var12_13 - var17_20)
                                            }
lbl32:
                                            // 1 sources

                                            var13_15[var17_20] = var7_10[var16_18];
                                            var14_16[var17_20] = var10_9[var16_18];
                                            var15_17[var17_20] = var9_7[var16_18];
                                            ++var16_18;
                                        }
                                        ++var17_20;
                                    }
                                    break block14;
                                }
                                var16_19 = 0;
                                var17_21 = 0;
                                while (var17_21 < var12_13) {
                                    if (nArray[var17_21] == 1) {
                                        var13_15[var17_21] = 0;
                                        var14_16[var17_21] = 1;
                                        var15_17[var17_21] = 1;
                                    } else {
                                        var13_15[var17_21] = var7_10[var16_19];
                                        var14_16[var17_21] = var10_9[var16_19];
                                        var15_17[var17_21] = var9_7[var16_19];
                                        ++var16_19;
                                    }
                                    ++var17_21;
                                }
                            }
                            var11_12 = HDF5Loader.access$6(string2, string3, var13_15, var14_16, var15_17, n2, bl2);
                            var11_12.setShape(var10_9);
                            break block15;
                        }
                        var11_12 = HDF5Loader.access$6(string2, string3, var7_10, var10_9, var9_7, n2, bl2);
                    }
                    if (var11_12 != null) {
                        var11_12.setName(string4);
                    }
                }
                catch (Exception var12_14) {
                    throw new ScanFileHolderException("Problem with HDF library", var12_14);
                }
                return var11_12;
            }
        };
        return new LazyDataset(string4, n2, (int[])nArray.clone(), iLazyLoader);
    }

    /*
     * Exception decompiling
     */
    private static boolean createLazyDataset(HDF5File var0, HDF5Dataset var1_1, String var2_2, String var3_3, int var4_4, int var5_5, boolean var6_6, boolean var7_7) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ILazyDataset createStackedDatasetFromStrings(ExternalFiles externalFiles) throws OutOfMemoryError, Exception {
        ImageStackLoaderEx imageStackLoaderEx = new ImageStackLoaderEx(externalFiles.shape, externalFiles.files);
        return new LazyDataset("file_name", imageStackLoaderEx.getDtype(), imageStackLoaderEx.getShape(), imageStackLoaderEx);
    }

    public static ILazyDataset createStackedDatasetFromStrings(ExternalFiles externalFiles, String string) throws OutOfMemoryError, Exception {
        ImageStackLoaderEx imageStackLoaderEx = new ImageStackLoaderEx(externalFiles.shape, externalFiles.files, string);
        return new LazyDataset("file_name", imageStackLoaderEx.getDtype(), imageStackLoaderEx.getShape(), imageStackLoaderEx);
    }

    private static ExternalFiles extractExternalFileNames(int n, int n2, boolean bl, int[] nArray) throws Exception {
        String[] stringArray;
        int n3 = 1;
        int n4 = 0;
        while (n4 < nArray.length) {
            n3 *= nArray[n4];
            ++n4;
        }
        int[] nArray2 = new int[]{-1, -1};
        nArray2[0] = HDF5Constants.H5S_ALL;
        nArray2[1] = HDF5Constants.H5S_ALL;
        try {
            stringArray = H5Datatype.allocateArray((int)n2, (int)n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new HDF5Exception("Out of memory");
        }
        if (bl) {
            H5.H5DreadVL((int)n, (int)n2, (int)nArray2[0], (int)nArray2[1], (int)HDF5Constants.H5P_DEFAULT, (Object[])stringArray);
        } else {
            H5.H5Dread((int)n, (int)n2, (int)nArray2[0], (int)nArray2[1], (int)HDF5Constants.H5P_DEFAULT, (Object)stringArray);
            stringArray = Dataset.byteToString((byte[])((byte[])stringArray), (int)H5.H5Tget_size((int)n2));
        }
        String[] stringArray2 = stringArray;
        ExternalFiles externalFiles = new ExternalFiles();
        externalFiles.shape = AbstractDataset.squeezeShape(nArray, false);
        externalFiles.files = stringArray2;
        return externalFiles;
    }

    public static ExternalFiles extractExternalFileNames(H5ScalarDS h5ScalarDS) throws Exception {
        h5ScalarDS.init();
        long[] lArray = h5ScalarDS.getDims();
        long[] lArray2 = h5ScalarDS.getStartDims();
        long[] lArray3 = h5ScalarDS.getStride();
        long[] lArray4 = h5ScalarDS.getSelectedDims();
        int n = 1;
        int[] nArray = new int[lArray.length];
        int n2 = 0;
        while (n2 < lArray.length) {
            int n3;
            lArray3[n2] = 1L;
            lArray4[n2] = 1L;
            nArray[n2] = n3 = (int)lArray[n2];
            n *= n3;
            ++n2;
        }
        String[] stringArray = new String[n];
        PositionIterator positionIterator = new PositionIterator(nArray);
        int[] nArray2 = positionIterator.getPos();
        int n4 = 0;
        while (positionIterator.hasNext()) {
            int n5 = 0;
            while (n5 < nArray.length) {
                lArray2[n5] = nArray2[n5];
                ++n5;
            }
            h5ScalarDS.clear();
            stringArray[n4++] = ((String[])h5ScalarDS.getData())[0];
        }
        ExternalFiles externalFiles = new ExternalFiles();
        externalFiles.shape = AbstractDataset.squeezeShape(nArray, false);
        externalFiles.files = stringArray;
        return externalFiles;
    }

    private static AbstractDataset loadData(String string, String string2, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl) throws Exception {
        AbstractDataset abstractDataset;
        block38: {
            abstractDataset = null;
            ReentrantLock reentrantLock = HDF5Loader.acquireLock(string);
            try {
                H5File h5File = (H5File)FileFormat.getFileFormat((String)"HDF5").createInstance(string, 0);
                if (!h5File.canRead()) {
                    throw new IllegalArgumentException("Cannot read file");
                }
                try {
                    try {
                        int n2;
                        boolean bl2;
                        int n3;
                        HObject hObject = h5File.get(string2);
                        if (hObject == null) {
                            throw new IllegalArgumentException("Node not found: " + string2);
                        }
                        if (!(hObject instanceof H5ScalarDS)) {
                            throw new ScanFileHolderException("Cannot handle (non-scalar) dataset type");
                        }
                        H5ScalarDS h5ScalarDS = (H5ScalarDS)hObject;
                        h5ScalarDS.getMetadata();
                        h5ScalarDS.clear();
                        long[] lArray = h5ScalarDS.getStartDims();
                        long[] lArray2 = h5ScalarDS.getStride();
                        long[] lArray3 = h5ScalarDS.getSelectedDims();
                        int n4 = lArray.length;
                        if (n < 0) {
                            Datatype datatype = h5ScalarDS.getDatatype();
                            n3 = HDF5Loader.getDtype(datatype.getDatatypeClass(), datatype.getDatatypeSize());
                        } else {
                            n3 = n;
                        }
                        int n5 = 0;
                        while (n5 < n4) {
                            lArray[n5] = nArray[n5];
                            lArray2[n5] = nArray3[n5];
                            lArray3[n5] = nArray2[n5];
                            ++n5;
                        }
                        long[] lArray4 = h5ScalarDS.getChunkSize();
                        if (lArray4 == null) {
                            bl2 = true;
                        } else {
                            int n6 = n4 - 1;
                            while (n6 >= 0) {
                                if (lArray4[n6] > 1L && lArray3[n6] <= 1L) break;
                                --n6;
                            }
                            boolean bl3 = bl2 = n6 < 0;
                        }
                        if (bl2) {
                            try {
                                abstractDataset = HDF5Loader.createDataset(h5ScalarDS.read(), nArray2, n3, bl);
                                break block38;
                            }
                            catch (HDF5Exception hDF5Exception) {
                                throw new ScanFileHolderException("Problem reading dataset from HDF5 file", hDF5Exception);
                            }
                        }
                        boolean[] blArray = new boolean[n4];
                        long[] lArray5 = new long[n4];
                        int n7 = 1;
                        int n8 = 0;
                        while (n8 < n4) {
                            lArray5[n8] = lArray[n8] + (long)(nArray2[n8] * nArray3[n8]);
                            boolean bl4 = blArray[n8] = lArray4[n8] <= 1L || lArray3[n8] > 1L;
                            if (blArray[n8]) {
                                lArray3[n8] = 1L;
                            } else {
                                n7 = (int)((long)n7 * lArray3[n8]);
                            }
                            ++n8;
                        }
                        if (n7 == 1) {
                            n8 = n4 - 1;
                            while (n8 >= 0) {
                                n2 = nArray2[n8];
                                if (n2 > 1) {
                                    lArray3[n8] = n2;
                                    blArray[n8] = false;
                                    break;
                                }
                                --n8;
                            }
                        }
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        n2 = 0;
                        while (n2 < n4) {
                            if (!blArray[n2]) {
                                arrayList.add(n2);
                            }
                            ++n2;
                        }
                        int[] nArray4 = new int[arrayList.size()];
                        int n9 = 0;
                        while (n9 < nArray4.length) {
                            nArray4[n9] = (Integer)arrayList.get(n9);
                            ++n9;
                        }
                        abstractDataset = AbstractDataset.zeros(nArray2, n3);
                        PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray4);
                        int[] nArray5 = positionIterator.getPos();
                        boolean[] blArray2 = positionIterator.getOmit();
                        while (positionIterator.hasNext()) {
                            abstractDataset.setItemsOnAxes(nArray5, blArray2, h5ScalarDS.read());
                            int n10 = n4 - 1;
                            while (n10 >= 0) {
                                if (blArray[n10]) {
                                    int n11 = n10;
                                    lArray[n11] = lArray[n11] + lArray2[n10];
                                    if (lArray[n10] < lArray5[n10]) break;
                                    lArray[n10] = nArray[n10];
                                }
                                --n10;
                            }
                            if (n10 == -1) break;
                        }
                        if (bl) {
                            switch (n3) {
                                case 3: {
                                    abstractDataset = new LongDataset(abstractDataset);
                                    DatasetUtils.unwrapUnsigned(abstractDataset, 32);
                                    break;
                                }
                                case 2: {
                                    abstractDataset = new IntegerDataset(abstractDataset);
                                    DatasetUtils.unwrapUnsigned(abstractDataset, 16);
                                    break;
                                }
                                case 1: {
                                    abstractDataset = new ShortDataset(abstractDataset);
                                    DatasetUtils.unwrapUnsigned(abstractDataset, 8);
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        throw new ScanFileHolderException("Problem loading file", exception);
                    }
                }
                finally {
                    h5File.close();
                }
            }
            finally {
                HDF5Loader.releaseLock(reentrantLock);
            }
        }
        return abstractDataset;
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        this.loadTree(iMonitor);
    }

    @Override
    public IMetaData getMetaData() {
        return HDF5Loader.createMetaData(this.tFile);
    }

    public static IMetaData createMetaData(final HDF5File hDF5File) {
        if (hDF5File == null) {
            return null;
        }
        final List<String> list = HDF5Loader.createMetaNames(hDF5File.getNodeLink());
        return new MetaDataAdapter(){

            @Override
            public Collection<String> getMetaNames() throws Exception {
                return Collections.unmodifiableCollection(list);
            }

            public String getMetaValue(String string) throws Exception {
                if (!list.contains(string)) {
                    return null;
                }
                HDF5Node hDF5Node = hDF5File.findNodeLink(string).getDestination();
                if (string.contains("@")) {
                    return hDF5Node.getAttribute(string.substring(string.indexOf("@") + 1)).getFirstElement();
                }
                AbstractDataset abstractDataset = (AbstractDataset)((HDF5Dataset)hDF5Node).getDataset();
                return abstractDataset.getRank() == 0 ? abstractDataset.getString(new int[0]) : abstractDataset.getString(0);
            }
        };
    }

    private static List<String> createMetaNames(HDF5NodeLink hDF5NodeLink) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HDF5Loader.addMetadataToList(hDF5NodeLink, arrayList);
        return arrayList;
    }

    private static void addMetadataToList(HDF5NodeLink hDF5NodeLink, List<String> list) {
        HDF5Node hDF5Node = hDF5NodeLink.getDestination();
        Iterator<String> iterator = hDF5Node.getAttributeNameIterator();
        String string = String.valueOf(hDF5NodeLink.getFullName()) + "@";
        while (iterator.hasNext()) {
            list.add(String.valueOf(string) + iterator.next());
        }
        if (hDF5Node instanceof HDF5Group) {
            for (HDF5NodeLink hDF5NodeLink2 : (HDF5Group)hDF5Node) {
                HDF5Node hDF5Node2;
                ILazyDataset iLazyDataset;
                HDF5Loader.addMetadataToList(hDF5NodeLink2, list);
                if (!hDF5NodeLink2.isDestinationADataset() || !((iLazyDataset = ((HDF5Dataset)(hDF5Node2 = hDF5NodeLink2.getDestination())).getDataset()) instanceof AbstractDataset)) continue;
                list.add(hDF5NodeLink2.getFullName());
            }
        }
    }

    public List<ILazyDataset> findDatasets(String[] stringArray, int n, IMonitor iMonitor) throws ScanFileHolderException {
        int n2;
        ReentrantLock reentrantLock;
        ArrayList<ILazyDataset> arrayList;
        block13: {
            arrayList = new ArrayList<ILazyDataset>();
            reentrantLock = HDF5Loader.acquireLock(this.fileName);
            n2 = -1;
            n2 = H5.H5Fopen((String)this.fileName, (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
            if (this.monitorIncrement(iMonitor)) break block13;
            try {
                H5.H5Fclose((int)n2);
            }
            catch (Exception exception) {}
            try {
                H5.H5Fclose((int)n2);
            }
            catch (Exception exception) {}
            HDF5Loader.releaseLock(reentrantLock);
            return null;
        }
        try {
            try {
                long l = this.fileName.hashCode();
                HDF5File hDF5File = new HDF5File(l, this.fileName);
                hDF5File.setHostname(this.host);
                this.visitGroup(n2, hDF5File, "/", Arrays.asList(stringArray), 0, n, arrayList);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Problem loading file: " + this.fileName, exception);
            }
        }
        catch (Throwable throwable) {
            try {
                H5.H5Fclose((int)n2);
            }
            catch (Exception exception) {}
            HDF5Loader.releaseLock(reentrantLock);
            throw throwable;
        }
        try {
            H5.H5Fclose((int)n2);
        }
        catch (Exception exception) {}
        HDF5Loader.releaseLock(reentrantLock);
        return arrayList;
    }

    private void visitGroup(int n, HDF5File hDF5File, String string, List<String> list, int n2, int n3, ArrayList<ILazyDataset> arrayList) throws Exception {
        long l;
        int n4;
        int n5;
        block57: {
            block58: {
                Object object;
                n5 = -1;
                n4 = 0;
                try {
                    n5 = H5.H5Gopen((int)n, (String)string, (int)HDF5Constants.H5P_DEFAULT);
                    object = H5.H5Gget_info((int)n5);
                    n4 = (int)object.nlinks;
                }
                catch (HDF5Exception hDF5Exception) {
                    throw new ScanFileHolderException("Could not open group", hDF5Exception);
                }
                object = null;
                l = -1L;
                try {
                    object = H5.H5Rcreate((int)n, (String)string, (int)HDF5Constants.H5R_OBJECT, (int)-1);
                    l = HDFNativeData.byteToLong((byte[])object, (int)0);
                }
                catch (HDF5Exception hDF5Exception) {
                    throw new ScanFileHolderException("Could not find group reference", hDF5Exception);
                }
                if (n4 > 0) break block57;
                if (n5 < 0) break block58;
                try {
                    H5.H5Gclose((int)n5);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
            return;
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        long[] lArray = new long[n4];
        String[] stringArray = new String[n4];
        try {
            H5.H5Gget_obj_info_all((int)n, (String)string, (String[])stringArray, (int[])nArray, (int[])nArray2, (long[])lArray, (int)HDF5Constants.H5_INDEX_NAME);
        }
        catch (HDF5Exception hDF5Exception) {
            logger.error("Could not get objects info in group", (Throwable)hDF5Exception);
            if (n5 >= 0) {
                try {
                    H5.H5Gclose((int)n5);
                }
                catch (HDF5Exception hDF5Exception2) {}
            }
            return;
        }
        try {
            if (n4 > LIMIT) {
                logger.warn("Number of members in group {} exceed limit ({} > {}). Only reading up to limit", new Object[]{string, n4, LIMIT});
                n4 = LIMIT;
            }
            int n6 = 0;
            while (n6 < n4) {
                block62: {
                    int n7;
                    block63: {
                        int n8;
                        block65: {
                            int n9;
                            int n10;
                            block59: {
                                HDF5Dataset hDF5Dataset;
                                block60: {
                                    block61: {
                                        String string2;
                                        block64: {
                                            string2 = stringArray[n6];
                                            if (string2 == null) break block62;
                                            n8 = nArray[n6];
                                            n7 = nArray2[n6];
                                            l = lArray[n6];
                                            if (n7 != HDF5Constants.H5L_TYPE_HARD) break block63;
                                            if (n8 != HDF5Constants.H5O_TYPE_GROUP || n2 >= n3) break block64;
                                            this.visitGroup(n, hDF5File, String.valueOf(string) + string2 + "/", list, n2 + 1, n3, arrayList);
                                            break block62;
                                        }
                                        if (n8 != HDF5Constants.H5O_TYPE_DATASET || n2 != n3) break block65;
                                        if (!list.contains(string2)) break block62;
                                        n10 = -1;
                                        n9 = -1;
                                        int n11 = -1;
                                        n10 = H5.H5Dopen((int)n5, (String)string2, (int)HDF5Constants.H5P_DEFAULT);
                                        n9 = H5.H5Dget_type((int)n10);
                                        n11 = H5.H5Tget_class((int)n9);
                                        if (n11 == HDF5Constants.H5T_ARRAY || n11 == HDF5Constants.H5T_VLEN) {
                                            int n12 = H5.H5Tget_super((int)n9);
                                            n11 = H5.H5Tget_class((int)n12);
                                            try {
                                                H5.H5Tclose((int)n12);
                                            }
                                            catch (HDF5Exception hDF5Exception) {}
                                        }
                                        if (n11 == HDF5Constants.H5T_COMPOUND) {
                                            logger.error("Compound dataset not supported");
                                            break block59;
                                        }
                                        hDF5Dataset = new HDF5Dataset(l);
                                        if (HDF5Loader.createLazyDataset(hDF5File, hDF5Dataset, String.valueOf(string) + string2, string2, n10, n9, this.keepBitWidth, hDF5Dataset.containsAttribute(DATA_FILENAME_ATTR_NAME))) break block60;
                                        logger.error("Could not create a lazy dataset {} from {}", (Object)string2, (Object)string);
                                        if (n9 < 0) break block61;
                                        try {
                                            H5.H5Tclose((int)n9);
                                        }
                                        catch (HDF5Exception hDF5Exception) {}
                                    }
                                    if (n10 >= 0) {
                                        try {
                                            H5.H5Dclose((int)n10);
                                        }
                                        catch (HDF5Exception hDF5Exception) {}
                                    }
                                    break block62;
                                }
                                try {
                                    try {
                                        arrayList.add(hDF5Dataset.getDataset());
                                    }
                                    catch (HDF5Exception hDF5Exception) {
                                        logger.error("Could not open dataset", (Throwable)hDF5Exception);
                                        if (n9 >= 0) {
                                            try {
                                                H5.H5Tclose((int)n9);
                                            }
                                            catch (HDF5Exception hDF5Exception3) {}
                                        }
                                        if (n10 >= 0) {
                                            try {
                                                H5.H5Dclose((int)n10);
                                            }
                                            catch (HDF5Exception hDF5Exception4) {}
                                        }
                                        break block62;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (n9 >= 0) {
                                        try {
                                            H5.H5Tclose((int)n9);
                                        }
                                        catch (HDF5Exception hDF5Exception) {}
                                    }
                                    if (n10 >= 0) {
                                        try {
                                            H5.H5Dclose((int)n10);
                                        }
                                        catch (HDF5Exception hDF5Exception) {}
                                    }
                                    throw throwable;
                                }
                            }
                            if (n9 >= 0) {
                                try {
                                    H5.H5Tclose((int)n9);
                                }
                                catch (HDF5Exception hDF5Exception) {}
                            }
                            if (n10 >= 0) {
                                try {
                                    H5.H5Dclose((int)n10);
                                }
                                catch (HDF5Exception hDF5Exception) {}
                            }
                            break block62;
                        }
                        if (n8 == HDF5Constants.H5O_TYPE_NAMED_DATATYPE) {
                            logger.error("Named datatype not supported");
                        }
                        break block62;
                    }
                    if (n7 != HDF5Constants.H5L_TYPE_SOFT) {
                    }
                }
                ++n6;
            }
        }
        catch (Throwable throwable) {
            if (n5 >= 0) {
                try {
                    H5.H5Gclose((int)n5);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
            throw throwable;
        }
        if (n5 >= 0) {
            try {
                H5.H5Gclose((int)n5);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
    }

    @Override
    public AbstractDataset slice(SliceObject sliceObject, IMonitor iMonitor) throws Exception {
        int[] nArray;
        int[] nArray2;
        int n;
        int[] nArray3 = sliceObject.getSliceStart();
        int[] nArray4 = sliceObject.getSliceStop();
        int[] nArray5 = sliceObject.getSliceStep();
        if (nArray3 != null) {
            n = nArray3.length;
        } else if (nArray4 != null) {
            n = nArray4.length;
        } else if (nArray5 != null) {
            n = nArray5.length;
        } else {
            throw new IllegalArgumentException("Slice object does not have any info about rank");
        }
        if (nArray5 == null) {
            nArray2 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray2[n2] = 1;
                ++n2;
            }
        } else {
            nArray2 = nArray5;
        }
        int[] nArray6 = nArray3 == null ? new int[n] : nArray3;
        if (nArray4 == null) {
            nArray = sliceObject.getSlicedShape();
            if (nArray == null) {
                nArray = sliceObject.getFullShape();
            }
        } else {
            nArray = nArray4;
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Slice object does not have any info about stop or shape");
        }
        int[] nArray7 = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray7[n3] = nArray2[n3] > 0 ? (nArray[n3] - nArray6[n3] - 1) / nArray2[n3] + 1 : (nArray[n3] - nArray6[n3] + 1) / nArray2[n3] + 1;
            ++n3;
        }
        return HDF5Loader.loadData(sliceObject.getPath(), sliceObject.getName(), nArray6, nArray7, nArray2, -1, true);
    }

    static /* synthetic */ AbstractDataset access$6(String string, String string2, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl) throws Exception {
        return HDF5Loader.loadData(string, string2, nArray, nArray2, nArray3, n, bl);
    }

    class LoadFileThread
    extends Thread {
        private IMonitor mon;

        public LoadFileThread(IMonitor iMonitor) {
            this.mon = iMonitor;
            this.setName("Load HDF5 file: " + HDF5Loader.this.fileName);
        }

        @Override
        public void run() {
            int n;
            ReentrantLock reentrantLock;
            block15: {
                reentrantLock = HDF5Loader.acquireLock(HDF5Loader.this.fileName);
                n = -1;
                n = H5.H5Fopen((String)HDF5Loader.this.fileName, (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
                if (HDF5Loader.this.monitorIncrement(this.mon)) break block15;
                try {
                    H5.H5Fclose((int)n);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Fclose((int)n);
                }
                catch (Exception exception) {}
                HDF5Loader.releaseLock(reentrantLock);
                return;
            }
            try {
                try {
                    HDF5Loader.this.tFile = HDF5Loader.this.createTreeBF(n, HDF5Loader.this.keepBitWidth);
                }
                catch (Exception exception) {
                    HDF5Loader.this.syncException = new ScanFileHolderException("Problem loading file: " + HDF5Loader.this.fileName, exception);
                    try {
                        H5.H5Fclose((int)n);
                    }
                    catch (Exception exception2) {}
                    HDF5Loader.releaseLock(reentrantLock);
                }
            }
            catch (Throwable throwable) {
                try {
                    H5.H5Fclose((int)n);
                }
                catch (Exception exception) {}
                HDF5Loader.releaseLock(reentrantLock);
                throw throwable;
            }
            try {
                H5.H5Fclose((int)n);
            }
            catch (Exception exception) {}
            HDF5Loader.releaseLock(reentrantLock);
        }
    }
}

