/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LazyDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ImageStackLoader;
import uk.ac.diamond.scisoft.analysis.io.SRSLoader;
import uk.ac.gda.monitor.IMonitor;

public class ExtendedSRSLoader
extends SRSLoader {
    public ExtendedSRSLoader(String string) {
        super(string);
    }

    private void appendPilatusData(DataHolder dataHolder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dataHolder.contains("path")) {
            ImageStackLoader imageStackLoader;
            Serializable serializable;
            File file = new File(this.fileName);
            File file2 = file.getParentFile();
            file2 = new File(file.getParentFile(), "pilatus100k");
            AbstractDataset abstractDataset = dataHolder.getDataset("path");
            int n = 0;
            while (n < abstractDataset.getShape()[0]) {
                serializable = new File(file2, String.format("test%d.tif", abstractDataset.getInt(n)));
                if (!((File)serializable).exists()) {
                    serializable = new File(file2, String.format("p%d.tif", abstractDataset.getInt(n)));
                }
                arrayList.add(((File)serializable).getAbsolutePath());
                ++n;
            }
            try {
                imageStackLoader = new ImageStackLoader(arrayList);
            }
            catch (Exception exception) {
                logger.warn("Could not create ImageStackLoader, not populating pilatus stack");
                return;
            }
            serializable = new LazyDataset("Pilatus", imageStackLoader.dtype, imageStackLoader.getShape(), imageStackLoader);
            dataHolder.addDataset("Pilatus", (ILazyDataset)serializable);
        }
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        DataHolder dataHolder = super.loadFile(iMonitor);
        this.appendPilatusData(dataHolder);
        return dataHolder;
    }
}

