/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.util.TestUtils;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.io.ADSCImageLoader;
import uk.ac.diamond.scisoft.analysis.io.CBFLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IDiffractionMetadata;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.MARLoader;

public class DiffractionImageTest {
    static String testfile1 = null;
    static String testfile2 = null;
    static String testfile3 = null;
    static String TestFileFolder;
    DetectorProperties detprops;
    DiffractionCrystalEnvironment dce;

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        testfile1 = String.valueOf(TestFileFolder) + "ADSCImageTest/F6_1_001.img";
        testfile2 = String.valueOf(TestFileFolder) + "MARImageTest/mar225_001.mccd";
        testfile3 = String.valueOf(TestFileFolder) + "CBFLoaderTest/xtal5e_1_0010.cbf";
    }

    @Test
    public void testLoaderFactory() throws Exception {
        if (LoaderFactory.getData(testfile1, null) == null) {
            throw new Exception();
        }
        if (LoaderFactory.getData(testfile2, null) == null) {
            throw new Exception();
        }
        if (LoaderFactory.getData(testfile3, null) == null) {
            throw new Exception();
        }
    }

    @Test
    public void testMetadata() throws Exception {
        DataHolder dataHolder = new ADSCImageLoader(testfile1).loadFile();
        IMetaData iMetaData = dataHolder.getDataset(0).getMetadata();
        if (iMetaData instanceof IDiffractionMetadata) {
            this.detprops = ((IDiffractionMetadata)iMetaData).getDetector2DProperties();
            this.dce = ((IDiffractionMetadata)iMetaData).getDiffractionCrystalEnvironment();
        }
        double d = this.detprops.getDetectorSizeH();
        double d2 = this.detprops.getDetectorSizeV();
        double d3 = Math.sqrt(d * d + d2 * d2);
        int[] nArray = new int[8];
        nArray[3] = this.detprops.getPx();
        nArray[4] = this.detprops.getPy();
        nArray[6] = this.detprops.getPx();
        nArray[7] = this.detprops.getPy();
        int[] nArray2 = nArray;
        System.out.println("ADSC " + d + " pix size " + this.detprops.getHPxSize() + " num pix " + this.detprops.getPx());
        Vector3d vector3d = new Vector3d();
        vector3d.sub((Tuple3d)this.detprops.pixelPosition(nArray2[0], nArray2[1]), (Tuple3d)this.detprops.pixelPosition(this.detprops.getPx(), this.detprops.getPy()));
        Assert.assertEquals((double)d3, (double)vector3d.length(), (double)1.0E-5);
    }

    @Test
    @Ignore(value="This is being ignored intil the MAR loader has been refactored to use the new metadata, 10 Nov 11")
    public void testMAR() throws Exception {
        DataHolder dataHolder = new MARLoader(testfile2).loadFile();
        IMetaData iMetaData = dataHolder.getDataset(0).getMetadata();
        if (iMetaData instanceof IDiffractionMetadata) {
            this.detprops = ((IDiffractionMetadata)iMetaData).getDetector2DProperties();
            this.dce = ((IDiffractionMetadata)iMetaData).getDiffractionCrystalEnvironment();
        }
        double d = this.detprops.getDetectorSizeH();
        double d2 = this.detprops.getDetectorSizeV();
        System.out.println("MAR " + d + " pix size " + this.detprops.getHPxSize() + " num pix " + this.detprops.getPx());
        double d3 = Math.sqrt(d * d + d2 * d2);
        int[] nArray = new int[8];
        nArray[3] = this.detprops.getPx();
        nArray[4] = this.detprops.getPy();
        nArray[6] = this.detprops.getPx();
        nArray[7] = this.detprops.getPy();
        int[] nArray2 = nArray;
        Vector3d vector3d = new Vector3d();
        vector3d.sub((Tuple3d)this.detprops.pixelPosition(nArray2[0], nArray2[1]), (Tuple3d)this.detprops.pixelPosition(this.detprops.getPx(), this.detprops.getPy()));
        Assert.assertEquals((double)d3, (double)vector3d.length(), (double)1.0E-5);
    }

    @Test
    public void testminiCBF() throws Exception {
        DataHolder dataHolder = new CBFLoader(testfile3).loadFile();
        IMetaData iMetaData = dataHolder.getDataset(0).getMetadata();
        if (iMetaData instanceof IDiffractionMetadata) {
            this.detprops = ((IDiffractionMetadata)iMetaData).getDetector2DProperties();
            this.dce = ((IDiffractionMetadata)iMetaData).getDiffractionCrystalEnvironment();
        }
        double d = this.detprops.getDetectorSizeH();
        double d2 = this.detprops.getDetectorSizeV();
        System.out.println("mini cbf " + d + " pix size " + this.detprops.getHPxSize() + " num pix " + this.detprops.getPx());
        double d3 = Math.sqrt(d * d + d2 * d2);
        int[] nArray = new int[8];
        nArray[3] = this.detprops.getPx();
        nArray[4] = this.detprops.getPy();
        nArray[6] = this.detprops.getPx();
        nArray[7] = this.detprops.getPy();
        int[] nArray2 = nArray;
        Vector3d vector3d = new Vector3d();
        vector3d.sub((Tuple3d)this.detprops.pixelPosition(nArray2[0], nArray2[1]), (Tuple3d)this.detprops.pixelPosition(this.detprops.getPx(), this.detprops.getPy()));
        Assert.assertEquals((double)d3, (double)vector3d.length(), (double)1.0E-5);
    }
}

