/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IMetadataProvider;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;

public class DataHolder
implements IMetadataProvider {
    protected static final Logger logger = LoggerFactory.getLogger(DataHolder.class);
    private List<ILazyDataset> data = new Vector<ILazyDataset>();
    private List<String> names = new Vector<String>();
    private IMetaData metadata = new MetaDataAdapter();

    public void addDataset(String string, ILazyDataset iLazyDataset) {
        this.names.add(string);
        this.data.add(iLazyDataset);
    }

    public void addDataset(String string, ILazyDataset iLazyDataset, IMetaData iMetaData) {
        this.names.add(string);
        this.data.add(iLazyDataset);
        this.metadata = iMetaData;
    }

    public void setMetadata(IMetaData iMetaData) {
        this.metadata = iMetaData;
    }

    @Override
    public IMetaData getMetadata() {
        return this.metadata;
    }

    public Map<String, ILazyDataset> getMap() {
        LinkedHashMap<String, ILazyDataset> linkedHashMap = new LinkedHashMap<String, ILazyDataset>();
        int n = this.data.size();
        int n2 = 0;
        while (n2 < n) {
            linkedHashMap.put(this.names.get(n2), this.data.get(n2));
            ++n2;
        }
        return linkedHashMap;
    }

    public List<ILazyDataset> getList() {
        int n = this.data.size();
        ArrayList<ILazyDataset> arrayList = new ArrayList<ILazyDataset>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.data.get(n2));
            ++n2;
        }
        return this.data;
    }

    public void setDataset(int n, ILazyDataset iLazyDataset) {
        this.data.set(n, iLazyDataset);
    }

    public void setDataset(String string, ILazyDataset iLazyDataset) {
        if (this.names.contains(string)) {
            this.data.set(this.names.indexOf(string), iLazyDataset);
        } else {
            this.addDataset(string, iLazyDataset);
        }
    }

    public AbstractDataset getDataset(int n) {
        return DatasetUtils.convertToAbstractDataset(this.data.get(n));
    }

    public AbstractDataset getDataset(String string) {
        if (this.names.contains(string)) {
            return DatasetUtils.convertToAbstractDataset(this.data.get(this.names.indexOf(string)));
        }
        return null;
    }

    public ILazyDataset getLazyDataset(int n) {
        return this.data.get(n);
    }

    public ILazyDataset getLazyDataset(String string) {
        if (this.names.contains(string)) {
            return this.data.get(this.names.indexOf(string));
        }
        return null;
    }

    public boolean contains(String string) {
        return this.names.contains(string);
    }

    public int indexOf(String string) {
        return this.names.indexOf(string);
    }

    public String[] getNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public String getName(int n) {
        if (n >= 0 && n < this.names.size()) {
            return this.names.get(n);
        }
        return null;
    }

    public int size() {
        return this.data.size();
    }

    public int namesSize() {
        return this.names.size();
    }

    public void clear() {
        this.data.clear();
        this.names.clear();
        this.metadata = null;
    }

    public void remove(int n) {
        this.data.remove(n);
        this.names.remove(n);
    }
}

