/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ExtendedMetadataAdapter;
import uk.ac.diamond.scisoft.analysis.io.IDataSetLoader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.gda.monitor.IMonitor;

public class DatLoader
extends AbstractFileLoader
implements IMetaLoader,
IDataSetLoader {
    protected static final transient Logger logger = LoggerFactory.getLogger(DatLoader.class);
    private static final transient String FLOAT = "([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)|(0\\.)";
    private static final transient Pattern DATA = Pattern.compile("^((([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)|(0\\.))\\s+)+(([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)|(0\\.))$");
    protected String fileName;
    protected List<String> header;
    protected Map<String, String> metaData;
    protected List<String> footer;
    protected Map<String, List<Double>> vals;
    protected int columnIndex;
    private static Pattern SCAN_LINE = Pattern.compile("#S \\d+ .*");
    private static Pattern DATE_LINE = Pattern.compile("#D (Sun|Mon|Tue|Wed|Thu|Fri|Sat) [a-zA-Z]+ \\d+ .*");

    public DatLoader() {
    }

    public DatLoader(String string) {
        this.setFile(string);
    }

    public void setFile(String string) {
        this.fileName = string;
        this.header = new ArrayList<String>(31);
        this.metaData = new HashMap<String, String>(7);
        this.footer = new ArrayList<String>(7);
        this.vals = new LinkedHashMap<String, List<Double>>();
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        DataHolder dataHolder = this.loadFile(null, iMonitor);
        return dataHolder;
    }

    private DataHolder loadFile(String string, IMonitor iMonitor) throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        BufferedReader bufferedReader = null;
        try {
            Object object;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), "UTF-8"));
            boolean bl = false;
            String string2 = this.parseHeaders(bufferedReader, string, iMonitor);
            while (string2 != null) {
                if (iMonitor != null) {
                    iMonitor.worked(1);
                }
                if (iMonitor != null && iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loader cancelled during reading!");
                }
                string2 = string2.trim();
                if (!bl && DATA.matcher(string2).matches()) {
                    Iterator<String> iterator;
                    if (string2.startsWith("#")) {
                        bl = true;
                        break;
                    }
                    if (this.vals.isEmpty()) {
                        throw new ScanFileHolderException("Cannot read header for data set names!");
                    }
                    String[] stringArray = string2.split("\\s+");
                    if (this.columnIndex > -1 && string != null) {
                        iterator = stringArray[this.columnIndex];
                        this.vals.get(string).add(Double.parseDouble(((String)((Object)iterator)).trim()));
                    } else {
                        if (stringArray.length != this.vals.size()) {
                            throw new ScanFileHolderException("Data and header must be the same size!");
                        }
                        iterator = this.vals.keySet().iterator();
                        String[] stringArray2 = stringArray;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            object = stringArray2[n2];
                            this.vals.get(iterator.next()).add(Double.parseDouble(((String)object).trim()));
                            ++n2;
                        }
                    }
                }
                string2 = bufferedReader.readLine();
            }
            this.footer.clear();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!bl) continue;
                if (string2.startsWith("#")) {
                    this.footer.add(string2);
                    continue;
                }
                throw new ScanFileHolderException("Every line in the footer must start with #");
            }
            for (String string3 : this.vals.keySet()) {
                object = AbstractDataset.createFromList(this.vals.get(string3));
                ((AbstractDataset)object).setName(string3);
                dataHolder.addDataset(string3, (ILazyDataset)object);
            }
            DataHolder dataHolder2 = dataHolder;
            return dataHolder2;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("DatLoader.loadFile exception loading  " + this.fileName, exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Cannot close stream from file  " + this.fileName, iOException);
            }
        }
    }

    @Override
    public AbstractDataset loadSet(String string, String string2, IMonitor iMonitor) throws Exception {
        this.setFile(string);
        DataHolder dataHolder = this.loadFile(string2, iMonitor);
        return dataHolder.getDataset(string2);
    }

    @Override
    public Map<String, ILazyDataset> loadSets(String string, List<String> list, IMonitor iMonitor) throws Exception {
        this.setFile(string);
        DataHolder dataHolder = this.loadFile(iMonitor);
        Map<String, ILazyDataset> map = dataHolder.getMap();
        map.keySet().retainAll(list);
        return map;
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.fileName)));
        try {
            this.parseHeaders(bufferedReader, null, iMonitor);
        }
        finally {
            bufferedReader.close();
        }
    }

    @Override
    public IMetaData getMetaData() {
        return new ExtendedMetadataAdapter(){

            @Override
            public Collection<String> getMetaNames() {
                return DatLoader.this.metaData.keySet();
            }

            public String getMetaValue(String string) {
                return DatLoader.this.metaData.get(string);
            }

            @Override
            public Collection<String> getDataNames() {
                return Collections.unmodifiableCollection(DatLoader.this.vals.keySet());
            }

            @Override
            public String getScanCommand() {
                if (DatLoader.this.metaData.containsKey("command")) {
                    return DatLoader.this.metaData.get("command");
                }
                return null;
            }
        };
    }

    private String parseHeaders(BufferedReader bufferedReader, String string, IMonitor iMonitor) throws Exception {
        String string2;
        block18: {
            Object object;
            Object object2;
            block19: {
                int n;
                Object object3;
                string2 = bufferedReader.readLine();
                if (string2.trim().startsWith("&")) {
                    throw new Exception("Cannot load SRS files with DatLoader!");
                }
                this.metaData.clear();
                this.header.clear();
                this.vals.clear();
                boolean bl = false;
                boolean bl2 = false;
                while (string2.startsWith("#") || "".equals(string2.trim())) {
                    try {
                        if ("".equals(string2.trim())) continue;
                        bl = true;
                        if (iMonitor != null) {
                            iMonitor.worked(1);
                        }
                        if (iMonitor != null && iMonitor.isCancelled()) {
                            throw new ScanFileHolderException("Loader cancelled during reading!");
                        }
                        if (bl2 && DATE_LINE.matcher(string2.trim()).matches()) {
                            throw new ScanFileHolderException("This file is a multi-scan spec file - use SpecLoader instead!");
                        }
                        bl2 = SCAN_LINE.matcher(string2.trim()).matches();
                        this.header.add(string2);
                        if (!string2.contains(":")) continue;
                        object2 = string2.split(":");
                        object = object2[0].replace("#", "");
                        object3 = object2[1];
                        n = 2;
                        while (n < ((Object)object2).length) {
                            object3 = String.valueOf(object3) + ":" + (String)object2[n];
                            ++n;
                        }
                        this.metaData.put(((String)object).trim(), ((String)object3).trim());
                    }
                    finally {
                        string2 = bufferedReader.readLine();
                    }
                }
                if (this.header.size() < 1) {
                    if (!bl) {
                        object2 = string2.trim().split("\\s+");
                        this.columnIndex = -1;
                        int n2 = 0;
                        while (n2 < ((String[])object2).length) {
                            this.vals.put("Column_" + (n2 + 1), new ArrayList(89));
                            ++n2;
                        }
                    }
                    return string2;
                }
                object2 = this.header.get(this.header.size() - 1);
                object = string2.trim().split("\\s+");
                if (string == null) break block19;
                this.columnIndex = -1;
                this.vals.put(string, new ArrayList(89));
                object3 = new ArrayList<String>(Arrays.asList(((String)object2).substring(1).trim().split("\\s{2,}|\\,\\s+|\\t")));
                if (((String[])object).length > object3.size()) {
                    n = object3.size();
                    while (n < ((Object)object).length) {
                        object3.add((String)("Unknown" + n));
                        ++n;
                    }
                }
                n = 0;
                while (n < object3.size()) {
                    if (((String)object3.get(n)).equals(string)) {
                        this.columnIndex = n;
                        break block18;
                    }
                    ++n;
                }
                break block18;
            }
            this.createValues(this.vals, (String)object2);
            if (((String[])object).length <= this.vals.size()) break block18;
            int n = this.vals.size();
            while (n < ((String[])object).length) {
                this.vals.put("Unknown" + n, new ArrayList(89));
                ++n;
            }
        }
        return string2;
    }

    private void createValues(Map<String, List<Double>> map, String string) {
        String[] stringArray;
        String[] stringArray2 = stringArray = string.substring(1).trim().split("\\s{2,}|\\,\\s+|\\t");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            map.put(string2, new ArrayList(89));
            ++n2;
        }
    }
}

