/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.util.io.FileUtils;

public class CompressedLoader
extends AbstractFileLoader
implements IMetaLoader {
    private AbstractFileLoader loader;
    private static final Pattern ZIP_PATH = Pattern.compile("(.+)\\.(.+)\\." + LoaderFactory.getZipExpression());

    public CompressedLoader() {
    }

    public CompressedLoader(String string) throws Exception {
        this.setFile(string);
    }

    public void setFile(String string) throws Exception {
        Matcher matcher = ZIP_PATH.matcher(new File(string).getName());
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            Class<? extends InputStream> clazz = LoaderFactory.getZipStream(string4);
            Constructor<? extends InputStream> constructor = clazz.getConstructor(InputStream.class);
            InputStream inputStream = constructor.newInstance(new FileInputStream(string));
            if (inputStream instanceof ZipInputStream) {
                ((ZipInputStream)inputStream).getNextEntry();
            }
            File file = File.createTempFile(string2, "." + string3);
            file.deleteOnExit();
            FileUtils.write((BufferedInputStream)new BufferedInputStream(inputStream), (File)file);
            Class<? extends AbstractFileLoader> clazz2 = LoaderFactory.getLoaderClass(string3);
            this.loader = LoaderFactory.getLoader(clazz2, file.getAbsolutePath());
        }
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loader.loadFile();
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        return this.loader.loadFile(iMonitor);
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        this.loader.loadFile(iMonitor);
    }

    @Override
    public IMetaData getMetaData() {
        if (this.loader instanceof IMetaLoader) {
            return ((IMetaLoader)((Object)this.loader)).getMetaData();
        }
        return new MetaDataAdapter();
    }
}

