/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import java.io.IOException;
import java.io.InputStream;
import uk.ac.diamond.scisoft.analysis.io.CRC;

public class CBZip2InputStream
extends InputStream {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private int bsBuff;
    private int bsLive;
    private final CRC crc = new CRC();
    private int nInUse;
    private InputStream in;
    private int currentChar = -1;
    private static final int EOF = 0;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int su_count;
    private int su_ch2;
    private int su_chPrev;
    private int su_i2;
    private int su_j2;
    private int su_rNToGo;
    private int su_rTPos;
    private int su_tPos;
    private char su_z;
    private Data data;
    private static int baseBlockSize = 100000;
    private static int MAX_ALPHA_SIZE = 258;
    private static int MAX_CODE_LEN = 23;
    private int RUNA = 0;
    private int RUNB = 1;
    private static int N_GROUPS = 6;
    private static int G_SIZE = 50;
    private static int MAX_SELECTORS = 2 + 900000 / G_SIZE;
    private int[] rNums = new int[]{619, 720, 127, 481, 931, 816, 813, 233, 566, 247, 985, 724, 205, 454, 863, 491, 741, 242, 949, 214, 733, 859, 335, 708, 621, 574, 73, 654, 730, 472, 419, 436, 278, 496, 867, 210, 399, 680, 480, 51, 878, 465, 811, 169, 869, 675, 611, 697, 867, 561, 862, 687, 507, 283, 482, 129, 807, 591, 733, 623, 150, 238, 59, 379, 684, 877, 625, 169, 643, 105, 170, 607, 520, 932, 727, 476, 693, 425, 174, 647, 73, 122, 335, 530, 442, 853, 695, 249, 445, 515, 909, 545, 703, 919, 874, 474, 882, 500, 594, 612, 641, 801, 220, 162, 819, 984, 589, 513, 495, 799, 161, 604, 958, 533, 221, 400, 386, 867, 600, 782, 382, 596, 414, 171, 516, 375, 682, 485, 911, 276, 98, 553, 163, 354, 666, 933, 424, 341, 533, 870, 227, 730, 475, 186, 263, 647, 537, 686, 600, 224, 469, 68, 770, 919, 190, 373, 294, 822, 808, 206, 184, 943, 795, 384, 383, 461, 404, 758, 839, 887, 715, 67, 618, 276, 204, 918, 873, 777, 604, 560, 951, 160, 578, 722, 79, 804, 96, 409, 713, 940, 652, 934, 970, 447, 318, 353, 859, 672, 112, 785, 645, 863, 803, 350, 139, 93, 354, 99, 820, 908, 609, 772, 154, 274, 580, 184, 79, 626, 630, 742, 653, 282, 762, 623, 680, 81, 927, 626, 789, 125, 411, 521, 938, 300, 821, 78, 343, 175, 128, 250, 170, 774, 972, 275, 999, 639, 495, 78, 352, 126, 857, 956, 358, 619, 580, 124, 737, 594, 701, 612, 669, 112, 134, 694, 363, 992, 809, 743, 168, 974, 944, 375, 748, 52, 600, 747, 642, 182, 862, 81, 344, 805, 988, 739, 511, 655, 814, 334, 249, 515, 897, 955, 664, 981, 649, 113, 974, 459, 893, 228, 433, 837, 553, 268, 926, 240, 102, 654, 459, 51, 686, 754, 806, 760, 493, 403, 415, 394, 687, 700, 946, 670, 656, 610, 738, 392, 760, 799, 887, 653, 978, 321, 576, 617, 626, 502, 894, 679, 243, 440, 680, 879, 194, 572, 640, 724, 926, 56, 204, 700, 707, 151, 457, 449, 797, 195, 791, 558, 945, 679, 297, 59, 87, 824, 713, 663, 412, 693, 342, 606, 134, 108, 571, 364, 631, 212, 174, 643, 304, 329, 343, 97, 430, 751, 497, 314, 983, 374, 822, 928, 140, 206, 73, 263, 980, 736, 876, 478, 430, 305, 170, 514, 364, 692, 829, 82, 855, 953, 676, 246, 369, 970, 294, 750, 807, 827, 150, 790, 288, 923, 804, 378, 215, 828, 592, 281, 565, 555, 710, 82, 896, 831, 547, 261, 524, 462, 293, 465, 502, 56, 661, 821, 976, 991, 658, 869, 905, 758, 745, 193, 768, 550, 608, 933, 378, 286, 215, 979, 792, 961, 61, 688, 793, 644, 986, 403, 106, 366, 905, 644, 372, 567, 466, 434, 645, 210, 389, 550, 919, 135, 780, 773, 635, 389, 707, 100, 626, 958, 165, 504, 920, 176, 193, 713, 857, 265, 203, 50, 668, 108, 645, 990, 626, 197, 510, 357, 358, 850, 858, 364, 936, 638};

    private static void reportCRCError() {
        System.err.println("BZip2 CRC error");
    }

    private void makeMaps() {
        boolean[] blArray = this.data.inUse;
        byte[] byArray = this.data.seqToUnseq;
        int n = 0;
        int n2 = 0;
        while (n2 < 256) {
            if (blArray[n2]) {
                byArray[n++] = (byte)n2;
            }
            ++n2;
        }
        this.nInUse = n;
    }

    public CBZip2InputStream(InputStream inputStream) throws IOException {
        this.in = inputStream;
        this.init();
    }

    @Override
    public int read() throws IOException {
        if (this.in != null) {
            return this.read0();
        }
        throw new IOException("stream closed");
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n < 0) {
            throw new IndexOutOfBoundsException("offs(" + n + ") < 0.");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("len(" + n2 + ") < 0.");
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("offs(" + n + ") + len(" + n2 + ") > dest.length(" + byArray.length + ").");
        }
        if (this.in == null) {
            throw new IOException("stream closed");
        }
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4 && (n3 = this.read0()) >= 0) {
            byArray[n5++] = (byte)n3;
        }
        return n5 == n ? -1 : n5 - n;
    }

    private int read0() throws IOException {
        int n = this.currentChar;
        switch (this.currentState) {
            case 0: {
                return -1;
            }
            case 1: {
                throw new IllegalStateException();
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                throw new IllegalStateException();
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return n;
    }

    private void init() throws IOException {
        int n = this.in.read();
        if (n == 66 && (n = this.in.read()) == 90) {
            n = this.in.read();
        }
        if (n != 104) {
            throw new IOException("Stream is not BZip2 formatted: expected 'h' as first byte but got '" + (char)n + "'");
        }
        int n2 = this.in.read();
        if (n2 < 49 || n2 > 57) {
            throw new IOException("Stream is not BZip2 formatted: illegal blocksize " + (char)n2);
        }
        this.blockSize100k = n2 - 48;
        this.initBlock();
        this.setupBlock();
    }

    private void initBlock() throws IOException {
        char c = this.bsGetUByte();
        char c2 = this.bsGetUByte();
        char c3 = this.bsGetUByte();
        char c4 = this.bsGetUByte();
        char c5 = this.bsGetUByte();
        char c6 = this.bsGetUByte();
        if (c == '\u0017' && c2 == 'r' && c3 == 'E' && c4 == '8' && c5 == 'P' && c6 == '\u0090') {
            this.complete();
        } else {
            if (c != '1' || c2 != 'A' || c3 != 'Y' || c4 != '&' || c5 != 'S' || c6 != 'Y') {
                this.currentState = 0;
                throw new IOException("bad block header");
            }
            this.storedBlockCRC = this.bsGetInt();
            boolean bl = this.blockRandomised = this.bsR(1) == 1;
            if (this.data == null) {
                this.data = new Data(this.blockSize100k);
            }
            this.getAndMoveToFrontDecode();
            this.crc.initialiseCRC();
            this.currentState = 1;
        }
    }

    private void endBlock() {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            this.computedCombinedCRC = this.storedCombinedCRC << 1 | this.storedCombinedCRC >>> 31;
            this.computedCombinedCRC ^= this.storedBlockCRC;
            CBZip2InputStream.reportCRCError();
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private void complete() throws IOException {
        this.storedCombinedCRC = this.bsGetInt();
        this.currentState = 0;
        this.data = null;
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            CBZip2InputStream.reportCRCError();
        }
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream != null) {
            try {
                if (inputStream != System.in) {
                    inputStream.close();
                }
            }
            finally {
                this.data = null;
                this.in = null;
            }
        }
    }

    private int bsR(int n) throws IOException {
        int n2 = this.bsLive;
        int n3 = this.bsBuff;
        if (n2 < n) {
            InputStream inputStream = this.in;
            do {
                int n4;
                if ((n4 = inputStream.read()) < 0) {
                    throw new IOException("unexpected end of stream");
                }
                n3 = n3 << 8 | n4;
            } while ((n2 += 8) < n);
            this.bsBuff = n3;
        }
        this.bsLive = n2 - n;
        return n3 >> n2 - n & (1 << n) - 1;
    }

    private boolean bsGetBit() throws IOException {
        int n = this.bsLive;
        int n2 = this.bsBuff;
        if (n < 1) {
            int n3 = this.in.read();
            if (n3 < 0) {
                throw new IOException("unexpected end of stream");
            }
            n2 = n2 << 8 | n3;
            n += 8;
            this.bsBuff = n2;
        }
        this.bsLive = n - 1;
        return (n2 >> n - 1 & 1) != 0;
    }

    private char bsGetUByte() throws IOException {
        return (char)this.bsR(8);
    }

    private int bsGetInt() throws IOException {
        return ((this.bsR(8) << 8 | this.bsR(8)) << 8 | this.bsR(8)) << 8 | this.bsR(8);
    }

    private static void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5 = n;
        int n6 = 0;
        while (n5 <= n2) {
            n4 = 0;
            while (n4 < n3) {
                if (cArray[n4] == n5) {
                    nArray3[n6++] = n4;
                }
                ++n4;
            }
            ++n5;
        }
        n5 = MAX_CODE_LEN;
        while (--n5 > 0) {
            nArray2[n5] = 0;
            nArray[n5] = 0;
        }
        n5 = 0;
        while (n5 < n3) {
            int n7 = cArray[n5] + '\u0001';
            nArray2[n7] = nArray2[n7] + 1;
            ++n5;
        }
        n5 = 1;
        n6 = nArray2[0];
        while (n5 < MAX_CODE_LEN) {
            nArray2[n5] = n6 += nArray2[n5];
            ++n5;
        }
        n5 = n;
        n6 = 0;
        n4 = nArray2[n5];
        while (n5 <= n2) {
            int n8 = nArray2[n5 + 1];
            n4 = n8;
            nArray[n5] = (n6 += n8 - n4) - 1;
            n6 <<= 1;
            ++n5;
        }
        n5 = n + 1;
        while (n5 <= n2) {
            nArray2[n5] = (nArray[n5 - 1] + 1 << 1) - nArray2[n5];
            ++n5;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void recvDecodingTables() throws IOException {
        var1_1 = this.data;
        var2_2 = var1_1.inUse;
        var3_3 = var1_1.recvDecodingTables_pos;
        var4_4 = var1_1.selector;
        var5_5 = var1_1.selectorMtf;
        var6_6 = 0;
        var7_7 = 0;
        while (var7_7 < 16) {
            if (this.bsGetBit()) {
                var6_6 |= 1 << var7_7;
            }
            ++var7_7;
        }
        var7_7 = 256;
        while (--var7_7 >= 0) {
            var2_2[var7_7] = false;
        }
        var7_7 = 0;
        while (var7_7 < 16) {
            if ((var6_6 & 1 << var7_7) != 0) {
                var8_8 = var7_7 << 4;
                var9_9 = 0;
                while (var9_9 < 16) {
                    if (this.bsGetBit()) {
                        var2_2[var8_8 + var9_9] = true;
                    }
                    ++var9_9;
                }
            }
            ++var7_7;
        }
        this.makeMaps();
        var7_7 = this.nInUse + 2;
        var8_8 = this.bsR(3);
        var9_9 = this.bsR(15);
        var10_10 = 0;
        while (var10_10 < var9_9) {
            var11_12 = 0;
            while (this.bsGetBit()) {
                ++var11_12;
            }
            var5_5[var10_10] = (byte)var11_12;
            ++var10_10;
        }
        var10_10 = var8_8;
        while (--var10_10 >= 0) {
            var3_3[var10_10] = (byte)var10_10;
        }
        var10_10 = 0;
        while (var10_10 < var9_9) {
            var11_12 = var5_5[var10_10] & 255;
            var12_13 = var3_3[var11_12];
            while (var11_12 > 0) {
                var3_3[var11_12] = var3_3[var11_12 - 1];
                --var11_12;
            }
            var3_3[0] = var12_13;
            var4_4[var10_10] = var12_13;
            ++var10_10;
        }
        var10_11 = var1_1.temp_charArray2d;
        var11_12 = 0;
        while (var11_12 < var8_8) {
            var12_13 = this.bsR(5);
            var13_14 = var10_11[var11_12];
            var14_15 = 0;
            ** GOTO lbl70
            {
                var12_13 += this.bsGetBit() != false ? -1 : 1;
                do {
                    if (this.bsGetBit()) continue block10;
                    var13_14[var14_15] = (char)var12_13;
                    ++var14_15;
lbl70:
                    // 2 sources

                } while (var14_15 < var7_7);
            }
            ++var11_12;
        }
        this.createHuffmanDecodingTables(var7_7, var8_8);
    }

    private void createHuffmanDecodingTables(int n, int n2) {
        Data data = this.data;
        char[][] cArray = data.temp_charArray2d;
        int[] nArray = data.minLens;
        int[][] nArray2 = data.limit;
        int[][] nArray3 = data.base;
        int[][] nArray4 = data.perm;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 32;
            int n5 = 0;
            char[] cArray2 = cArray[n3];
            int n6 = n;
            while (--n6 >= 0) {
                int n7 = cArray2[n6];
                if (n7 > n5) {
                    n5 = n7;
                }
                if (n7 >= n4) continue;
                n4 = n7;
            }
            CBZip2InputStream.hbCreateDecodeTables(nArray2[n3], nArray3[n3], nArray4[n3], cArray[n3], n4, n5, n);
            nArray[n3] = n4;
            ++n3;
        }
    }

    private void getAndMoveToFrontDecode() throws IOException {
        this.origPtr = this.bsR(24);
        this.recvDecodingTables();
        InputStream inputStream = this.in;
        Data data = this.data;
        byte[] byArray = data.ll8;
        int[] nArray = data.unzftab;
        byte[] byArray2 = data.selector;
        byte[] byArray3 = data.seqToUnseq;
        char[] cArray = data.getAndMoveToFrontDecode_yy;
        int[] nArray2 = data.minLens;
        int[][] nArray3 = data.limit;
        int[][] nArray4 = data.base;
        int[][] nArray5 = data.perm;
        int n = this.blockSize100k * 100000;
        int n2 = 256;
        while (--n2 >= 0) {
            cArray[n2] = (char)n2;
            nArray[n2] = 0;
        }
        n2 = 0;
        int n3 = G_SIZE - 1;
        int n4 = this.nInUse + 1;
        int n5 = this.getAndMoveToFrontDecode0(0);
        int n6 = this.bsBuff;
        int n7 = this.bsLive;
        int n8 = -1;
        int n9 = byArray2[n2] & 0xFF;
        int[] nArray6 = nArray4[n9];
        int[] nArray7 = nArray3[n9];
        int[] nArray8 = nArray5[n9];
        int n10 = nArray2[n9];
        while (n5 != n4) {
            int n11;
            int n12;
            int n13;
            int n14;
            if (n5 == this.RUNA || n5 == this.RUNB) {
                n14 = -1;
                n13 = 1;
                while (true) {
                    if (n5 == this.RUNA) {
                        n14 += n13;
                    } else {
                        if (n5 != this.RUNB) break;
                        n14 += n13 << 1;
                    }
                    if (n3 == 0) {
                        n3 = G_SIZE - 1;
                        n9 = byArray2[++n2] & 0xFF;
                        nArray6 = nArray4[n9];
                        nArray7 = nArray3[n9];
                        nArray8 = nArray5[n9];
                        n10 = nArray2[n9];
                    } else {
                        --n3;
                    }
                    n12 = n10;
                    while (n7 < n12) {
                        n11 = inputStream.read();
                        if (n11 >= 0) {
                            n6 = n6 << 8 | n11;
                            n7 += 8;
                            continue;
                        }
                        throw new IOException("unexpected end of stream");
                    }
                    n11 = n6 >> n7 - n12 & (1 << n12) - 1;
                    n7 -= n12;
                    while (n11 > nArray7[n12]) {
                        ++n12;
                        while (n7 < 1) {
                            int n15 = inputStream.read();
                            if (n15 >= 0) {
                                n6 = n6 << 8 | n15;
                                n7 += 8;
                                continue;
                            }
                            throw new IOException("unexpected end of stream");
                        }
                        n11 = n11 << 1 | n6 >> --n7 & 1;
                    }
                    n5 = nArray8[n11 - nArray6[n12]];
                    n13 <<= 1;
                }
                n13 = byArray3[cArray[0]];
                int n16 = n13 & 0xFF;
                nArray[n16] = nArray[n16] + (n14 + 1);
                while (n14-- >= 0) {
                    byArray[++n8] = n13;
                }
                if (n8 < n) continue;
                throw new IOException("block overrun");
            }
            if (++n8 >= n) {
                throw new IOException("block overrun");
            }
            n14 = cArray[n5 - 1];
            int n17 = byArray3[n14] & 0xFF;
            nArray[n17] = nArray[n17] + 1;
            byArray[n8] = byArray3[n14];
            if (n5 <= 16) {
                n13 = n5 - 1;
                while (n13 > 0) {
                    cArray[n13--] = cArray[n13];
                }
            } else {
                System.arraycopy(cArray, 0, cArray, 1, n5 - 1);
            }
            cArray[0] = n14;
            if (n3 == 0) {
                n3 = G_SIZE - 1;
                n9 = byArray2[++n2] & 0xFF;
                nArray6 = nArray4[n9];
                nArray7 = nArray3[n9];
                nArray8 = nArray5[n9];
                n10 = nArray2[n9];
            } else {
                --n3;
            }
            n13 = n10;
            while (n7 < n13) {
                n12 = inputStream.read();
                if (n12 >= 0) {
                    n6 = n6 << 8 | n12;
                    n7 += 8;
                    continue;
                }
                throw new IOException("unexpected end of stream");
            }
            n12 = n6 >> n7 - n13 & (1 << n13) - 1;
            n7 -= n13;
            while (n12 > nArray7[n13]) {
                ++n13;
                while (n7 < 1) {
                    n11 = inputStream.read();
                    if (n11 >= 0) {
                        n6 = n6 << 8 | n11;
                        n7 += 8;
                        continue;
                    }
                    throw new IOException("unexpected end of stream");
                }
                n12 = n12 << 1 | n6 >> --n7 & 1;
            }
            n5 = nArray8[n12 - nArray6[n13]];
        }
        this.last = n8;
        this.bsLive = n7;
        this.bsBuff = n6;
    }

    private int getAndMoveToFrontDecode0(int n) throws IOException {
        InputStream inputStream = this.in;
        Data data = this.data;
        int n2 = data.selector[n] & 0xFF;
        int[] nArray = data.limit[n2];
        int n3 = data.minLens[n2];
        int n4 = this.bsR(n3);
        int n5 = this.bsLive;
        int n6 = this.bsBuff;
        while (n4 > nArray[n3]) {
            ++n3;
            while (n5 < 1) {
                int n7 = inputStream.read();
                if (n7 >= 0) {
                    n6 = n6 << 8 | n7;
                    n5 += 8;
                    continue;
                }
                throw new IOException("unexpected end of stream");
            }
            n4 = n4 << 1 | n6 >> --n5 & 1;
        }
        this.bsLive = n5;
        this.bsBuff = n6;
        return data.perm[n2][n4 - data.base[n2][n3]];
    }

    private void setupBlock() throws IOException {
        if (this.data == null) {
            return;
        }
        int[] nArray = this.data.cftab;
        int[] nArray2 = this.data.initTT(this.last + 1);
        byte[] byArray = this.data.ll8;
        nArray[0] = 0;
        System.arraycopy(this.data.unzftab, 0, nArray, 1, 256);
        int n = 1;
        int n2 = nArray[0];
        while (n <= 256) {
            nArray[n] = n2 += nArray[n];
            ++n;
        }
        n = 0;
        n2 = this.last;
        while (n <= n2) {
            int n3 = byArray[n] & 0xFF;
            int n4 = nArray[n3];
            nArray[n3] = n4 + 1;
            nArray2[n4] = n++;
        }
        if (this.origPtr < 0 || this.origPtr >= nArray2.length) {
            throw new IOException("stream corrupted");
        }
        this.su_tPos = nArray2[this.origPtr];
        this.su_count = 0;
        this.su_i2 = 0;
        this.su_ch2 = 256;
        if (this.blockRandomised) {
            this.su_rNToGo = 0;
            this.su_rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            this.su_chPrev = this.su_ch2;
            int n = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = this.rNums[this.su_rTPos] - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_ch2 = n ^= this.su_rNToGo == 1 ? 1 : 0;
            ++this.su_i2;
            this.currentChar = n;
            this.currentState = 3;
            this.crc.updateCRC(n);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            int n;
            this.su_chPrev = this.su_ch2;
            this.su_ch2 = n = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            ++this.su_i2;
            this.currentChar = n;
            this.currentState = 6;
            this.crc.updateCRC(n);
        } else {
            this.currentState = 5;
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.currentState = 2;
            this.su_count = 1;
            this.setupRandPartA();
        } else if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = this.rNums[this.su_rTPos] - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_j2 = 0;
            this.currentState = 4;
            if (this.su_rNToGo == 1) {
                this.su_z = (char)(this.su_z ^ '\u0001');
            }
            this.setupRandPartC();
        } else {
            this.currentState = 2;
            this.setupRandPartA();
        }
    }

    private void setupRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            this.currentChar = this.su_ch2;
            this.crc.updateCRC(this.su_ch2);
            ++this.su_j2;
        } else {
            this.currentState = 2;
            ++this.su_i2;
            this.su_count = 0;
            this.setupRandPartA();
        }
    }

    private void setupNoRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.su_count = 1;
            this.setupNoRandPartA();
        } else if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            this.su_j2 = 0;
            this.setupNoRandPartC();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            int n;
            this.currentChar = n = this.su_ch2;
            this.crc.updateCRC(n);
            ++this.su_j2;
            this.currentState = 7;
        } else {
            ++this.su_i2;
            this.su_count = 0;
            this.setupNoRandPartA();
        }
    }

    static /* synthetic */ int access$0() {
        return MAX_SELECTORS;
    }

    static /* synthetic */ int access$1() {
        return N_GROUPS;
    }

    static /* synthetic */ int access$2() {
        return MAX_ALPHA_SIZE;
    }

    private static final class Data {
        final boolean[] inUse = new boolean[256];
        final byte[] seqToUnseq = new byte[256];
        final byte[] selector = new byte[CBZip2InputStream.access$0()];
        final byte[] selectorMtf = new byte[CBZip2InputStream.access$0()];
        final int[] unzftab = new int[256];
        final int[][] limit = new int[CBZip2InputStream.access$1()][CBZip2InputStream.access$2()];
        final int[][] base = new int[CBZip2InputStream.access$1()][CBZip2InputStream.access$2()];
        final int[][] perm = new int[CBZip2InputStream.access$1()][CBZip2InputStream.access$2()];
        final int[] minLens = new int[CBZip2InputStream.access$1()];
        final int[] cftab = new int[257];
        final char[] getAndMoveToFrontDecode_yy = new char[256];
        final char[][] temp_charArray2d = new char[CBZip2InputStream.access$1()][CBZip2InputStream.access$2()];
        final byte[] recvDecodingTables_pos = new byte[CBZip2InputStream.access$1()];
        int[] tt;
        byte[] ll8;

        Data(int n) {
            this.ll8 = new byte[n * baseBlockSize];
        }

        final int[] initTT(int n) {
            int[] nArray = this.tt;
            if (nArray == null || nArray.length < n) {
                this.tt = nArray = new int[n];
            }
            return nArray;
        }
    }
}

