/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.CBFLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderThreadTestBase;
import uk.ac.gda.util.OSUtils;

public class CBFLoaderThreadTest
extends LoaderThreadTestBase {
    static String testpath = null;
    static String TestFileFolder;

    @BeforeClass
    public static void setUpClass() {
        TestUtils.skipTestIf((boolean)OSUtils.isWindowsOS(), (String)".CBFLoaderThreadTest skipped, since currently failing on Windows");
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        if ((testpath = (TestFileFolder = String.valueOf(TestFileFolder) + "CBFLoaderTest/")).matches("^/[a-zA-Z]:.*")) {
            testpath = testpath.substring(1);
        }
    }

    @Override
    @Test
    public void testInTestThread() throws Exception {
        super.testInTestThread();
    }

    @Ignore
    @Test
    public void testWithTwentyThreads() {
        try {
            super.testWithNThreads(20);
        }
        catch (ScanFileHolderException scanFileHolderException) {
            if (scanFileHolderException.getCause() instanceof OutOfMemoryError || scanFileHolderException.toString().endsWith("Direct buffer memory")) {
                System.out.println("Out of memory: this is common and acceptable for this test");
            } else {
                Assert.fail((String)("Something other than an out of memory exception was thrown: " + scanFileHolderException.toString()));
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("Loading failed for reasons other than out of memory: " + exception.toString()));
        }
    }

    @Override
    public void doTestOfDataSet(int n) throws Exception {
        DataHolder dataHolder = new CBFLoader(String.valueOf(testpath) + "F6_1_001.cbf").loadFile();
        String[] stringArray = dataHolder.getNames();
        assert (stringArray.length == 0);
        assert (dataHolder.getDataset(0).getSize() == 0x900000);
    }
}

