/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.util.TestUtils;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.CBFLoader;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class CBFLoaderTest {
    static String testpath = null;
    static String TestFileFolder;
    static String testfile1;

    static {
        testfile1 = null;
    }

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        if ((testpath = (TestFileFolder = String.valueOf(TestFileFolder) + "CBFLoaderTest/")).matches("^/[a-zA-Z]:.*")) {
            testpath = testpath.substring(1);
        }
    }

    @Test
    public void testExistingFile() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001.cbf").loadFile();
    }

    @Test
    public void testExampleFile1() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "adscconverted_flat_orig.cbf").loadFile();
    }

    @Test
    public void testExampleFile2() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "converted_flat_orig.cbf").loadFile();
    }

    @Test
    public void testExampleFile3() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "mb_LP_1_001_orig.cbf").loadFile();
    }

    @Test
    public void testExampleFile4() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001_xReverse.cbf").loadFile();
    }

    @Test
    public void testExampleFile5() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001_yReverse.cbf").loadFile();
    }

    @Test
    public void testExampleFile6() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001_bothReverse.cbf").loadFile();
    }

    @Test
    public void testExampleFile7() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "F6_1_001_transpose.cbf").loadFile();
    }

    @Test
    public void testExampleFile8() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "xtal5e_1_0010.cbf").loadFile();
    }

    @Test
    public void testExampleFile9() throws Exception {
        new CBFLoader(String.valueOf(testpath) + "insulin_pilatus6mconverted_orig.cbf").loadFile();
    }

    @Test
    public void testLoaderFactory() throws Exception {
        if (LoaderFactory.getData(String.valueOf(testpath) + "F6_1_001_bothReverse.cbf", null) == null) {
            throw new Exception();
        }
        if (LoaderFactory.getData(String.valueOf(testpath) + "xtal5e_1_0010.cbf", null) == null) {
            throw new Exception();
        }
        if (LoaderFactory.getData(String.valueOf(testpath) + "insulin_pilatus6mconverted_orig.cbf", null) == null) {
            throw new Exception();
        }
    }

    private int[] iterateAllOld(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n * n2;
        int[] nArray = new int[n5];
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n) {
                n3 = bl ? (bl2 ? (!bl3 ? n4 : (n2 - 1 - n6) * n + n7) : (!bl3 ? n6 * n + (n - 1 - n7) : n5 - n4 - 1)) : (bl2 ? (!bl3 ? n7 * n2 + n6 : (n - 1 - n7) * n2 + n6) : (!bl3 ? n7 * n2 + (n2 - 1 - n6) : (n - 1 - n7) * n2 + (n2 - 1 - n6)));
                nArray[n3] = n4++;
                ++n7;
            }
            ++n6;
        }
        return nArray;
    }

    private int[] iterateAllNew(int n, int n2, boolean bl, boolean bl2, boolean n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n * n2;
        int[] nArray = new int[n11];
        if (!bl) {
            n10 = n3;
            n3 = bl2 ? 0 : 1;
            boolean bl3 = bl2 = n10 == 0;
        }
        if (n3 == 0) {
            n9 = n;
            n8 = 0;
        } else {
            n9 = -n;
            n8 = n * n2 - n;
        }
        if (bl2) {
            n7 = 1;
        } else {
            n7 = -1;
            n8 += n - 1;
        }
        if (bl) {
            n10 = n2;
            n6 = n;
            n5 = n9;
            n4 = n7;
        } else {
            n10 = n;
            n6 = n2;
            n5 = n7;
            n4 = n9;
        }
        int n12 = 0;
        int n13 = n8;
        int n14 = 0;
        while (n14 < n10) {
            int n15 = n13;
            int n16 = 0;
            while (n16 < n6) {
                nArray[n12++] = n15;
                n15 += n4;
                ++n16;
            }
            n13 += n5;
            ++n14;
        }
        return nArray;
    }

    @Test
    public void testIteration() {
        boolean[] blArray;
        int n = 7;
        int n2 = 3;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        boolean[] blArray3 = blArray = blArray2;
        int n3 = blArray.length;
        int n4 = 0;
        while (n4 < n3) {
            boolean bl = blArray3[n4];
            bl = !bl;
            boolean[] blArray4 = blArray;
            int n5 = blArray.length;
            int n6 = 0;
            while (n6 < n5) {
                boolean bl2 = blArray4[n6];
                boolean[] blArray5 = blArray;
                int n7 = blArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    boolean bl3 = blArray5[n8];
                    bl3 = !bl3;
                    int[] nArray = this.iterateAllOld(n, n2, bl, bl2, bl3);
                    int[] nArray2 = this.iterateAllNew(n, n2, bl, bl2, bl3);
                    int n9 = 0;
                    while (n9 < n * n2) {
                        Assert.assertEquals((String)("Arrays (" + bl + "," + bl2 + "," + bl3 + ") do not match at " + n9), (int)nArray[n9], (int)nArray2[n9]);
                        ++n9;
                    }
                    ++n8;
                }
                ++n6;
            }
            ++n4;
        }
    }
}

