/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.HashMap;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.iucr.cbflib.SWIGTYPE_p_int;
import org.iucr.cbflib.SWIGTYPE_p_p_char;
import org.iucr.cbflib.SWIGTYPE_p_size_t;
import org.iucr.cbflib.SWIGTYPE_p_unsigned_int;
import org.iucr.cbflib.cbf;
import org.iucr.cbflib.cbfConstants;
import org.iucr.cbflib.cbf_handle_struct;
import org.iucr.cbflib.intP;
import org.iucr.cbflib.sizetP;
import org.iucr.cbflib.uintP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.CBFlib.CBFlib;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.CBFError;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.DiffractionMetaDataAdapter;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.gda.monitor.IMonitor;

public class CBFLoader
extends AbstractFileLoader
implements IMetaLoader {
    protected static final transient Logger logger = LoggerFactory.getLogger(CBFLoader.class);
    private String fileName = null;
    private HashMap<String, String> metadata = new HashMap();
    public HashMap<String, Serializable> GDAMetadata = new HashMap();
    private DetectorProperties detectorProperties;
    private DiffractionCrystalEnvironment diffractionCrystalEnvironment;
    static String[] miniCBFheaderNames;

    static {
        CBFlib.loadLibrary();
        miniCBFheaderNames = new String[]{"# Pixel_size", "# Silicon sensor, thickness", "# Exposure_time", "# Exposure_period", "# Tau =", "# Count_cutoff", "# Threshold_setting,", "# N_excluded_pixels =", "# Excluded_pixels:", "# Flat_field:", "# Trim_directory:", "# Wavelength", "# Energy_range", "# Detector_distance", "# Detector_Voffset", "# Beam_xy", "# Flux", "# Filter_transmission", "# Start_angle", "# Angle_increment", "# Detector_2theta", "# Polarization", "# Alpha", "# Kappa", "# Phi", "# Chi", "# Oscillation_axis", "# N_oscillations"};
    }

    public CBFLoader() {
    }

    public CBFLoader(String string) {
        this.fileName = string;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        AbstractDataset abstractDataset = null;
        ImageOrientation imageOrientation = null;
        logger.info("Loading {}", (Object)this.fileName);
        cbf_handle_struct cbf_handle_struct2 = new cbf_handle_struct(this.fileName);
        CBFError.errorChecker(cbf.cbf_rewind_datablock((cbf_handle_struct)cbf_handle_struct2));
        if (CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"diffrn_frame_data")) || CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"diffrn_data_frame"))) {
            imageOrientation = this.readCBFHeaderData(cbf_handle_struct2);
        } else if (this.loadMetadata) {
            imageOrientation = this.readMiniCBFHeader(cbf_handle_struct2);
        } else {
            boolean bl = true;
            bl &= CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"array_data"));
            if (!(bl &= CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"data")))) {
                throw new ScanFileHolderException("Could not find image");
            }
        }
        abstractDataset = this.readCBFBinaryData(cbf_handle_struct2, imageOrientation);
        abstractDataset.setName("image-01");
        cbf_handle_struct2.delete();
        if (this.loadMetadata) {
            abstractDataset.setMetadata(this.getMetaData());
            dataHolder.addDataset(this.fileName, abstractDataset, abstractDataset.getMetadata());
        } else {
            dataHolder.addDataset(this.fileName, abstractDataset);
        }
        return dataHolder;
    }

    private ImageOrientation readMiniCBFHeader(cbf_handle_struct cbf_handle_struct2) throws ScanFileHolderException {
        SWIGTYPE_p_p_char sWIGTYPE_p_p_char = cbf.new_charPP();
        CBFError.errorChecker(cbf.cbf_rewind_datablock((cbf_handle_struct)cbf_handle_struct2));
        CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"array_data"));
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"header_contents"));
        CBFError.errorChecker(cbf.cbf_get_value((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
        String string = new String(cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n = 0;
        boolean bl = false;
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() == 0) continue;
                int n2 = 0;
                while (n2 < miniCBFheaderNames.length) {
                    bl = false;
                    if (string2.contains(miniCBFheaderNames[n2])) {
                        this.metadata.put(miniCBFheaderNames[n2], string2.substring(string2.indexOf(miniCBFheaderNames[n2]) + miniCBFheaderNames[n2].length(), string2.length()).trim());
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) continue;
                this.metadata.put("Unknown " + n, string2);
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new ScanFileHolderException("Error parsing miniCBF header ", iOException);
        }
        CBFError.errorChecker(cbf.cbf_find_tag((cbf_handle_struct)cbf_handle_struct2, (String)"_array_data.data"));
        CBFError.errorChecker(cbf.cbf_rewind_row((cbf_handle_struct)cbf_handle_struct2));
        uintP uintP2 = new uintP();
        intP intP2 = new intP();
        intP intP3 = new intP();
        intP intP4 = new intP();
        intP intP5 = new intP();
        intP intP6 = new intP();
        intP intP7 = new intP();
        sizetP sizetP2 = new sizetP();
        sizetP sizetP3 = new sizetP();
        sizetP sizetP4 = new sizetP();
        sizetP sizetP5 = new sizetP();
        sizetP sizetP6 = new sizetP();
        sizetP sizetP7 = new sizetP();
        SWIGTYPE_p_p_char sWIGTYPE_p_p_char2 = cbf.new_charPP();
        CBFError.errorChecker(cbf.cbf_get_arrayparameters_wdims((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)uintP2.cast(), (SWIGTYPE_p_int)intP2.cast(), (SWIGTYPE_p_size_t)sizetP2.cast(), (SWIGTYPE_p_int)intP3.cast(), (SWIGTYPE_p_int)intP4.cast(), (SWIGTYPE_p_size_t)sizetP3.cast(), (SWIGTYPE_p_int)intP5.cast(), (SWIGTYPE_p_int)intP6.cast(), (SWIGTYPE_p_int)intP7.cast(), (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char2, (SWIGTYPE_p_size_t)sizetP4.cast(), (SWIGTYPE_p_size_t)sizetP5.cast(), (SWIGTYPE_p_size_t)sizetP6.cast(), (SWIGTYPE_p_size_t)sizetP7.cast()));
        int n3 = (int)sizetP4.value();
        int n4 = (int)sizetP5.value();
        this.metadata.put("numPixels_x", Integer.toString(n3));
        this.metadata.put("numPixels_y", Integer.toString(n4));
        uintP2.delete();
        intP2.delete();
        intP3.delete();
        intP4.delete();
        intP5.delete();
        intP6.delete();
        intP7.delete();
        sizetP2.delete();
        sizetP3.delete();
        sizetP4.delete();
        sizetP5.delete();
        sizetP6.delete();
        sizetP7.delete();
        this.createGDAMetadata();
        return new ImageOrientation(n3, n4);
    }

    private void createGDAMetadata() throws ScanFileHolderException {
        try {
            double d;
            String string = this.getMetadataValue("# Pixel_size");
            String[] stringArray = string.split("m x");
            double d2 = Double.parseDouble(stringArray[0]) * 1000.0;
            double d3 = Double.parseDouble(stringArray[1].split("m")[0]) * 1000.0;
            String string2 = this.getMetadataValue("# Beam_xy");
            String[] stringArray2 = string2.split(",");
            double d4 = Double.parseDouble(stringArray2[0].split("\\(")[1]);
            double d5 = Double.parseDouble(stringArray2[1].split("\\)")[0]);
            double[] dArray = new double[]{d4 * d2, d5 * d3, Double.parseDouble(this.getMetadataValue("# Detector_distance").split("m")[0]) * 1000.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation", (Serializable)dArray);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation:NXunits", (Serializable)((Object)"milli*metre"));
            double[] dArray2 = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXorientation", (Serializable)dArray2);
            double[] dArray3 = new double[]{Double.parseDouble(this.getMetadataValue("numPixels_x")) * d2, Double.parseDouble(this.getMetadataValue("numPixels_y")) * d3, 0.0, 0.0, 0.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape", (Serializable)dArray3);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape:NXunits", (Serializable)((Object)"milli*metre"));
            this.GDAMetadata.put("NXdetector:x_pixel_size", Double.valueOf(d2));
            this.GDAMetadata.put("NXdetector:x_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
            this.GDAMetadata.put("NXdetector:y_pixel_size", Double.valueOf(d3));
            this.GDAMetadata.put("NXdetector:y_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
            if (this.getMetadataValue("# Wavelength").contains("A")) {
                d = Double.parseDouble(this.getMetadataValue("# Wavelength").split("A")[0]);
            } else if (this.getMetadataValue("# Wavelength").contains("nm")) {
                d = Double.parseDouble(this.getMetadataValue("# Wavelength").split("nm")[0]) * 10.0;
            } else {
                throw new ScanFileHolderException("The wavelength could not be parsed in from the mini cbf file header");
            }
            this.GDAMetadata.put("NXmonochromator:wavelength", Double.valueOf(d));
            this.GDAMetadata.put("NXmonochromator:wavelength:NXunits", (Serializable)((Object)"Angstrom"));
            this.GDAMetadata.put("NXSample:rotation_start", Double.valueOf(Double.parseDouble(this.getMetadataValue("# Start_angle").split("deg.")[0])));
            this.GDAMetadata.put("NXSample:rotation_start:NXUnits", (Serializable)((Object)"degree"));
            this.GDAMetadata.put("NXSample:rotation_range", Double.valueOf(Double.parseDouble(this.getMetadataValue("# Angle_increment").split("deg.")[0])));
            this.GDAMetadata.put("NXSample:rotation_range:NXUnits", (Serializable)((Object)"degree"));
            this.GDAMetadata.put("NXSample:exposure_time", Double.valueOf(Double.parseDouble(this.getMetadataValue("# Exposure_time").split("s")[0])));
            this.GDAMetadata.put("NXSample:exposure_time:NXUnits", (Serializable)((Object)"seconds"));
            this.GDAMetadata.put("NXdetector:pixel_overload", Double.valueOf(Double.parseDouble(this.getMetadataValue("# Count_cutoff").split("counts")[0])));
            this.GDAMetadata.put("NXdetector:pixel_overload:NXUnits", (Serializable)((Object)"counts"));
            Matrix3d matrix3d = new Matrix3d();
            matrix3d.setIdentity();
            this.detectorProperties = new DetectorProperties(new Vector3d(dArray), Integer.parseInt(this.getMetadataValue("numPixels_x")), Integer.parseInt(this.getMetadataValue("numPixels_y")), d2, d3, matrix3d);
            this.diffractionCrystalEnvironment = new DiffractionCrystalEnvironment(d, Double.parseDouble(this.getMetadataValue("# Start_angle").split("deg.")[0]), Double.parseDouble(this.getMetadataValue("# Angle_increment").split("deg.")[0]), Double.parseDouble(this.getMetadataValue("# Exposure_time").split("s")[0]));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ScanFileHolderException("There was a problem parsing numerical value from string ", numberFormatException);
        }
    }

    private ImageOrientation readCBFHeaderData(cbf_handle_struct cbf_handle_struct2) throws ScanFileHolderException {
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"array_id"));
        SWIGTYPE_p_p_char sWIGTYPE_p_p_char = cbf.new_charPP();
        intP intP2 = new intP();
        CBFError.errorChecker(cbf.cbf_get_value((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
        String string = new String(cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
        this.metadata.put("diffrn_data_frame.array_id", string);
        CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"array_structure_list"));
        CBFError.errorChecker(cbf.cbf_rewind_row((cbf_handle_struct)cbf_handle_struct2));
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"array_id"));
        int n4 = 0;
        int n5 = 0;
        while ((n = cbf.cbf_find_nextrow((cbf_handle_struct)cbf_handle_struct2, (String)string)) == 0) {
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"index"));
            CBFError.errorChecker(cbf.cbf_get_integervalue((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP2.cast()));
            n4 = intP2.value();
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"dimension"));
            CBFError.errorChecker(cbf.cbf_get_integervalue((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP2.cast()));
            this.metadata.put("SIZE " + String.valueOf(n4), String.valueOf(intP2.value()));
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"precedence"));
            CBFError.errorChecker(cbf.cbf_get_integervalue((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP2.cast()));
            n5 = intP2.value();
            this.metadata.put("precedence " + n4, String.valueOf(n5));
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"direction"));
            CBFError.errorChecker(cbf.cbf_get_value((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
            String string2 = new String(cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
            this.metadata.put("direction " + n4, string2);
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"axis_set_id"));
            CBFError.errorChecker(cbf.cbf_get_value((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
            String string3 = new String(cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
            this.metadata.put("axis_set_id " + n4, string3);
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"array_id"));
        }
        intP2.delete();
        if (n != cbfConstants.CBF_NOTFOUND) {
            CBFError.errorChecker(n);
        }
        CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"array_data"));
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"array_id"));
        CBFError.errorChecker(cbf.cbf_find_row((cbf_handle_struct)cbf_handle_struct2, (String)this.metadata.get("diffrn_data_frame.array_id")));
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"data"));
        if (this.metadata.get("axis_set_id 1").equalsIgnoreCase("ELEMENT_X")) {
            bl3 = Integer.valueOf(this.metadata.get("precedence 1")) == 1;
            n2 = Integer.valueOf(this.metadata.get("SIZE 1"));
            n3 = Integer.valueOf(this.metadata.get("SIZE 2"));
            bl = this.metadata.get("direction 1").equalsIgnoreCase("increasing");
            bl2 = this.metadata.get("direction 2").equalsIgnoreCase("increasing");
        } else {
            bl3 = Integer.valueOf(this.metadata.get("precedence 2")) == 1;
            n2 = Integer.valueOf(this.metadata.get("SIZE 2"));
            n3 = Integer.valueOf(this.metadata.get("SIZE 1"));
            bl = this.metadata.get("direction 2").equalsIgnoreCase("increasing");
            bl2 = this.metadata.get("direction 1").equalsIgnoreCase("increasing");
        }
        return new ImageOrientation(n2, n3, bl, bl2, bl3);
    }

    private AbstractDataset readCBFBinaryData(cbf_handle_struct cbf_handle_struct2, ImageOrientation imageOrientation) throws ScanFileHolderException {
        Object[] objectArray;
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        AbstractDataset abstractDataset = null;
        uintP uintP2 = new uintP();
        intP intP2 = new intP();
        intP intP3 = new intP();
        intP intP4 = new intP();
        intP intP5 = new intP();
        intP intP6 = new intP();
        intP intP7 = new intP();
        sizetP sizetP2 = new sizetP();
        sizetP sizetP3 = new sizetP();
        sizetP sizetP4 = new sizetP();
        sizetP sizetP5 = new sizetP();
        sizetP sizetP6 = new sizetP();
        sizetP sizetP7 = new sizetP();
        SWIGTYPE_p_p_char sWIGTYPE_p_p_char = cbf.new_charPP();
        CBFError.errorChecker(cbf.cbf_get_arrayparameters_wdims((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)uintP2.cast(), (SWIGTYPE_p_int)intP2.cast(), (SWIGTYPE_p_size_t)sizetP2.cast(), (SWIGTYPE_p_int)intP3.cast(), (SWIGTYPE_p_int)intP4.cast(), (SWIGTYPE_p_size_t)sizetP3.cast(), (SWIGTYPE_p_int)intP5.cast(), (SWIGTYPE_p_int)intP6.cast(), (SWIGTYPE_p_int)intP7.cast(), (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char, (SWIGTYPE_p_size_t)sizetP4.cast(), (SWIGTYPE_p_size_t)sizetP5.cast(), (SWIGTYPE_p_size_t)sizetP6.cast(), (SWIGTYPE_p_size_t)sizetP7.cast()));
        if (imageOrientation == null) {
            imageOrientation = new ImageOrientation((int)sizetP4.value(), (int)sizetP5.value());
        }
        int n8 = imageOrientation.getXLength();
        int n9 = imageOrientation.getYLength();
        boolean bl = imageOrientation.isXIncreasing();
        int n10 = imageOrientation.isYIncreasing();
        boolean bl2 = imageOrientation.isRowsX();
        boolean bl3 = intP7.value() == 1;
        int n11 = n8 * n9;
        if ((long)n11 != sizetP3.value()) {
            throw new ScanFileHolderException("Mismatch of CBF binary data size");
        }
        uintP2.delete();
        intP5.delete();
        intP6.delete();
        intP7.delete();
        sizetP2.delete();
        sizetP3.delete();
        sizetP4.delete();
        sizetP5.delete();
        sizetP6.delete();
        sizetP7.delete();
        sizetP sizetP8 = new sizetP();
        if (!bl2) {
            n7 = n10;
            n10 = bl ? 0 : 1;
            boolean bl4 = bl = n7 == 0;
        }
        if (n10 == 0) {
            n6 = n8;
            n5 = 0;
        } else {
            n6 = -n8;
            n5 = n8 * n9 - n8;
        }
        if (bl) {
            n4 = 1;
        } else {
            n4 = -1;
            n5 += n8 - 1;
        }
        if (bl2) {
            n7 = n9;
            n3 = n8;
            n2 = n6;
            n = n4;
        } else {
            n7 = n8;
            n3 = n9;
            n2 = n4;
            n = n6;
        }
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (bl3) {
            try {
                object = ByteBuffer.allocateDirect(n11 * 8).order(ByteOrder.nativeOrder()).asDoubleBuffer();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new ScanFileHolderException("CBFloader failed to while allocating the byte buffer ", outOfMemoryError);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("CBFloader failed to while allocating the byte buffer ", exception);
            }
            CBFError.errorChecker(cbf.cbf_get_realarray((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP2.cast(), (Buffer)object, (long)8L, (long)n11, (SWIGTYPE_p_size_t)sizetP8.cast()));
            if ((long)n11 != sizetP8.value()) {
                throw new ScanFileHolderException("Mismatch of CBF binary data size");
            }
            try {
                abstractDataset = new DoubleDataset(n9, n8);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new ScanFileHolderException("CBFLoader failed when creating a DoubleDataset for the data", outOfMemoryError);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("CBFLoader failed when creating a DoubleDataset for the data", exception);
            }
            objectArray = ((DoubleDataset)abstractDataset).getData();
            double d = -1.7976931348623157E308;
            double d2 = Double.MAX_VALUE;
            double d3 = 0.0;
            int n15 = 0;
            while (n15 < n7) {
                n13 = n5;
                int n16 = 0;
                while (n16 < n3) {
                    double d4 = ((DoubleBuffer)object).get(n13);
                    n13 += n;
                    d3 = Double.isInfinite(d4) || Double.isNaN(d4) ? d3 * 19.0 % 2.147483647E9 : (d3 * 19.0 + d4) % 2.147483647E9;
                    objectArray[n12++] = d4;
                    if (d4 > d) {
                        d = d4;
                    }
                    if (d4 < d2) {
                        d2 = d4;
                    }
                    ++n16;
                }
                n5 += n2;
                ++n15;
            }
            n14 = (int)d3;
            abstractDataset.setStoredValue("max", d);
            abstractDataset.setStoredValue("min", d2);
            object = null;
        } else {
            try {
                object = ByteBuffer.allocateDirect(n11 * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new ScanFileHolderException("CBFLoader failed to allocate bytebuffer (intbuffer)", outOfMemoryError);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("CBFLoader failed to allocate bytebuffer (intbuffer)", exception);
            }
            CBFError.errorChecker(cbf.cbf_get_integerarray((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP2.cast(), (Buffer)object, (long)4L, (int)intP3.value(), (long)n11, (SWIGTYPE_p_size_t)sizetP8.cast()));
            if ((long)n11 != sizetP8.value()) {
                throw new ScanFileHolderException("Mismatch of CBF binary data size");
            }
            try {
                abstractDataset = new IntegerDataset(n9, n8);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new ScanFileHolderException("Could not assign IntegerDataset", outOfMemoryError);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Could not assign IntegerDataset", exception);
            }
            objectArray = ((IntegerDataset)abstractDataset).getData();
            int n17 = Integer.MIN_VALUE;
            int n18 = Integer.MAX_VALUE;
            int n19 = 0;
            while (n19 < n7) {
                n13 = n5;
                int n20 = 0;
                while (n20 < n3) {
                    int n21 = ((IntBuffer)object).get(n13);
                    n13 += n;
                    n14 = n14 * 19 + n21;
                    objectArray[n12++] = n21;
                    if (n21 > n17) {
                        n17 = n21;
                    }
                    if (n21 < n18) {
                        n18 = n21;
                    }
                    ++n20;
                }
                n5 += n2;
                ++n19;
            }
            abstractDataset.setStoredValue("max", n17);
            abstractDataset.setStoredValue("min", n18);
            object = null;
        }
        sizetP8.delete();
        intP2.delete();
        intP3.delete();
        intP4.delete();
        n14 = n14 * 19 + abstractDataset.getDtype() * 17 + abstractDataset.getElementsPerItem();
        object = abstractDataset.getShape();
        int n22 = ((Object)object).length;
        int n23 = 0;
        while (n23 < n22) {
            n14 = n14 * 17 + object[n23];
            ++n23;
        }
        abstractDataset.setStoredValue("hash", n14);
        return abstractDataset;
    }

    private String getMetadataValue(String string) throws ScanFileHolderException {
        try {
            String string2 = this.metadata.get(string);
            return string2;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("The keyword " + string + " was not found in the CBF Header", exception);
        }
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        cbf_handle_struct cbf_handle_struct2 = new cbf_handle_struct(this.fileName);
        CBFError.errorChecker(cbf.cbf_rewind_datablock((cbf_handle_struct)cbf_handle_struct2));
        try {
            this.readMiniCBFHeader(cbf_handle_struct2);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Could not create metadata form CBF", exception);
        }
    }

    @Override
    public IMetaData getMetaData() {
        if (this.detectorProperties == null || this.diffractionCrystalEnvironment == null) {
            return new MetaDataAdapter(){

                public String getMetaValue(String string) throws Exception {
                    return (String)CBFLoader.this.metadata.get(string);
                }

                @Override
                public Collection<String> getMetaNames() throws Exception {
                    return CBFLoader.this.metadata.keySet();
                }
            };
        }
        return new DiffractionMetaDataAdapter(){

            @Override
            public DetectorProperties getDetector2DProperties() {
                return CBFLoader.this.detectorProperties;
            }

            @Override
            public DiffractionCrystalEnvironment getDiffractionCrystalEnvironment() {
                return CBFLoader.this.diffractionCrystalEnvironment;
            }

            public String getMetaValue(String string) throws Exception {
                return (String)CBFLoader.this.metadata.get(string);
            }

            @Override
            public Collection<String> getMetaNames() throws Exception {
                return CBFLoader.this.metadata.keySet();
            }

            @Override
            public DiffractionMetaDataAdapter clone() {
                final HashMap hashMap = new HashMap();
                hashMap.putAll(CBFLoader.this.metadata);
                return new DiffractionMetaDataAdapter(){

                    @Override
                    public DetectorProperties getDetector2DProperties() {
                        return CBFLoader.this.detectorProperties.clone();
                    }

                    @Override
                    public DiffractionCrystalEnvironment getDiffractionCrystalEnvironment() {
                        return CBFLoader.this.diffractionCrystalEnvironment.clone();
                    }

                    public String getMetaValue(String string) throws Exception {
                        return (String)hashMap.get(string);
                    }

                    @Override
                    public Collection<String> getMetaNames() throws Exception {
                        return hashMap.keySet();
                    }
                };
            }
        };
    }

    private class ImageOrientation {
        int xLength;
        int yLength;
        boolean xIncreasing;
        boolean yIncreasing;
        boolean isRowsX;

        private ImageOrientation(int n, int n2) {
            this.xLength = n;
            this.yLength = n2;
            this.xIncreasing = true;
            this.yIncreasing = false;
            this.isRowsX = true;
        }

        private ImageOrientation(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            this.xLength = n;
            this.yLength = n2;
            this.xIncreasing = bl;
            this.yIncreasing = bl2;
            this.isRowsX = bl3;
        }

        public int getXLength() {
            return this.xLength;
        }

        public int getYLength() {
            return this.yLength;
        }

        public boolean isXIncreasing() {
            return this.xIncreasing;
        }

        public boolean isYIncreasing() {
            return this.yIncreasing;
        }

        public boolean isRowsX() {
            return this.isRowsX;
        }
    }
}

