/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.util.TestUtils;
import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.ADSCImageLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IExtendedMetadata;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class ADSCImageTest {
    static String TestFileFolder;
    static String testfile1;

    static {
        testfile1 = null;
    }

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        testfile1 = "ADSCImageTest/F6_1_001.img";
    }

    @Test
    public void testLoadFile() throws Exception {
        new ADSCImageLoader(String.valueOf(TestFileFolder) + testfile1).loadFile();
    }

    @Test
    public void testLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData(String.valueOf(TestFileFolder) + testfile1, null);
        if (!dataHolder.getNames()[0].equals("ADSC Image")) {
            throw new Exception();
        }
    }

    @Test
    public void testMetaDataDate() throws Exception {
        DataHolder dataHolder = new ADSCImageLoader(String.valueOf(TestFileFolder) + testfile1).loadFile();
        AbstractDataset abstractDataset = dataHolder.getDataset(0);
        IExtendedMetadata iExtendedMetadata = (IExtendedMetadata)abstractDataset.getMetadata();
        Date date = iExtendedMetadata.getCreation();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        String[] stringArray = gregorianCalendar.getTime().toString().split(" ");
        String[] stringArray2 = ((String)((Object)iExtendedMetadata.getMetaValue("DATE"))).split(" ");
        Assert.assertTrue((boolean)stringArray[0].equalsIgnoreCase(stringArray2[0]));
        Assert.assertTrue((boolean)stringArray[1].equalsIgnoreCase(stringArray2[1]));
        Assert.assertTrue((boolean)stringArray[2].equalsIgnoreCase(stringArray2[2]));
        Assert.assertTrue((boolean)stringArray[3].equalsIgnoreCase(stringArray2[3]));
        Assert.assertTrue((boolean)stringArray[5].equalsIgnoreCase(stringArray2[4]));
    }

    @Test
    public void testFileParsedMetaData() throws Exception {
        DataHolder dataHolder = new ADSCImageLoader(String.valueOf(TestFileFolder) + testfile1).loadFile();
        AbstractDataset abstractDataset = dataHolder.getDataset(0);
        IExtendedMetadata iExtendedMetadata = (IExtendedMetadata)abstractDataset.getMetadata();
        System.out.println("File path is " + iExtendedMetadata.getFullPath());
        System.out.println("File size is " + iExtendedMetadata.getFileSize() + " in bytes");
        System.out.println("File last modified " + iExtendedMetadata.getLastModified().toString());
        System.out.println("File owner is " + iExtendedMetadata.getFileOwner());
    }
}

