/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.DiffractionMetaDataAdapter;
import uk.ac.diamond.scisoft.analysis.io.IDiffractionMetadata;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.Utils;
import uk.ac.gda.monitor.IMonitor;

public class ADSCImageLoader
extends AbstractFileLoader
implements IMetaLoader {
    private String fileName = "";
    private HashMap<String, String> metadata = new HashMap();
    public HashMap<String, Serializable> GDAMetadata = new HashMap();
    private Vector<String> extraHeaders;
    DetectorProperties detectorProperties;
    DiffractionCrystalEnvironment diffractionCrystalEnvironment;
    private boolean keepBitWidth = false;
    private static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private Date date;

    public boolean isKeepBitWidth() {
        return this.keepBitWidth;
    }

    public void setKeepBitWidth(boolean bl) {
        this.keepBitWidth = bl;
    }

    public ADSCImageLoader() {
    }

    public ADSCImageLoader(String string) {
        this(string, false);
    }

    public ADSCImageLoader(String string, boolean bl) {
        this.setFile(string);
        this.keepBitWidth = bl;
    }

    public void setFile(String string) {
        this.fileName = string;
        this.metadata.clear();
        this.GDAMetadata.clear();
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.fileName, "r");
            this.processingMetadata(randomAccessFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ScanFileHolderException("File not found", fileNotFoundException);
        }
        catch (Exception exception) {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw new ScanFileHolderException("There was a problem loading or reading metadata", exception);
        }
        try {
            try {
                int n = Integer.parseInt(this.metadata.get("SIZE1"));
                int n2 = Integer.parseInt(this.metadata.get("SIZE2"));
                int n3 = Integer.parseInt(this.metadata.get("HEADER_BYTES").trim());
                randomAccessFile.seek(n3);
                int[] nArray = new int[]{n, n2};
                byte[] byArray = new byte[n * n2 * 2];
                randomAccessFile.read(byArray);
                AbstractDataset abstractDataset = new IntegerDataset(nArray);
                int[] nArray2 = ((IntegerDataset)abstractDataset).getData();
                int n4 = Integer.MIN_VALUE;
                int n5 = Integer.MAX_VALUE;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (n7 < nArray2.length) {
                    int n9 = Utils.leInt((int)byArray[n8], (int)byArray[n8 + 1]);
                    n6 = n6 * 19 + n9;
                    nArray2[n7] = n9;
                    if (n9 > n4) {
                        n4 = n9;
                    }
                    if (n9 < n5) {
                        n5 = n9;
                    }
                    ++n7;
                    n8 += 2;
                }
                if (this.keepBitWidth || n4 < 32768) {
                    abstractDataset = DatasetUtils.cast(abstractDataset, 2);
                }
                n6 = n6 * 19 + abstractDataset.getDtype() * 17 + abstractDataset.getElementsPerItem();
                n7 = nArray.length;
                n8 = 0;
                while (n8 < n7) {
                    n6 = n6 * 17 + nArray[n8];
                    ++n8;
                }
                abstractDataset.setStoredValue("max", n4);
                abstractDataset.setStoredValue("min", n5);
                abstractDataset.setStoredValue("hash", n6);
                abstractDataset.setName("image-01");
                abstractDataset.setMetadata(this.getMetaData());
                dataHolder.addDataset("ADSC Image", abstractDataset, this.getMetaData());
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("There was a problem reading the ADSC image", exception);
            }
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Problem closing ADSC file", iOException);
            }
        }
        return dataHolder;
    }

    private void processingMetadata(RandomAccessFile randomAccessFile) throws ScanFileHolderException {
        try {
            byte by = randomAccessFile.readByte();
            randomAccessFile.seek(0L);
            if (by != 123) {
                throw new ScanFileHolderException("This is not a valid ADSC image");
            }
            String string = randomAccessFile.readLine();
            while (!string.contains("{")) {
                string = randomAccessFile.readLine();
            }
            while (true) {
                if ((string = randomAccessFile.readLine()).contains("}")) {
                    this.createGDAMetatdata();
                    return;
                }
                if (string.contains("=")) {
                    String[] stringArray = string.split("=");
                    this.metadata.put(stringArray[0], stringArray[1].substring(0, stringArray[1].length() - 1));
                    continue;
                }
                this.extraHeaders.add(string);
            }
        }
        catch (IOException iOException) {
            throw new ScanFileHolderException("There was a problem parsing the ADSC header information", iOException);
        }
    }

    private void createGDAMetatdata() throws ScanFileHolderException {
        try {
            double d = Double.parseDouble(this.getMetadataValue("PIXEL_SIZE"));
            double d2 = (double)Integer.parseInt(this.getMetadataValue("SIZE1")) * d;
            double d3 = (double)Integer.parseInt(this.getMetadataValue("SIZE2")) * d;
            double[] dArray = new double[]{d3 - (d3 - Double.parseDouble(this.getMetadataValue("BEAM_CENTER_Y"))), d2 - (d2 - Double.parseDouble(this.getMetadataValue("BEAM_CENTER_X"))), Double.parseDouble(this.getMetadataValue("DISTANCE"))};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation", (Serializable)dArray);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation:NXunits", (Serializable)((Object)"milli*meter"));
            double[] dArray2 = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXorientation", (Serializable)dArray2);
            double[] dArray3 = new double[]{Double.parseDouble(this.getMetadataValue("SIZE1")) * Double.parseDouble(this.getMetadataValue("PIXEL_SIZE")), Double.parseDouble(this.getMetadataValue("SIZE2")) * Double.parseDouble(this.getMetadataValue("PIXEL_SIZE")), 0.0, 0.0, 0.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape", (Serializable)dArray3);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape:NXshape", (Serializable)((Object)"milli*metre"));
            double[] dArray4 = new double[]{Double.parseDouble(this.getMetadataValue("PIXEL_SIZE")), Double.parseDouble(this.getMetadataValue("PIXEL_SIZE"))};
            this.GDAMetadata.put("NXdetector:x_pixel_size", Double.valueOf(dArray4[0]));
            this.GDAMetadata.put("NXdetector:x_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
            this.GDAMetadata.put("NXdetector:y_pixel_size", Double.valueOf(dArray4[1]));
            this.GDAMetadata.put("NXdetector:y_pixel_size:NXunits", (Serializable)((Object)"milli*metre"));
            this.GDAMetadata.put("NXmonochromator:wavelength", Double.valueOf(Double.parseDouble(this.getMetadataValue("WAVELENGTH"))));
            this.GDAMetadata.put("NXmonochromator:wavelength:NXunits", (Serializable)((Object)"Angstrom"));
            this.GDAMetadata.put("NXSample:rotation_start", Double.valueOf(Double.parseDouble(this.getMetadataValue("OSC_START"))));
            this.GDAMetadata.put("NXSample:rotation_start:NXUnits", (Serializable)((Object)"degree"));
            this.GDAMetadata.put("NXSample:rotation_range", Double.valueOf(Double.parseDouble(this.getMetadataValue("OSC_RANGE"))));
            this.GDAMetadata.put("NXSample:rotation_range:NXUnits", (Serializable)((Object)"degree"));
            this.GDAMetadata.put("NXSample:exposure_time", Double.valueOf(Double.parseDouble(this.getMetadataValue("TIME"))));
            this.GDAMetadata.put("NXSample:exposure_time:NXUnits", (Serializable)((Object)"seconds"));
            Matrix3d matrix3d = new Matrix3d();
            matrix3d.setIdentity();
            this.detectorProperties = new DetectorProperties(new Vector3d(dArray), Integer.parseInt(this.getMetadataValue("SIZE1")), Integer.parseInt(this.getMetadataValue("SIZE2")), Double.parseDouble(this.getMetadataValue("PIXEL_SIZE")), Double.parseDouble(this.getMetadataValue("PIXEL_SIZE")), matrix3d);
            this.diffractionCrystalEnvironment = new DiffractionCrystalEnvironment(Double.parseDouble(this.getMetadataValue("WAVELENGTH")), Double.parseDouble(this.getMetadataValue("OSC_START")), Double.parseDouble(this.getMetadataValue("OSC_RANGE")), Double.parseDouble(this.getMetadataValue("TIME")));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            try {
                this.date = simpleDateFormat.parse(this.metadata.get("DATE"));
            }
            catch (ParseException parseException) {
                throw new ScanFileHolderException("Could not parse the date from the header", parseException);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ScanFileHolderException("There was a problem parsing numerical value from string", numberFormatException);
        }
    }

    private String getMetadataValue(String string) throws ScanFileHolderException {
        try {
            String string2 = this.metadata.get(string);
            return string2;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("The keyword " + string + " was not found in the ADSC Header", exception);
        }
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = new RandomAccessFile(this.fileName, "r");
                this.processingMetadata(randomAccessFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ScanFileHolderException("File not found", fileNotFoundException);
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    @Override
    public IDiffractionMetadata getMetaData() {
        return new DiffractionMetaDataAdapter(new File(this.fileName)){

            @Override
            public DetectorProperties getDetector2DProperties() {
                return ADSCImageLoader.this.detectorProperties;
            }

            @Override
            public DiffractionCrystalEnvironment getDiffractionCrystalEnvironment() {
                return ADSCImageLoader.this.diffractionCrystalEnvironment;
            }

            @Override
            public Serializable getMetaValue(String string) {
                return (Serializable)ADSCImageLoader.this.metadata.get(string);
            }

            @Override
            public Collection<String> getMetaNames() throws Exception {
                return ADSCImageLoader.this.metadata.keySet();
            }

            @Override
            public Map<String, int[]> getDataShapes() {
                int n = Integer.parseInt((String)ADSCImageLoader.this.metadata.get("SIZE1"));
                int n2 = Integer.parseInt((String)ADSCImageLoader.this.metadata.get("SIZE2"));
                HashMap<String, int[]> hashMap = new HashMap<String, int[]>(1);
                hashMap.put("ADSC Image", new int[]{n2, n});
                return hashMap;
            }

            @Override
            public Date getCreation() {
                return ADSCImageLoader.this.date;
            }

            @Override
            public Collection<String> getDataNames() {
                return Collections.unmodifiableCollection(Arrays.asList("ADSC Image"));
            }

            @Override
            public DiffractionMetaDataAdapter clone() {
                final HashMap hashMap = new HashMap(ADSCImageLoader.this.metadata);
                final DetectorProperties detectorProperties = ADSCImageLoader.this.detectorProperties.clone();
                final DiffractionCrystalEnvironment diffractionCrystalEnvironment = ADSCImageLoader.this.diffractionCrystalEnvironment.clone();
                return new DiffractionMetaDataAdapter(new File(ADSCImageLoader.this.fileName)){

                    @Override
                    public DetectorProperties getDetector2DProperties() {
                        return detectorProperties;
                    }

                    @Override
                    public DiffractionCrystalEnvironment getDiffractionCrystalEnvironment() {
                        return diffractionCrystalEnvironment;
                    }

                    public String getMetaValue(String string) {
                        return (String)hashMap.get(string);
                    }

                    @Override
                    public Collection<String> getMetaNames() {
                        return hashMap.keySet();
                    }

                    @Override
                    public Map<String, int[]> getDataShapes() {
                        int n = Integer.parseInt((String)hashMap.get("SIZE1"));
                        int n2 = Integer.parseInt((String)hashMap.get("SIZE2"));
                        HashMap<String, int[]> hashMap2 = new HashMap<String, int[]>(1);
                        hashMap2.put("ADSC Image", new int[]{n2, n});
                        return hashMap2;
                    }

                    @Override
                    public Date getCreation() {
                        return new Date(ADSCImageLoader.this.date.getTime());
                    }

                    @Override
                    public Collection<String> getDataNames() {
                        return Collections.unmodifiableCollection(Arrays.asList("ADSC Image"));
                    }
                };
            }
        };
    }
}

