/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Image;
import uk.ac.diamond.scisoft.analysis.dataset.function.MapToShiftedCartesian;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;

public class AlignImages {
    private static final transient Logger logger = LoggerFactory.getLogger(AlignImages.class);

    public static List<double[]> align(AbstractDataset[] abstractDatasetArray, List<AbstractDataset> list, RectangularROI rectangularROI, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, abstractDatasetArray);
        if (!bl) {
            Collections.reverse(arrayList);
        }
        AbstractDataset abstractDataset = (AbstractDataset)arrayList.get(0);
        int n = arrayList.size();
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
        arrayList2.add(new double[]{0.0, 0.0});
        list.add(abstractDataset);
        int n2 = 1;
        while (n2 < n) {
            AbstractDataset abstractDataset2 = (AbstractDataset)arrayList.get(n2);
            double[] dArray = Image.findTranslation2D(abstractDataset, abstractDataset2, rectangularROI);
            arrayList2.add(dArray);
            MapToShiftedCartesian mapToShiftedCartesian = new MapToShiftedCartesian(dArray[0], dArray[1]);
            list.add(mapToShiftedCartesian.value(abstractDataset2).get(0));
            ++n2;
        }
        return arrayList2;
    }

    public static List<double[]> align(String[] stringArray, List<AbstractDataset> list, RectangularROI rectangularROI, boolean bl) {
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                abstractDatasetArray[n] = LoaderFactory.getData(stringArray[n], false, null).getDataset(0);
            }
            catch (Exception exception) {
                logger.error("Cannot load file {}", (Object)stringArray[n]);
                throw new IllegalArgumentException("Cannot load file " + stringArray[n]);
            }
            ++n;
        }
        return AlignImages.align(abstractDatasetArray, list, rectangularROI, bl);
    }
}

