/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.hdf5;

import java.io.Serializable;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5SymLink;

public class HDF5NodeLink
implements Serializable {
    private HDF5Node from;
    private HDF5Node to;
    private String name;
    private String path;
    private HDF5File file;

    public HDF5NodeLink(HDF5File hDF5File, String string, String string2, HDF5Node hDF5Node, HDF5Node hDF5Node2) {
        if (string2 == null || hDF5Node2 == null) {
            throw new IllegalArgumentException("Path name, link name and destination must be defined");
        }
        this.file = hDF5File;
        this.path = string == null ? "" : string;
        this.name = string2;
        this.from = hDF5Node;
        this.to = hDF5Node2;
    }

    public HDF5Node getSource() {
        return this.from;
    }

    public HDF5Node getDestination() {
        return this.to;
    }

    public boolean isDestinationADataset() {
        return this.to instanceof HDF5Dataset;
    }

    public boolean isDestinationAGroup() {
        return this.to instanceof HDF5Group;
    }

    public boolean isDestinationASymLink() {
        return this.to instanceof HDF5SymLink;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return String.valueOf(this.path) + this.name + '\n' + this.to.toString();
    }

    public String getFullName() {
        return String.valueOf(this.path) + this.name;
    }

    public HDF5File getFile() {
        return this.file;
    }
}

