/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.hdf5;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;

public class HDF5Node
implements Serializable {
    protected LinkedHashMap<String, HDF5Attribute> attributes = new LinkedHashMap();
    protected static final String INDENT = "    ";
    private final long id;
    public static final String SEPARATOR = "/";
    public static final String ATTRIBUTE = "@";

    public HDF5Node(long l) {
        this.id = l;
    }

    public long getID() {
        return this.id;
    }

    public int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public HDF5Attribute getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void addAttribute(HDF5Attribute hDF5Attribute) {
        this.attributes.put(hDF5Attribute.getName(), hDF5Attribute);
    }

    public boolean containsAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public Iterator<String> getAttributeNameIterator() {
        return this.attributes.keySet().iterator();
    }

    public Iterator<HDF5Attribute> getAttributeIterator() {
        return this.attributes.values().iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.attributes.keySet()) {
            stringBuilder.append(INDENT);
            stringBuilder.append(ATTRIBUTE);
            stringBuilder.append(string);
            stringBuilder.append(" = ");
            stringBuilder.append(this.attributes.get(string));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

