/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.hdf5;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5SymLink;

public class HDF5Group
extends HDF5Node
implements Iterable<HDF5NodeLink> {
    protected Map<Long, HDF5Node> pool;
    private int datasets = 0;
    private int groups = 0;
    private final Map<String, HDF5NodeLink> nodes = new LinkedHashMap<String, HDF5NodeLink>();

    public void setGlobalPool(Map<Long, HDF5Node> map) {
        this.pool = map;
    }

    public Map<Long, HDF5Node> getGlobalPool() {
        return this.pool;
    }

    public HDF5Group(long l) {
        super(l);
    }

    public HDF5NodeLink getNodeLink(String string) {
        return this.nodes.get(string);
    }

    public int getNumberOfNodelinks() {
        return this.nodes.size();
    }

    public int getNumberOfGroups() {
        return this.groups;
    }

    public boolean containsGroup(String string) {
        return this.nodes.containsKey(string) && this.nodes.get(string).isDestinationAGroup();
    }

    public void addNodeLink(HDF5NodeLink hDF5NodeLink) {
        HDF5Node hDF5Node;
        String string = hDF5NodeLink.getName();
        if (this.nodes.containsKey(string)) {
            hDF5Node = this.nodes.get(string).getDestination();
            if (hDF5Node instanceof HDF5SymLink) {
                hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
            }
            if (hDF5NodeLink.isDestinationADataset() && !(hDF5Node instanceof HDF5Dataset)) {
                throw new IllegalArgumentException("Cannot add a group as there is a non-group of same name");
            }
            if (hDF5NodeLink.isDestinationAGroup() && !(hDF5Node instanceof HDF5Group)) {
                throw new IllegalArgumentException("Cannot add a group as there is a non-dataset of same name");
            }
        }
        if ((hDF5Node = hDF5NodeLink.getDestination()) instanceof HDF5SymLink) {
            hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
        }
        if (hDF5Node instanceof HDF5Group) {
            ++this.groups;
        } else {
            ++this.datasets;
        }
        this.nodes.put(string, hDF5NodeLink);
    }

    public void addGroup(HDF5File hDF5File, String string, String string2, HDF5Group hDF5Group) {
        if (this.nodes.containsKey(string2)) {
            HDF5Node hDF5Node = this.nodes.get(string2).getDestination();
            if (hDF5Node instanceof HDF5SymLink) {
                hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
            }
            if (hDF5Node instanceof HDF5Dataset) {
                throw new IllegalArgumentException("Cannot add a group as there is a dataset of same name");
            }
        } else {
            ++this.groups;
        }
        this.nodes.put(string2, new HDF5NodeLink(hDF5File, string, string2, this, hDF5Group));
    }

    public void addGroup(HDF5File hDF5File, String string, String string2, HDF5SymLink hDF5SymLink) {
        if (this.nodes.containsKey(string2)) {
            HDF5Node hDF5Node = this.nodes.get(string2).getDestination();
            if (hDF5Node instanceof HDF5SymLink) {
                hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
            }
            if (hDF5Node instanceof HDF5Dataset) {
                throw new IllegalArgumentException("Cannot add a group as there is a dataset of same name");
            }
        } else {
            ++this.groups;
        }
        this.nodes.put(string2, new HDF5NodeLink(hDF5File, string, string2, this, hDF5SymLink));
    }

    public HDF5Group getGroup(String string) {
        if (this.nodes.containsKey(string)) {
            HDF5Node hDF5Node = this.nodes.get(string).getDestination();
            if (hDF5Node instanceof HDF5SymLink) {
                hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
            }
            if (hDF5Node instanceof HDF5Group) {
                return (HDF5Group)hDF5Node;
            }
        }
        throw new IllegalArgumentException("No such group of given name");
    }

    public void removeGroup(String string) {
        if (!this.nodes.containsKey(string)) {
            throw new IllegalArgumentException("No name exists in this group");
        }
        HDF5Node hDF5Node = this.nodes.get(string).getDestination();
        if (hDF5Node instanceof HDF5SymLink) {
            hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
        }
        if (hDF5Node instanceof HDF5Dataset) {
            throw new IllegalArgumentException("Group of given name does not exist in this group");
        }
        this.nodes.remove(string);
        --this.groups;
    }

    public void removeGroup(HDF5Group hDF5Group) {
        for (String string : this.nodes.keySet()) {
            HDF5NodeLink hDF5NodeLink = this.nodes.get(string);
            if (!hDF5NodeLink.getDestination().equals(hDF5Group)) continue;
            this.nodes.remove(string);
            --this.groups;
            return;
        }
        throw new IllegalArgumentException("Given group does not exist in this group");
    }

    public int getNumberOfDatasets() {
        return this.datasets;
    }

    public boolean containsDataset(String string) {
        return this.nodes.containsKey(string) && this.nodes.get(string).isDestinationADataset();
    }

    public void addDataset(HDF5File hDF5File, String string, String string2, HDF5Dataset hDF5Dataset) {
        if (this.nodes.containsKey(string2)) {
            HDF5Node hDF5Node = this.nodes.get(string2).getDestination();
            if (hDF5Node instanceof HDF5SymLink) {
                hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
            }
            if (hDF5Node instanceof HDF5Group) {
                throw new IllegalArgumentException("Cannot add a dataset as there is a group of same name");
            }
        } else {
            ++this.datasets;
        }
        this.nodes.put(string2, new HDF5NodeLink(hDF5File, string, string2, this, hDF5Dataset));
    }

    public void addDataset(HDF5File hDF5File, String string, String string2, HDF5SymLink hDF5SymLink) {
        if (this.nodes.containsKey(string2)) {
            HDF5Node hDF5Node = this.nodes.get(string2).getDestination();
            if (hDF5Node instanceof HDF5SymLink) {
                hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
            }
            if (hDF5Node instanceof HDF5Group) {
                throw new IllegalArgumentException("Cannot add a dataset as there is a group of same name");
            }
        } else {
            ++this.datasets;
        }
        this.nodes.put(string2, new HDF5NodeLink(hDF5File, string, string2, this, hDF5SymLink));
    }

    public HDF5Dataset getDataset(String string) {
        if (this.nodes.containsKey(string)) {
            HDF5Node hDF5Node = this.nodes.get(string).getDestination();
            if (hDF5Node instanceof HDF5SymLink) {
                hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
            }
            if (hDF5Node instanceof HDF5Dataset) {
                return (HDF5Dataset)hDF5Node;
            }
        }
        throw new IllegalArgumentException("No such dataset of given name");
    }

    public void removeDataset(String string) {
        if (!this.nodes.containsKey(string)) {
            throw new IllegalArgumentException("No name exists in this group");
        }
        HDF5Node hDF5Node = this.nodes.get(string).getDestination();
        if (hDF5Node instanceof HDF5SymLink) {
            hDF5Node = ((HDF5SymLink)hDF5Node).getNode();
        }
        if (hDF5Node instanceof HDF5Group) {
            throw new IllegalArgumentException("Dataset of given name does not exist in this group");
        }
        this.nodes.remove(string);
        --this.datasets;
    }

    public void removeDataset(HDF5Dataset hDF5Dataset) {
        for (String string : this.nodes.keySet()) {
            HDF5NodeLink hDF5NodeLink = this.nodes.get(string);
            if (!hDF5NodeLink.getDestination().equals(hDF5Dataset)) continue;
            this.nodes.remove(string);
            --this.datasets;
            return;
        }
        throw new IllegalArgumentException("Given dataset does not exist in this group");
    }

    public void addNode(HDF5File hDF5File, String string, String string2, HDF5Node hDF5Node) {
        if (hDF5Node == null) {
            return;
        }
        if (hDF5Node instanceof HDF5SymLink) {
            if (string2.endsWith("/")) {
                this.addGroup(hDF5File, string, string2, (HDF5SymLink)hDF5Node);
            } else {
                this.addDataset(hDF5File, string, string2, (HDF5SymLink)hDF5Node);
            }
        } else if (hDF5Node instanceof HDF5Dataset) {
            this.addDataset(hDF5File, string, string2, (HDF5Dataset)hDF5Node);
        } else if (hDF5Node instanceof HDF5Group) {
            this.addGroup(hDF5File, string, string2, (HDF5Group)hDF5Node);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        for (String string : this.nodes.keySet()) {
            stringBuilder.append("    ");
            stringBuilder.append(string);
            HDF5Node hDF5Node = this.nodes.get(string).getDestination();
            if (hDF5Node instanceof HDF5SymLink) {
                stringBuilder.append('@');
            } else if (hDF5Node instanceof HDF5Group) {
                stringBuilder.append('/');
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public Iterator<String> getNodeNameIterator() {
        return this.nodes.keySet().iterator();
    }

    public List<ILazyDataset> getDatasets(String string) {
        ArrayList<ILazyDataset> arrayList = new ArrayList<ILazyDataset>();
        for (HDF5NodeLink hDF5NodeLink : this) {
            this.findDatasets(string, arrayList, hDF5NodeLink);
        }
        return arrayList;
    }

    private void findDatasets(String string, List<ILazyDataset> list, HDF5NodeLink hDF5NodeLink) {
        Serializable serializable2;
        HDF5Node hDF5Node = null;
        if (hDF5NodeLink.isDestinationASymLink()) {
            serializable2 = (HDF5SymLink)hDF5NodeLink.getDestination();
            if (serializable2.isDataset()) {
                hDF5Node = serializable2.getNode();
            }
        } else {
            hDF5Node = hDF5NodeLink.getDestination();
        }
        if (hDF5Node == null) {
            return;
        }
        if (hDF5Node instanceof HDF5Group) {
            for (Serializable serializable2 : (HDF5Group)hDF5Node) {
                this.findDatasets(string, list, (HDF5NodeLink)serializable2);
            }
        } else if (hDF5Node instanceof HDF5Dataset && hDF5NodeLink.getName().equals(string) && !list.contains(serializable2 = ((HDF5Dataset)hDF5Node).getDataset())) {
            list.add((ILazyDataset)serializable2);
        }
    }

    public HDF5NodeLink findNodeLink(String string) {
        String string2;
        int n = string.indexOf("/");
        if (n == 0) {
            string = string.substring(1);
            n = string.indexOf("/");
        }
        String string3 = string2 = n < 0 ? string : string.substring(0, n);
        if (this.nodes.containsKey(string2)) {
            HDF5NodeLink hDF5NodeLink = this.nodes.get(string2);
            if (n < 0) {
                return hDF5NodeLink;
            }
            String string4 = string.substring(n + 1);
            if (hDF5NodeLink.isDestinationAGroup()) {
                return ((HDF5Group)hDF5NodeLink.getDestination()).findNodeLink(string4);
            }
        } else {
            n = string2.indexOf("@");
            if (n > 0) {
                HDF5NodeLink hDF5NodeLink;
                string2 = string.substring(0, n);
                String string5 = string.substring(n + 1);
                if (this.nodes.containsKey(string2) && (hDF5NodeLink = this.nodes.get(string2)).getDestination().containsAttribute(string5)) {
                    return hDF5NodeLink;
                }
            }
        }
        return null;
    }

    @Override
    public Iterator<HDF5NodeLink> iterator() {
        return this.nodes.values().iterator();
    }
}

