/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.hdf5;

import java.io.File;
import java.net.URI;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;

public class HDF5File
extends HDF5Node {
    public static final String NXCLASS = "NX_class";
    public static final String HOST_SEPARATOR = ":";
    public static final String FILE_STARTER = "//";
    public static final String ROOT = "/";
    private final URI source;
    private String host;
    private final String path;
    private HDF5NodeLink link;
    private String prefix;
    private static final String UPDIR = "/..";
    private static final String CURDIR = "/.";

    public HDF5File(long l, URI uRI) {
        super(l);
        this.source = uRI;
        this.host = uRI.getHost();
        File file = new File(this.source);
        this.path = file.getAbsolutePath();
        this.prefix = file.getParentFile().getAbsolutePath();
        this.link = new HDF5NodeLink(this, null, ROOT, null, new HDF5Group(l));
    }

    public HDF5File(long l, String string) {
        this(l, new File(string).toURI());
    }

    public URI getSourceURI() {
        return this.source;
    }

    public void setHostname(String string) {
        this.host = string;
    }

    public String getHostname() {
        return this.host;
    }

    public String getFilename() {
        return this.path;
    }

    public HDF5Group getGroup() {
        return (HDF5Group)this.link.getDestination();
    }

    public void setGroup(HDF5Group hDF5Group) {
        this.link = new HDF5NodeLink(this, null, ROOT, this, hDF5Group);
    }

    public HDF5NodeLink getNodeLink() {
        return this.link;
    }

    @Override
    public String toString() {
        return String.valueOf(this.host != null ? String.valueOf(this.host) + HOST_SEPARATOR + FILE_STARTER : "") + this.path;
    }

    public String getParentDirectory() {
        return this.prefix;
    }

    public HDF5NodeLink findNodeLink(String string) {
        String string2 = HDF5File.canonicalizePath(string);
        if (string2.indexOf(ROOT) != 0) {
            return null;
        }
        if (string2.length() == 1) {
            return this.link;
        }
        HDF5Group hDF5Group = (HDF5Group)this.link.getDestination();
        String string3 = string2.substring(1);
        if (!string3.startsWith("@")) {
            return hDF5Group.findNodeLink(string3);
        }
        if (hDF5Group.containsAttribute(string3.substring(1))) {
            return this.link;
        }
        return null;
    }

    public static String canonicalizePath(String string) {
        if (!string.contains(UPDIR) && !string.contains(CURDIR)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = 0;
        while ((n = stringBuilder.indexOf(UPDIR)) >= 0) {
            int n2 = stringBuilder.lastIndexOf(ROOT, n - 1);
            if (n2 <= 0) {
                stringBuilder.insert(0, ROOT);
                ++n;
                ++n2;
            }
            stringBuilder.delete(n2, n + UPDIR.length());
        }
        while ((n = stringBuilder.indexOf(CURDIR)) >= 0) {
            stringBuilder.delete(n, n + CURDIR.length());
        }
        return stringBuilder.toString();
    }
}

