/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.hdf5;

import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.StringDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;

public class HDF5Dataset
extends HDF5Node {
    private boolean string = false;
    private boolean supported = false;
    private ILazyDataset dataset;
    private long[] maxShape;
    private String text;
    private String type;

    public HDF5Dataset(long l) {
        super(l);
    }

    public ILazyDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ILazyDataset iLazyDataset) {
        this.dataset = iLazyDataset;
        this.supported = true;
        this.string = iLazyDataset instanceof StringDataset;
    }

    public void setString(String string) {
        this.text = string;
        this.string = true;
        this.supported = true;
    }

    public boolean isString() {
        return this.string;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public String getString() {
        if (!this.string) {
            return null;
        }
        if (this.text != null) {
            return this.text;
        }
        StringDataset stringDataset = (StringDataset)this.dataset;
        StringBuilder stringBuilder = new StringBuilder();
        IndexIterator indexIterator = stringDataset.getIterator();
        while (indexIterator.hasNext()) {
            stringBuilder.append(stringDataset.getAbs(indexIterator.index));
            stringBuilder.append('\n');
        }
        int n = stringBuilder.length();
        stringBuilder.delete(n - 1, n);
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("    ");
        if (this.string) {
            stringBuilder.append(this.getString());
        } else if (this.supported) {
            stringBuilder.append(this.dataset.toString());
        } else {
            stringBuilder.append("unsupported");
        }
        return stringBuilder.toString();
    }

    public void setTypeName(String string) {
        this.type = string;
    }

    public String getTypeName() {
        return this.type;
    }

    public void setMaxShape(long[] lArray) {
        this.maxShape = lArray;
    }

    public long[] getMaxShape() {
        return this.maxShape;
    }
}

