/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import uk.ac.diamond.scisoft.analysis.fitting.functions.AFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;

public class Quadratic
extends AFunction {
    private static String cname = "Quadratic";
    double a;
    double b;
    double c;

    public Quadratic() {
        super(3);
        this.name = cname;
    }

    public Quadratic(IParameter[] iParameterArray) {
        super(iParameterArray);
        this.name = cname;
    }

    public Quadratic(double d, double d2, double d3, double d4, double d5, double d6) {
        super(3);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(0).setValue((d + d2) / 2.0);
        this.getParameter(1).setLowerLimit(d3);
        this.getParameter(1).setUpperLimit(d4);
        this.getParameter(1).setValue((d3 + d4) / 2.0);
        this.getParameter(2).setLowerLimit(d5);
        this.getParameter(2).setUpperLimit(d6);
        this.getParameter(2).setValue((d5 + d6) / 2.0);
        this.name = cname;
    }

    public Quadratic(double[] dArray) {
        super(dArray);
        this.name = cname;
    }

    private void calcCachedParameters() {
        this.a = this.getParameterValue(0);
        this.b = this.getParameterValue(1);
        this.c = this.getParameterValue(2);
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        return this.a * d * d + this.b * d + this.c;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("A Has Value %f within the bounds [%f,%f]\n", this.getParameterValue(0), this.getParameter(0).getLowerLimit(), this.getParameter(0).getUpperLimit()));
        stringBuilder.append(String.format("B Has Value %f within the bounds [%f,%f]\n", this.getParameterValue(1), this.getParameter(1).getLowerLimit(), this.getParameter(1).getUpperLimit()));
        stringBuilder.append(String.format("C Has Value %f within the bounds [%f,%f]", this.getParameterValue(2), this.getParameter(2).getLowerLimit(), this.getParameter(2).getUpperLimit()));
        return stringBuilder.toString();
    }

    @Override
    public double partialDeriv(int n, double ... dArray) {
        double d = dArray[0];
        switch (n) {
            case 0: {
                return d * d;
            }
            case 1: {
                return d;
            }
            case 2: {
                return 1.0;
            }
        }
        throw new IndexOutOfBoundsException("Parameter index is out of bounds");
    }
}

