/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.fitting.functions.APeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IPeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IdentifiedPeak;

public class PseudoVoigt
extends APeak
implements IPeak {
    private static final double FWHM_TO_SIGMA = 1.0 / Math.sqrt(8.0 * Math.log(2.0));
    private static String cname = "PseudoVoigt";
    double pos;
    double sigma;
    double gamma;
    double mixing;
    double gsq;
    double top;
    double norm;

    public PseudoVoigt(double d, double d2, double d3, double d4, double d5) {
        super(d, d2, d3, d4, d5);
        this.name = cname;
    }

    public PseudoVoigt(IParameter[] iParameterArray) {
        super(iParameterArray);
        this.name = cname;
    }

    public PseudoVoigt(IdentifiedPeak identifiedPeak) {
        super(5);
        double d = identifiedPeak.getMaxXVal() - identifiedPeak.getMinXVal();
        this.getParameter(0).setValue(identifiedPeak.getPos());
        this.getParameter(0).setLowerLimit(identifiedPeak.getMinXVal());
        this.getParameter(0).setUpperLimit(identifiedPeak.getMaxXVal());
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d * 2.0);
        this.getParameter(1).setValue(identifiedPeak.getFWHM() / 2.0);
        this.getParameter(2).setLowerLimit(0.0);
        this.getParameter(2).setUpperLimit(d * 2.0);
        this.getParameter(2).setValue(identifiedPeak.getFWHM() / 2.0);
        this.getParameter(3).setLowerLimit(0.0);
        this.getParameter(3).setUpperLimit(identifiedPeak.getHeight() * 2.0 * (d * 2.0));
        this.getParameter(3).setValue(identifiedPeak.getArea() / 2.0);
        this.getParameter(4).setValue(0.5);
        this.getParameter(4).setLowerLimit(0.0);
        this.getParameter(4).setUpperLimit(1.0);
        this.name = cname;
    }

    public PseudoVoigt(double d, double d2, double d3, double d4) {
        super(5);
        this.getParameter(0).setValue((d + d2) / 2.0);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d3);
        this.getParameter(1).setValue(d3 / 5.0);
        this.getParameter(2).setLowerLimit(0.0);
        this.getParameter(2).setUpperLimit(d3);
        this.getParameter(2).setValue(d3 / 5.0);
        this.getParameter(3).setLowerLimit(0.0);
        this.getParameter(3).setUpperLimit(d4);
        this.getParameter(3).setValue(d4 / 2.0);
        this.getParameter(4).setLowerLimit(0.0);
        this.getParameter(4).setUpperLimit(1.0);
        this.getParameter(4).setValue(0.5);
        this.name = cname;
    }

    public PseudoVoigt createPeakFunction(double d, double d2, double d3, double d4) {
        return new PseudoVoigt(d, d2, d4, d3);
    }

    private void calcCachedParameters() {
        this.pos = this.getParameter(0).getValue();
        this.sigma = this.getParameter(1).getValue() * FWHM_TO_SIGMA;
        this.gamma = this.getParameter(2).getValue() / 2.0;
        double d = this.getParameter(3).getValue();
        this.mixing = this.getParameter(4).getValue();
        this.norm = this.mixing * d / Math.sqrt(Math.PI * 2 * this.sigma * this.sigma);
        this.gsq = this.gamma * this.gamma;
        this.top = (1.0 - this.mixing) * this.gamma * d / Math.PI;
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        double d2 = d - this.pos;
        double d3 = this.top / (d2 * d2 + this.gsq);
        double d4 = d2 / this.sigma;
        double d5 = Math.exp(-0.5 * d4 * d4);
        return d3 += this.norm * d5;
    }

    @Override
    public double getArea() {
        return this.getParameter(3).getValue();
    }

    @Override
    public double getFWHM() {
        double d = this.getParameterValue(0) - (this.getParameterValue(1) + this.getParameterValue(2));
        double d2 = this.getParameterValue(0) + (this.getParameterValue(1) + this.getParameterValue(2));
        DoubleDataset doubleDataset = this.makeDataset(DatasetUtils.linSpace(d, d2, 200, 6));
        doubleDataset = (DoubleDataset)Maths.abs(doubleDataset);
        double d3 = doubleDataset.max().doubleValue() / 2.0;
        List<Double> list = DatasetUtils.crossings(doubleDataset, d3);
        double d4 = list.get(1) - list.get(0);
        double d5 = (d2 - d) / 200.0;
        double d6 = d4 * d5;
        return d6;
    }

    @Override
    public double getPosition() {
        return this.getParameter(0).getValue();
    }

    public double getMaxValue() {
        return this.gamma;
    }
}

