/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.AFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Parameter;

public class Polynomial
extends AFunction {
    private static String cname = "Polynomial";
    final double[] a;
    final int nparams;

    public Polynomial() {
        super(1);
        this.a = new double[1];
        this.nparams = 1;
        this.name = cname;
    }

    public Polynomial(int n) {
        super(n + 1);
        this.a = new double[n + 1];
        this.nparams = n + 1;
        this.name = cname;
    }

    public Polynomial(double[] dArray) {
        super(dArray);
        this.a = new double[dArray.length];
        this.nparams = dArray.length;
        this.name = cname;
    }

    public Polynomial(IParameter[] iParameterArray) {
        super(iParameterArray);
        this.a = new double[iParameterArray.length];
        this.nparams = iParameterArray.length;
        this.name = cname;
    }

    public Polynomial(double[] dArray, double[] dArray2) {
        super(0);
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("");
        }
        this.nparams = dArray.length;
        this.parameters = new Parameter[this.nparams];
        int n = 0;
        while (n < this.nparams) {
            this.parameters[n] = new Parameter(0.5 * (dArray[n] + dArray2[n]), dArray[n], dArray2[n]);
            ++n;
        }
        this.a = new double[this.nparams];
        this.name = cname;
    }

    private void calcCachedParameters() {
        int n = 0;
        while (n < this.nparams) {
            this.a[n] = this.getParameterValue(n);
            ++n;
        }
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        double d2 = this.a[0];
        int n = 1;
        while (n < this.nparams) {
            d2 = d2 * d + this.a[n];
            ++n;
        }
        return d2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.nparams) {
            stringBuilder.append(String.format("Parameter %d has value %f within the bounds [%f,%f]\n", n, this.getParameterValue(n), this.getParameter(n).getLowerLimit(), this.getParameter(n).getUpperLimit()));
            ++n;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public double partialDeriv(int n, double ... dArray) {
        if (n < 0 || n >= this.nparams) {
            throw new IndexOutOfBoundsException("Parameter index is out of bounds");
        }
        double d = dArray[0];
        int n2 = this.nparams - 1 - n;
        switch (n2) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return d;
            }
            case 2: {
                return d * d;
            }
        }
        return Math.pow(d, n2);
    }

    public DoubleDataset makeMatrix(AbstractDataset abstractDataset) {
        int n = abstractDataset.getSize();
        DoubleDataset doubleDataset = new DoubleDataset(n, this.nparams);
        int n2 = 0;
        while (n2 < n) {
            double d = abstractDataset.getDouble(n2);
            double d2 = 1.0;
            int n3 = this.nparams - 1;
            while (n3 >= 0) {
                doubleDataset.setItem(d2, n2, n3--);
                d2 *= d;
            }
            ++n2;
        }
        return doubleDataset;
    }
}

