/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import org.apache.commons.math.special.Gamma;
import uk.ac.diamond.scisoft.analysis.fitting.functions.APeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IPeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IdentifiedPeak;

public class PearsonVII
extends APeak
implements IPeak {
    private static String cname = "PearsonVII";
    double defaultMixing = 2.0;
    double mean;
    double FWHM;
    double mixing;
    double area;
    double c2_fwhm;
    double c3;

    public PearsonVII(double[] dArray) {
        super(dArray);
        this.name = cname;
    }

    public PearsonVII(IParameter[] iParameterArray) {
        super(iParameterArray);
        this.name = cname;
    }

    public PearsonVII(IdentifiedPeak identifiedPeak) {
        super(4);
        double d = identifiedPeak.getMaxXVal() - identifiedPeak.getMinXVal();
        this.getParameter(0).setValue(identifiedPeak.getPos());
        this.getParameter(0).setLowerLimit(identifiedPeak.getMinXVal());
        this.getParameter(0).setUpperLimit(identifiedPeak.getMaxXVal());
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d * 2.0);
        this.getParameter(1).setValue(identifiedPeak.getFWHM() / 2.0);
        this.getParameter(2).setValue(this.defaultMixing);
        this.getParameter(2).setLowerLimit(1.0);
        this.getParameter(2).setUpperLimit(10.0);
        this.getParameter(3).setLowerLimit(0.0);
        this.getParameter(3).setUpperLimit(identifiedPeak.getHeight() * 2.0 * (d * 2.0));
        this.getParameter(3).setValue(identifiedPeak.getArea() / 2.0);
        this.name = cname;
    }

    public PearsonVII(double d, double d2, double d3, double d4) {
        super(4);
        this.getParameter(0).setValue(d + (d2 - d) / 2.0);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d3);
        this.getParameter(1).setValue(d3 / 2.0);
        this.getParameter(2).setValue(this.defaultMixing);
        this.getParameter(2).setLowerLimit(1.0);
        this.getParameter(2).setUpperLimit(10.0);
        this.getParameter(3).setLowerLimit(0.0);
        this.getParameter(3).setUpperLimit(d4);
        this.getParameter(3).setValue(d4 / 10.0);
        this.name = cname;
    }

    public PearsonVII(double d, double d2, double d3, double d4, double d5) {
        super(4);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(0).setValue(d + (d2 - d) / 2.0);
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d3);
        this.getParameter(1).setValue(d3 / 10.0);
        this.getParameter(2).setLowerLimit(1.0);
        this.getParameter(2).setUpperLimit(10.0);
        this.getParameter(2).setValue(d5);
        this.getParameter(3).setLowerLimit(-d4);
        this.getParameter(3).setUpperLimit(d4);
        this.getParameter(3).setValue(d4 / 10.0);
        this.name = cname;
    }

    public PearsonVII createPeakFunction(double d, double d2, double d3, double d4) {
        return new PearsonVII(d, d2, d3, d4);
    }

    private void calcCachedParameters() {
        this.mean = this.getParameterValue(0);
        this.FWHM = this.getParameterValue(1);
        this.mixing = this.getParameterValue(2);
        this.area = this.getParameterValue(3);
        double d = 2.0 * Math.pow(Math.E, Gamma.logGamma((double)this.mixing)) * Math.sqrt(Math.pow(2.0, 1.0 / this.mixing) - 1.0);
        double d2 = Math.pow(Math.E, Gamma.logGamma((double)(this.mixing - 0.5))) * Math.sqrt(Math.PI);
        double d3 = d / d2;
        this.c2_fwhm = d3 / this.FWHM;
        this.c3 = 4.0 * Math.sqrt(Math.pow(2.0, 1.0 / this.mixing) - 1.0);
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        double d2 = this.c3 * Math.pow(d - this.mean, 2.0) / Math.pow(this.FWHM, 2.0);
        double d3 = this.c2_fwhm * Math.pow(1.0 + d2, -this.mixing);
        return d3 * this.area;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Pearson VII position has value %f within the bounds [%f,%f]\n", this.getParameterValue(0), this.getParameter(0).getLowerLimit(), this.getParameter(0).getUpperLimit()));
        stringBuilder.append(String.format("Pearson VII standard deviation has value %f within the bounds [%f,%f]\n", this.getParameterValue(1), this.getParameter(1).getLowerLimit(), this.getParameter(1).getUpperLimit()));
        stringBuilder.append(String.format("Pearson VII kurtosis has value %f within the bounds [%f,%f]", this.getParameterValue(2), this.getParameter(2).getLowerLimit(), this.getParameter(2).getUpperLimit()));
        return stringBuilder.toString();
    }

    @Override
    public double getArea() {
        return this.getParameter(3).getValue();
    }

    @Override
    public double getFWHM() {
        return this.getParameter(1).getValue();
    }

    @Override
    public double getPosition() {
        return this.getParameter(0).getValue();
    }
}

