/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;

public class Parameter
implements Serializable,
IParameter {
    private static final Logger logger = LoggerFactory.getLogger(Parameter.class);
    private double value = 0.0;
    private double upperLimit = Double.MAX_VALUE;
    private double lowerLimit = -1.7976931348623157E308;
    private boolean fixed = false;

    public Parameter() {
    }

    public Parameter(IParameter iParameter) {
        this.value = iParameter.getValue();
        this.upperLimit = iParameter.getUpperLimit();
        this.lowerLimit = iParameter.getLowerLimit();
        this.fixed = iParameter.isFixed();
    }

    public Parameter(double d) {
        this.value = d;
    }

    public Parameter(double d, double d2, double d3) {
        this.value = d;
        this.lowerLimit = d2;
        this.upperLimit = d3;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getUpperLimit() {
        return this.upperLimit;
    }

    @Override
    public double getLowerLimit() {
        return this.lowerLimit;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    @Override
    public void setLimits(double d, double d2) {
        if (d > d2) {
            logger.warn("Cannot set limits: You are trying to set the lower bound to greater than the upper limit");
            return;
        }
        if (d < this.lowerLimit) {
            logger.warn("Parameter value {} is lower than this new lower bound {} - Adjusting value to equal new lower bound value ", (Object)this.value, (Object)d);
            this.value = this.lowerLimit;
        }
        if (d2 > this.upperLimit) {
            logger.warn("Parameter value {} is higher than this new upper bound {} - Adjusting value to equal new upper bound value ", (Object)this.value, (Object)d2);
            this.value = this.upperLimit;
        }
        this.lowerLimit = d;
        this.upperLimit = d2;
    }

    @Override
    public void setLowerLimit(double d) {
        if (d > this.upperLimit) {
            logger.warn("Cannot set lower limit: You are trying to set the lower bound to greater than the upper limit");
            return;
        }
        if (this.value < d) {
            logger.warn("Parameter value {} is lower than this new lower bound {} - Adjusting value to equal new lower bound value ", (Object)this.value, (Object)d);
            this.value = d;
        }
        this.lowerLimit = d;
    }

    @Override
    public void setUpperLimit(double d) {
        if (d < this.lowerLimit) {
            logger.warn("Cannot set upper limit: You are trying to set the upper bound to lower than the lower limit");
            return;
        }
        if (this.value > d) {
            logger.warn("Parameter value is higher than this new upper bound - Adjusting value to equal new upper bound value ");
            this.value = d;
        }
        this.upperLimit = d;
    }

    @Override
    public void setValue(double d) {
        if (d > this.upperLimit || d < this.lowerLimit) {
            return;
        }
        if (this.fixed) {
            return;
        }
        this.value = d;
    }

    public String toString() {
        return "Parameter is " + String.valueOf(this.value);
    }
}

