/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import uk.ac.diamond.scisoft.analysis.fitting.functions.APeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IdentifiedPeak;

public class Lorentzian
extends APeak {
    private static String cname = "Lorentzian";
    double hwhm;
    double hwhm_sq;
    double mean;
    double one_by_pi;
    double area;

    public Lorentzian(double ... dArray) {
        super(dArray);
        this.name = cname;
    }

    public Lorentzian(IParameter[] iParameterArray) {
        super(iParameterArray);
        this.name = cname;
    }

    public Lorentzian(IdentifiedPeak identifiedPeak) {
        super(3);
        double d = identifiedPeak.getMaxXVal() - identifiedPeak.getMinXVal();
        this.getParameter(0).setValue(identifiedPeak.getPos());
        this.getParameter(0).setLowerLimit(identifiedPeak.getMinXVal());
        this.getParameter(0).setUpperLimit(identifiedPeak.getMaxXVal());
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(identifiedPeak.getHeight() * 2.0);
        this.getParameter(1).setValue(identifiedPeak.getHeight());
        this.getParameter(2).setLowerLimit(0.0);
        this.getParameter(2).setUpperLimit(d * 2.0);
        this.getParameter(2).setValue(identifiedPeak.getFWHM() / 4.0);
        this.name = cname;
    }

    public Lorentzian(double d, double d2, double d3, double d4) {
        super(3);
        this.getParameter(0).setValue((d + d2) / 2.0);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d3);
        this.getParameter(1).setValue(d3 / 2.0);
        this.getParameter(2).setLowerLimit(0.0);
        this.getParameter(2).setUpperLimit(d4);
        this.getParameter(2).setValue(d4 / 10.0);
        this.name = cname;
    }

    public Lorentzian createPeakFunction(double d, double d2, double d3, double d4) {
        double d5 = d4 / 2.0;
        double d6 = 2.0 * d3 / d5;
        return new Lorentzian(d, d2, d6, d5);
    }

    private void calcCachedParameters() {
        this.mean = this.getParameterValue(0);
        double d = this.getParameterValue(1);
        this.area = this.getParameterValue(2);
        this.hwhm = d / 2.0;
        this.hwhm_sq = this.hwhm * this.hwhm;
        this.one_by_pi = 0.3183098861837907;
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        double d2 = d - this.mean;
        double d3 = this.one_by_pi * (this.hwhm / (d2 * d2 + this.hwhm_sq));
        return this.area * d3;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Lorentzian position has value %f within the bounds [%f,%f]\n", this.getParameterValue(0), this.getParameter(0).getLowerLimit(), this.getParameter(0).getUpperLimit()));
        stringBuilder.append(String.format("Lorentzian area     has value %f within the bounds [%f,%f]\n", this.getParameterValue(1), this.getParameter(1).getLowerLimit(), this.getParameter(1).getUpperLimit()));
        stringBuilder.append(String.format("Lorentzian gamma    has value %f within the bounds [%f,%f]", this.getParameterValue(2), this.getParameter(2).getLowerLimit(), this.getParameter(2).getUpperLimit()));
        return stringBuilder.toString();
    }

    @Override
    public double getArea() {
        return this.getParameter(2).getValue();
    }

    @Override
    public double getFWHM() {
        return this.getParameter(1).getValue();
    }

    @Override
    public double getPosition() {
        return this.getParameter(0).getValue();
    }
}

