/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import uk.ac.diamond.scisoft.analysis.fitting.functions.APeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IPeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IdentifiedPeak;

public class Gaussian
extends APeak
implements IPeak {
    private static final double FWHM_TO_SIGMA = 1.0 / Math.sqrt(8.0 * Math.log(2.0));
    private static String cname = "Gaussian";
    double pos;
    double sigma;
    double norm;

    public Gaussian(double ... dArray) {
        super(new double[0]);
        if (dArray.length != 3) {
            throw new IllegalArgumentException("A gaussian peak requires 3 parameters, and it has only been given " + dArray.length);
        }
        this.fillParameters(dArray);
        this.getParameter(1).setLowerLimit(0.0);
        this.name = cname;
    }

    public Gaussian(IParameter[] iParameterArray) {
        super(new double[0]);
        if (iParameterArray.length != 3) {
            throw new IllegalArgumentException("A gaussian peak requires 3 parameters, and it has only been given " + iParameterArray.length);
        }
        this.fillParameters(iParameterArray);
        this.getParameter(1).setLowerLimit(0.0);
        this.name = cname;
    }

    public Gaussian(IdentifiedPeak identifiedPeak) {
        super(3);
        double d = identifiedPeak.getMaxXVal() - identifiedPeak.getMinXVal();
        double d2 = identifiedPeak.getFWHM() * 2.0;
        double d3 = identifiedPeak.getPos();
        double d4 = identifiedPeak.getHeight() * 2.0 * (d * 2.0);
        this.getParameter(0).setValue(d3);
        this.getParameter(0).setLimits(d3 - d2, d3 + d2);
        this.getParameter(1).setLimits(0.0, d * 2.0);
        this.getParameter(1).setValue(identifiedPeak.getFWHM() / 2.0);
        this.getParameter(2).setLimits(-d4, d4);
        this.getParameter(2).setValue(identifiedPeak.getArea());
        this.name = cname;
    }

    public Gaussian(double d, double d2, double d3, double d4) {
        super(3);
        this.getParameter(0).setValue(d + (d2 - d) / 2.0);
        this.getParameter(0).setLimits(d, d2);
        this.getParameter(1).setLimits(0.0, d3);
        this.getParameter(1).setValue(d3 / 10.0);
        this.getParameter(2).setLowerLimit(-d4);
        this.getParameter(2).setUpperLimit(d4);
        this.getParameter(2).setValue(d4 / 2.0);
        this.name = cname;
    }

    public Gaussian createPeakFunction(double d, double d2, double d3, double d4) {
        return new Gaussian(d, d2, d3, d4);
    }

    private void calcCachedParameters() {
        this.pos = this.getParameterValue(0);
        this.sigma = this.getParameterValue(1) * FWHM_TO_SIGMA;
        double d = this.getParameterValue(2);
        this.norm = d / Math.sqrt(Math.PI * 2 * this.sigma * this.sigma);
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        double d2 = (d - this.pos) / this.sigma;
        double d3 = Math.exp(-0.5 * d2 * d2);
        return this.norm * d3;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Gaussian position has value %f within the bounds [%f,%f]\n", this.getParameterValue(0), this.getParameter(0).getLowerLimit(), this.getParameter(0).getUpperLimit()));
        stringBuilder.append(String.format("Gaussian FWHM     has value %f within the bounds [%f,%f]\n", this.getParameterValue(1), this.getParameter(1).getLowerLimit(), this.getParameter(1).getUpperLimit()));
        stringBuilder.append(String.format("Gaussian area    has value %f within the bounds [%f,%f]", this.getParameterValue(2), this.getParameter(2).getLowerLimit(), this.getParameter(2).getUpperLimit()));
        return stringBuilder.toString();
    }

    @Override
    public double getArea() {
        return this.getParameter(2).getValue();
    }

    @Override
    public double getFWHM() {
        return this.getParameter(1).getValue();
    }

    @Override
    public double getPosition() {
        return this.getParameter(0).getValue();
    }
}

