/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import uk.ac.diamond.scisoft.analysis.fitting.functions.AFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;

public class Fermi
extends AFunction {
    private static String cname = "Fermi";
    private double mu;
    private double kT;
    private double scale;
    private double C;

    public Fermi(double ... dArray) {
        super(dArray);
        this.name = cname;
    }

    public Fermi(IParameter[] iParameterArray) {
        super(iParameterArray);
        this.name = cname;
    }

    public Fermi(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        super(4);
        this.getParameter(0).setLimits(d, d2);
        this.getParameter(0).setValue((d + d2) / 2.0);
        this.getParameter(1).setLimits(d3, d4);
        this.getParameter(1).setValue((d3 + d4) / 2.0);
        this.getParameter(2).setLimits(d5, d6);
        this.getParameter(2).setValue((d5 + d6) / 2.0);
        this.getParameter(3).setLimits(d7, d8);
        this.getParameter(3).setValue((d7 + d8) / 2.0);
        this.name = cname;
    }

    private void calcCachedParameters() {
        this.mu = this.getParameterValue(0);
        this.kT = this.getParameterValue(1);
        this.scale = this.getParameterValue(2);
        this.C = this.getParameterValue(3);
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        double d2 = (d - this.mu) / this.kT;
        return this.scale / (Math.exp(d2) + 1.0) + this.C;
    }
}

