/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.AFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;

public class CompositeFunction
extends AFunction {
    private List<IParameter> parameterList = new ArrayList<IParameter>();
    private List<AFunction> functionList = new ArrayList<AFunction>();
    private NavigableMap<Integer, AFunction> functionMap = new TreeMap<Integer, AFunction>();
    private static final Logger logger = LoggerFactory.getLogger(CompositeFunction.class);

    public CompositeFunction() {
        super(0);
    }

    public void addFunction(AFunction aFunction) {
        this.addFunction(this.parameterList, this.functionList, this.functionMap, aFunction);
    }

    private void addFunction(List<IParameter> list, List<AFunction> list2, NavigableMap<Integer, AFunction> navigableMap, AFunction aFunction) {
        int n = list.size();
        list2.add(aFunction);
        navigableMap.put(n, aFunction);
        IParameter[] iParameterArray = aFunction.parameters;
        int n2 = aFunction.parameters.length;
        int n3 = 0;
        while (n3 < n2) {
            IParameter iParameter = iParameterArray[n3];
            list.add(iParameter);
            ++n3;
        }
    }

    public void removeFunction(int n) {
        ArrayList<IParameter> arrayList = new ArrayList<IParameter>();
        ArrayList<AFunction> arrayList2 = new ArrayList<AFunction>();
        TreeMap<Integer, AFunction> treeMap = new TreeMap<Integer, AFunction>();
        int n2 = this.functionList.size();
        if (n > n2) {
            logger.error("Index exceed bounds");
            throw new IndexOutOfBoundsException("Index exceed bounds");
        }
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != n) {
                AFunction aFunction = this.functionList.get(n3);
                this.addFunction(arrayList, arrayList2, treeMap, aFunction);
            }
            ++n3;
        }
        this.parameterList = arrayList;
        this.functionList = arrayList2;
        this.functionMap = treeMap;
    }

    @Override
    public int getNoOfFunctions() {
        return this.functionList.size();
    }

    @Override
    public AFunction getFunction(int n) {
        return this.functionList.get(n);
    }

    @Override
    public double val(double ... dArray) {
        double d = 0.0;
        for (AFunction aFunction : this.functionList) {
            d += aFunction.val(dArray);
        }
        return d;
    }

    public DoubleDataset[] display(DoubleDataset ... doubleDatasetArray) {
        if (doubleDatasetArray != null) {
            int cfr_ignored_0 = doubleDatasetArray.length;
        }
        int n = this.getNoOfFunctions();
        DoubleDataset[] doubleDatasetArray2 = new DoubleDataset[n + 1];
        doubleDatasetArray2[0] = this.makeDataset(doubleDatasetArray);
        doubleDatasetArray2[0].setName("Composite function");
        int n2 = 1;
        for (AFunction aFunction : this.functionList) {
            doubleDatasetArray2[n2] = aFunction.makeDataset(doubleDatasetArray);
            doubleDatasetArray2[n2++].setName(aFunction.getName());
        }
        return doubleDatasetArray2;
    }

    public DoubleDataset[] display(DoubleDataset doubleDataset, DoubleDataset doubleDataset2) {
        double d;
        int n = this.getNoOfFunctions();
        DoubleDataset[] doubleDatasetArray = new DoubleDataset[n + 4];
        doubleDatasetArray[0] = new DoubleDataset(doubleDataset2);
        doubleDatasetArray[1] = this.makeDataset(doubleDataset);
        doubleDatasetArray[1].setName("Composite function");
        int n2 = 0;
        while (n2 < doubleDataset.getSize()) {
            double d2 = this.val(doubleDataset.get(n2));
            doubleDatasetArray[1].set(d2, n2++);
        }
        doubleDatasetArray[2] = new DoubleDataset(doubleDataset);
        doubleDatasetArray[2].setName("Error Value");
        double d3 = doubleDataset2.min().doubleValue() - (doubleDataset2.max().doubleValue() - doubleDataset2.min().doubleValue()) / 5.0;
        int n3 = 0;
        while (n3 < doubleDataset.getSize()) {
            d = this.val(doubleDataset.get(n3)) - doubleDataset2.get(n3) + d3;
            doubleDatasetArray[2].set(d, n3++);
        }
        doubleDatasetArray[3] = new DoubleDataset(doubleDataset);
        doubleDatasetArray[3].setName("Error Offset");
        n3 = 0;
        while (n3 < doubleDataset.getSize()) {
            d = d3;
            doubleDatasetArray[3].set(d, n3++);
        }
        n3 = 4;
        for (AFunction aFunction : this.functionList) {
            doubleDatasetArray[n3] = aFunction.makeDataset(doubleDataset);
            doubleDatasetArray[n3++].setName(aFunction.getName());
        }
        return doubleDatasetArray;
    }

    @Override
    public IParameter getParameter(int n) throws IndexOutOfBoundsException {
        try {
            return this.parameterList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            logger.error("Index not in range");
            throw new IndexOutOfBoundsException("Index not in range");
        }
    }

    @Override
    public IParameter[] getParameters() {
        IParameter[] iParameterArray = new IParameter[this.getNoOfParameters()];
        int n = 0;
        for (IParameter iParameter : this.parameterList) {
            iParameterArray[n++] = iParameter;
        }
        return iParameterArray;
    }

    @Override
    public int getNoOfParameters() {
        return this.parameterList.size();
    }

    @Override
    public double getParameterValue(int n) {
        return this.getParameter(n).getValue();
    }

    @Override
    public double[] getParameterValues() {
        double[] dArray = new double[this.getNoOfParameters()];
        int n = 0;
        for (IParameter iParameter : this.parameterList) {
            dArray[n++] = iParameter.getValue();
        }
        return dArray;
    }

    @Override
    public void setParameterValues(double ... dArray) {
        int n = Math.min(dArray.length, this.getNoOfParameters());
        int n2 = 0;
        while (n2 < n) {
            this.parameterList.get(n2).setValue(dArray[n2]);
            ++n2;
        }
        for (AFunction aFunction : this.functionList) {
            aFunction.dirty = true;
        }
        this.dirty = true;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.functionList.size();
        if (n > 1) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(String.format("Function %d - ", n2));
                stringBuffer.append(this.functionList.get(n2).toString());
                ++n2;
            }
        } else if (n == 1) {
            stringBuffer.append(this.functionList.get(0).toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public double partialDeriv(int n, double ... dArray) throws IndexOutOfBoundsException {
        Integer n2 = this.functionMap.floorKey(n);
        if (n2 == null) {
            throw new IndexOutOfBoundsException("There are not enough parameters in the composite function");
        }
        return ((AFunction)this.functionMap.get(n2)).partialDeriv(n - n2, dArray);
    }
}

