/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import uk.ac.diamond.scisoft.analysis.fitting.functions.AFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Fermi;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Parameter;

public class Box
extends AFunction {
    private static String cname = "Box";
    private double mu1;
    private double kT1;
    private double mu2;
    private double kT2;
    private double scale;
    private Fermi fermi1;
    private Fermi fermi2;

    public Box(double ... dArray) {
        super(dArray);
        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[4], 0.0};
        double[] dArray3 = new double[]{dArray[2], dArray[3], dArray[4], 0.0};
        this.fermi1 = new Fermi(dArray2);
        this.fermi2 = new Fermi(dArray3);
        this.name = cname;
    }

    public Box(IParameter[] iParameterArray) {
        super(iParameterArray);
        IParameter[] iParameterArray2 = new IParameter[]{this.getParameter(0), this.getParameter(1), this.getParameter(4), new Parameter(0.0)};
        IParameter[] iParameterArray3 = new IParameter[]{this.getParameter(2), this.getParameter(3), this.getParameter(4), new Parameter(0.0)};
        this.fermi1 = new Fermi(iParameterArray2);
        this.fermi2 = new Fermi(iParameterArray3);
        this.name = cname;
    }

    private void calcCachedParameters() {
        this.mu1 = this.getParameterValue(0);
        this.kT1 = this.getParameterValue(1);
        this.mu2 = this.getParameterValue(2);
        this.kT2 = this.getParameterValue(3);
        this.scale = this.getParameterValue(4);
        this.fermi1 = new Fermi(this.mu1, this.kT1, this.scale, 0.0);
        this.fermi2 = new Fermi(this.mu2, this.kT2, this.scale, 0.0);
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        double d2 = this.fermi1.val(d);
        double d3 = this.fermi2.val(d);
        return d3 - d2;
    }
}

