/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting.functions;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IParameter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Parameter;

public abstract class AFunction
implements IFunction,
Serializable {
    private static final transient Logger logger = LoggerFactory.getLogger(AFunction.class);
    protected IParameter[] parameters;
    protected String name = "default";
    protected boolean dirty = true;
    private static final double PERT = 1.0E-4;

    public AFunction(IParameter[] iParameterArray) {
        this.fillParameters(iParameterArray);
    }

    protected void fillParameters(IParameter[] iParameterArray) {
        this.parameters = new IParameter[iParameterArray.length];
        int n = 0;
        while (n < iParameterArray.length) {
            IParameter iParameter = iParameterArray[n];
            this.parameters[n] = new Parameter(iParameter.getValue(), iParameter.getLowerLimit(), iParameter.getUpperLimit());
            this.parameters[n].setFixed(iParameter.isFixed());
            ++n;
        }
    }

    public AFunction(double[] dArray) {
        this.fillParameters(dArray);
    }

    protected void fillParameters(double[] dArray) {
        this.parameters = new Parameter[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            this.parameters[n] = new Parameter(dArray[n]);
            ++n;
        }
    }

    public AFunction(int n) {
        this.parameters = new Parameter[n];
        int n2 = 0;
        while (n2 < n) {
            this.parameters[n2] = new Parameter();
            ++n2;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public IParameter getParameter(int n) {
        return this.parameters[n];
    }

    @Override
    public IParameter[] getParameters() {
        IParameter[] iParameterArray = new IParameter[this.parameters.length];
        int n = 0;
        while (n < this.parameters.length) {
            iParameterArray[n] = new Parameter(this.parameters[n]);
            ++n;
        }
        return iParameterArray;
    }

    @Override
    public int getNoOfParameters() {
        return this.parameters.length;
    }

    @Override
    public int getNoOfFunctions() {
        return 1;
    }

    @Override
    public IFunction getFunction(int n) {
        return this;
    }

    @Override
    public double getParameterValue(int n) {
        return this.parameters[n].getValue();
    }

    @Override
    public double[] getParameterValues() {
        double[] dArray = new double[this.parameters.length];
        int n = 0;
        while (n < this.parameters.length) {
            dArray[n] = this.getParameterValue(n);
            ++n;
        }
        return dArray;
    }

    @Override
    public void setParameterValues(double ... dArray) {
        int n = Math.min(dArray.length, this.parameters.length);
        int n2 = 0;
        while (n2 < n) {
            this.parameters[n2].setValue(dArray[n2]);
            ++n2;
        }
        this.dirty = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("'%s' has %d parameters:\n", this.name, this.parameters.length));
        int n = 0;
        while (n < this.getNoOfParameters()) {
            stringBuffer.append(String.format("%d) %f in range [%f, %f]\n", n, this.parameters[n].getValue(), this.parameters[n].getLowerLimit(), this.parameters[n].getUpperLimit()));
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public double partialDeriv(int n, double ... dArray) {
        double d = this.parameters[n].getValue();
        if (d != 0.0) {
            this.parameters[n].setValue(d * 0.9999);
            this.dirty = true;
            double d2 = this.val(dArray);
            this.parameters[n].setValue(d * 1.0001);
            this.dirty = true;
            double d3 = this.val(dArray);
            this.parameters[n].setValue(d);
            this.dirty = true;
            return (d3 - d2) / (2.0E-4 * d);
        }
        this.parameters[n].setValue(-1.0E-4);
        this.dirty = true;
        double d4 = this.val(dArray);
        this.parameters[n].setValue(1.0E-4);
        this.dirty = true;
        double d5 = this.val(dArray);
        this.parameters[n].setValue(0.0);
        this.dirty = true;
        return (d5 - d4) / 2.0E-4;
    }

    @Override
    public DoubleDataset makeDataset(IDataset ... iDatasetArray) {
        DoubleDataset doubleDataset = this.makeSerialDataset(iDatasetArray);
        doubleDataset.setName(this.name);
        return doubleDataset;
    }

    protected DoubleDataset makeSerialDataset(IDataset ... iDatasetArray) {
        if (iDatasetArray == null || iDatasetArray.length == 0) {
            logger.error("No values given to evaluate function");
            throw new IllegalArgumentException("No values given to evaluate function");
        }
        int n = AFunction.checkAndGetRank(iDatasetArray);
        if (n == 1) {
            return this.makeDatasetFromHypergrid(iDatasetArray);
        }
        return this.makeDatasetFromDatasets(iDatasetArray);
    }

    private static int checkAndGetRank(IDataset ... iDatasetArray) {
        int n = iDatasetArray.length;
        int n2 = iDatasetArray[0].getRank();
        int n3 = 1;
        while (n3 < n) {
            if (iDatasetArray[n3].getRank() != n2) {
                logger.error("Input value dataset ({}) does not all possess the correct rank {}", (Object)n3, (Object)n2);
                throw new IllegalArgumentException("Input value dataset (" + n3 + ") does not all possess the correct rank " + n2);
            }
            ++n3;
        }
        return n2;
    }

    protected DoubleDataset makeDatasetFromHypergrid(IDataset ... iDatasetArray) {
        int n = iDatasetArray.length - 1;
        int[] nArray = new int[n + 1];
        int n2 = 0;
        while (n2 <= n) {
            nArray[n2] = iDatasetArray[n2].getShape()[0];
            ++n2;
        }
        DoubleDataset doubleDataset = new DoubleDataset(nArray);
        double[] dArray = doubleDataset.getData();
        IndexIterator indexIterator = doubleDataset.getIterator(true);
        int[] nArray2 = indexIterator.getPos();
        double[] dArray2 = new double[n + 1];
        while (indexIterator.hasNext()) {
            if (nArray2[n] == 0) {
                int n3 = 0;
                while (n3 <= n) {
                    dArray2[n3] = iDatasetArray[n3].getDouble(nArray2[n3]);
                    ++n3;
                }
            } else {
                dArray2[n] = iDatasetArray[n].getDouble(nArray2[n]);
            }
            dArray[indexIterator.index] = this.val(dArray2);
        }
        return doubleDataset;
    }

    protected DoubleDataset makeDatasetFromDatasets(IDataset ... iDatasetArray) {
        int n = iDatasetArray.length;
        int[] nArray = iDatasetArray[0].getShape();
        DoubleDataset doubleDataset = new DoubleDataset(nArray);
        double[] dArray = doubleDataset.getData();
        IndexIterator indexIterator = doubleDataset.getIterator(true);
        int[] nArray2 = indexIterator.getPos();
        double[] dArray2 = new double[n];
        while (indexIterator.hasNext()) {
            int n2 = 0;
            while (n2 < n) {
                dArray2[n2] = iDatasetArray[n2].getDouble(nArray2);
                ++n2;
            }
            dArray[indexIterator.index] = this.val(dArray2);
        }
        return doubleDataset;
    }

    public boolean areParametersDirty() {
        return this.dirty;
    }

    public void markParametersClean() {
        this.dirty = false;
    }

    @Override
    public double residual(boolean bl, IDataset iDataset, IDataset ... iDatasetArray) {
        double d = 0.0;
        if (bl) {
            DoubleDataset doubleDataset = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDataset).cast(6);
            double[] dArray = doubleDataset.getData();
            IndexIterator indexIterator = doubleDataset.getIterator(true);
            int n = AFunction.checkAndGetRank(iDatasetArray);
            int[] nArray = indexIterator.getPos();
            if (n == 1) {
                int n2 = iDatasetArray.length - 1;
                double[] dArray2 = new double[n2 + 1];
                while (indexIterator.hasNext()) {
                    if (nArray[n2] == 0) {
                        int n3 = 0;
                        while (n3 <= n2) {
                            dArray2[n3] = iDatasetArray[n3].getDouble(nArray[n3]);
                            ++n3;
                        }
                    } else {
                        dArray2[n2] = iDatasetArray[n2].getDouble(nArray[n2]);
                    }
                    double d2 = dArray[indexIterator.index] - this.val(dArray2);
                    d += d2 * d2;
                }
            } else {
                int n4 = iDatasetArray.length;
                double[] dArray3 = new double[n4];
                while (indexIterator.hasNext()) {
                    int n5 = 0;
                    while (n5 < n4) {
                        dArray3[n5] = iDatasetArray[n5].getDouble(nArray);
                        ++n5;
                    }
                    double d3 = dArray[indexIterator.index] - this.val(dArray3);
                    d += d3 * d3;
                }
            }
        } else {
            logger.error("Stochastic sampling has not been implemented yet");
            throw new UnsupportedOperationException("Stochastic sampling has not been implemented yet");
        }
        return d;
    }
}

