/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.fitting.Generic1DFitter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.APeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.CompositeFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Gaussian;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Lorentzian;
import uk.ac.diamond.scisoft.analysis.fitting.functions.PearsonVII;
import uk.ac.diamond.scisoft.analysis.fitting.functions.PseudoVoigt;
import uk.ac.diamond.scisoft.analysis.optimize.GeneticAlg;

@Ignore(value="Test not finished and is failing. 9 Nov 11")
public class Generic1DFitterGeneticAlgTest {
    static final int dataRange = 550;
    static int[] defaultPeakPos = new int[]{100, 200, 300, 400, 500, 150, 250, 350, 450};
    static final int defaultFWHM = 20;
    static final int defaultArea = 50;
    static final double delta = 0.5;
    static final double lambda = 0.1;
    static final boolean backgroundDominated = true;
    static final boolean autoStopping = true;
    static final double threshold = 0.1;
    static final int numPeaks = -1;
    static final int smoothing = 5;
    static final DoubleDataset xAxis = (DoubleDataset)AbstractDataset.arange(0.0, 550.0, 1.0, 6);

    @Test
    public void testPearsonVIIFitting() {
        int n = defaultPeakPos.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = defaultPeakPos[n2];
            ++n2;
        }
        DoubleDataset doubleDataset = this.generatePearsonVII(n);
        try {
            this.FittingTestGeneticAlg(nArray, doubleDataset, new PearsonVII(10.0, 10.0, 10.0, 10.0, 10.0));
        }
        catch (Exception exception) {
            System.out.println(exception);
            Assert.fail((String)"The number of generated peaks did not match the number of peaks found using Genetic Algs");
        }
    }

    @Test
    public void testGaussianFitting() {
        int n = defaultPeakPos.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = defaultPeakPos[n2];
            ++n2;
        }
        DoubleDataset doubleDataset = this.generateGaussianPeaks(n);
        try {
            this.FittingTestGeneticAlg(nArray, doubleDataset, new Gaussian(10.0, 10.0, 10.0));
        }
        catch (Exception exception) {
            System.out.println(exception);
            Assert.fail((String)"The number of generated peaks did not match the number of peaks found using Genetic Algs");
        }
    }

    @Test
    public void testPseudoVoigt() {
        int n = defaultPeakPos.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = defaultPeakPos[n2];
            ++n2;
        }
        DoubleDataset doubleDataset = this.generatePseudoVoigt(n);
        try {
            this.FittingTestGeneticAlg(nArray, doubleDataset, new PseudoVoigt(1.0, 1.0, 1.0, 1.0));
        }
        catch (Exception exception) {
            System.out.println(exception);
            Assert.fail((String)"The number of generated peaks did not match the number of peaks found using Genetic Algs");
        }
    }

    @Test
    public void testLorentzianFitting() {
        int n = defaultPeakPos.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = defaultPeakPos[n2];
            ++n2;
        }
        DoubleDataset doubleDataset = this.generateLorentzianPeaks(n);
        try {
            this.FittingTestGeneticAlg(nArray, doubleDataset, new Lorentzian(10.0));
        }
        catch (Exception exception) {
            System.out.println(exception);
            Assert.fail((String)"The number of generated peaks did not match the number of peaks found using Genetic Algs");
        }
    }

    private DoubleDataset generatePseudoVoigt(int n) {
        CompositeFunction compositeFunction = new CompositeFunction();
        if (n > defaultPeakPos.length) {
            n = defaultPeakPos.length;
        }
        int n2 = 0;
        while (n2 < n) {
            compositeFunction.addFunction(new PseudoVoigt((double)(defaultPeakPos[n2] - 20), (double)(defaultPeakPos[n2] + 20), 20.0, 50.0));
            ++n2;
        }
        DoubleDataset doubleDataset = compositeFunction.makeDataset(xAxis);
        return (DoubleDataset)Maths.add((AbstractDataset)doubleDataset, this.generateNoisePlusBackground());
    }

    private DoubleDataset generatePearsonVII(int n) {
        CompositeFunction compositeFunction = new CompositeFunction();
        if (n > defaultPeakPos.length) {
            n = defaultPeakPos.length;
        }
        int n2 = 0;
        while (n2 < n) {
            compositeFunction.addFunction(new PearsonVII((double)(defaultPeakPos[n2] - 20), (double)(defaultPeakPos[n2] + 20), 20.0, 50.0));
            ++n2;
        }
        DoubleDataset doubleDataset = compositeFunction.makeDataset(xAxis);
        return (DoubleDataset)Maths.add((AbstractDataset)doubleDataset, this.generateNoisePlusBackground());
    }

    private DoubleDataset generateLorentzianPeaks(int n) {
        CompositeFunction compositeFunction = new CompositeFunction();
        if (n > defaultPeakPos.length) {
            n = defaultPeakPos.length;
        }
        int n2 = 0;
        while (n2 < n) {
            compositeFunction.addFunction(new Lorentzian((double)(defaultPeakPos[n2] - 20), (double)(defaultPeakPos[n2] + 20), 20.0, 50.0));
            ++n2;
        }
        DoubleDataset doubleDataset = compositeFunction.makeDataset(xAxis);
        return (DoubleDataset)Maths.add((AbstractDataset)doubleDataset, this.generateNoisePlusBackground());
    }

    private DoubleDataset generateGaussianPeaks(int n) {
        CompositeFunction compositeFunction = new CompositeFunction();
        if (n > defaultPeakPos.length) {
            n = defaultPeakPos.length;
        }
        int n2 = 0;
        while (n2 < n) {
            compositeFunction.addFunction(new Gaussian((double)(defaultPeakPos[n2] - 20), (double)(defaultPeakPos[n2] + 20), 20.0, 50.0));
            ++n2;
        }
        DoubleDataset doubleDataset = compositeFunction.makeDataset(xAxis);
        return (DoubleDataset)Maths.add((AbstractDataset)doubleDataset, this.generateNoisePlusBackground());
    }

    private DoubleDataset generateNoisePlusBackground() {
        return this.generateBackground();
    }

    private DoubleDataset generateBackground() {
        CompositeFunction compositeFunction = new CompositeFunction();
        compositeFunction.addFunction(new Gaussian(-10.0, 10.0, 137.0, 275.0));
        return compositeFunction.makeDataset(DoubleDataset.arange(550.0));
    }

    private void FittingTestGeneticAlg(int[] nArray, DoubleDataset doubleDataset, APeak aPeak) {
        List<APeak> list = Generic1DFitter.fitPeaks(xAxis, doubleDataset, aPeak, new GeneticAlg(1.0E-4), 5, -1, 0.1, true, true);
        double[] dArray = new double[list.size()];
        int n = 0;
        for (APeak aPeak2 : list) {
            dArray[n++] = aPeak2.getPosition();
        }
        Arrays.sort(dArray);
        Arrays.sort(nArray);
        Assert.assertEquals((String)"The number of peaks found was not the same as generated", (long)nArray.length, (long)dArray.length);
        int n2 = 0;
        while (n2 < dArray.length) {
            Assert.assertEquals((double)nArray[n2], (double)dArray[n2], (double)0.5);
            ++n2;
        }
    }
}

