/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.IAnalysisMonitor;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.fitting.functions.APeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.CompositeFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IdentifiedPeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Offset;
import uk.ac.diamond.scisoft.analysis.optimize.GeneticAlg;
import uk.ac.diamond.scisoft.analysis.optimize.IOptimizer;

public class Generic1DFitter
implements Serializable {
    public static int defaultSmoothing = 3;
    public static double defaultAccuracy = 1.0E-4;
    public static IOptimizer defaultOptimiser = new GeneticAlg(defaultAccuracy);
    private static double epslion = 1.0E-5;
    protected static final transient Logger logger = LoggerFactory.getLogger(Generic1DFitter.class);

    public static List<APeak> fitPeaks(AbstractDataset abstractDataset, APeak aPeak, int n) {
        DoubleDataset doubleDataset = DoubleDataset.arange(abstractDataset.getSize());
        return Generic1DFitter.fitPeaks(doubleDataset, abstractDataset, aPeak, n);
    }

    public static List<APeak> fitPeaks(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, APeak aPeak, int n) {
        int n2 = (int)((double)abstractDataset.getSize() * 0.01);
        int n3 = n2 > defaultSmoothing ? n2 : defaultSmoothing;
        return Generic1DFitter.fitPeaks(abstractDataset, abstractDataset2, aPeak, defaultOptimiser, n3, n);
    }

    public static List<APeak> fitPeaks(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, APeak aPeak, IOptimizer iOptimizer, int n, int n2) {
        return Generic1DFitter.fitPeaks(abstractDataset, abstractDataset2, aPeak, iOptimizer, n, n2, 0.0, false, false);
    }

    public static List<APeak> fitPeaks(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, APeak aPeak, IOptimizer iOptimizer, int n, int n2, double d, boolean bl, boolean bl2) {
        return Generic1DFitter.fitPeaks(abstractDataset, abstractDataset2, aPeak, iOptimizer, n, n2, d, bl, bl2, new IAnalysisMonitor(){

            @Override
            public boolean hasBeenCancelled() {
                return false;
            }
        });
    }

    public static List<APeak> fitPeaks(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, APeak aPeak, IOptimizer iOptimizer, int n, int n2, double d, boolean bl, boolean bl2, IAnalysisMonitor iAnalysisMonitor) {
        List<IdentifiedPeak> list = Generic1DFitter.parseDataDerivative(abstractDataset, abstractDataset2, n);
        if (list == null || list.size() <= 0) {
            logger.error("No peaks found");
            return null;
        }
        List<APeak> list2 = Generic1DFitter.fitFunction(list, aPeak, abstractDataset, abstractDataset2, iOptimizer, n2, d, bl, bl2, iAnalysisMonitor);
        return list2;
    }

    public static List<IdentifiedPeak> findPeaks(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int n) {
        return Generic1DFitter.parseDataDerivative(abstractDataset, abstractDataset2, n);
    }

    private static List<APeak> fitFunction(List<IdentifiedPeak> list, APeak aPeak, AbstractDataset abstractDataset, AbstractDataset abstractDataset2, IOptimizer iOptimizer, int n, double d, boolean bl, boolean bl2, IAnalysisMonitor iAnalysisMonitor) {
        ArrayList<APeak> arrayList;
        block17: {
            arrayList = new ArrayList<APeak>();
            if (n == 0) {
                n = list.size();
            }
            if (n <= -1) {
                n = abstractDataset.getSize();
            }
            int n2 = 0;
            for (IdentifiedPeak identifiedPeak : list) {
                if (n2++ >= n) break;
                if (iAnalysisMonitor.hasBeenCancelled()) {
                    return arrayList;
                }
                int[] nArray = new int[]{identifiedPeak.getIndexOfDatasetAtMinPos()};
                int[] nArray2 = new int[]{identifiedPeak.getIndexOfDatasetAtMaxPos() + 1};
                int[] nArray3 = new int[]{1};
                AbstractDataset abstractDataset3 = abstractDataset2.getSlice(nArray, nArray2, nArray3);
                AbstractDataset abstractDataset4 = abstractDataset.getSlice(nArray, nArray2, nArray3);
                double d2 = abstractDataset3.min().doubleValue();
                double d3 = (Double)abstractDataset3.mean();
                Offset offset = new Offset(d2, d3);
                try {
                    Constructor<?> constructor = aPeak.getClass().getConstructor(IdentifiedPeak.class);
                    APeak aPeak2 = (APeak)constructor.newInstance(identifiedPeak);
                    CompositeFunction compositeFunction = new CompositeFunction();
                    compositeFunction.addFunction(aPeak2);
                    compositeFunction.addFunction(offset);
                    iOptimizer.optimize(new AbstractDataset[]{abstractDataset4}, abstractDataset3, compositeFunction);
                    arrayList.add(aPeak2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.error("There was a problem optimising the peak", (Throwable)illegalArgumentException);
                }
                catch (InstantiationException instantiationException) {
                    logger.error("The function could not be created for fitting", (Throwable)instantiationException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    logger.error("The peak function could not be created.", (Throwable)noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    logger.error("The function could not be created for fitting", (Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.error("The function could not be created for fitting", (Throwable)invocationTargetException);
                }
                catch (Exception exception) {
                    logger.error("There was a problem creating the optimizer.", (Throwable)exception);
                }
            }
            if (!bl) break block17;
            if (bl2) {
                Collections.sort(arrayList, new Comparator<APeak>(){

                    @Override
                    public int compare(APeak aPeak, APeak aPeak2) {
                        return (int)Math.signum(aPeak.getHeight() - aPeak2.getHeight());
                    }
                });
                int n3 = 1;
                while (n3 < arrayList.size()) {
                    if (arrayList.get(n3).getHeight() < arrayList.get(0).getHeight() * d) {
                        return arrayList.subList(0, n3);
                    }
                    ++n3;
                }
            } else {
                Collections.sort(arrayList, new Comparator<APeak>(){

                    @Override
                    public int compare(APeak aPeak, APeak aPeak2) {
                        return (int)Math.signum(aPeak.getArea() - aPeak2.getArea());
                    }
                });
                int n4 = 1;
                while (n4 < arrayList.size()) {
                    if (arrayList.get(n4).getArea() < arrayList.get(0).getArea() * d) {
                        return arrayList.subList(0, n4);
                    }
                    ++n4;
                }
            }
        }
        return arrayList;
    }

    private static List<IdentifiedPeak> parseDataDerivative(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int n) {
        boolean bl = false;
        ArrayList<IdentifiedPeak> arrayList = new ArrayList<IdentifiedPeak>();
        AbstractDataset abstractDataset3 = Maths.derivative(abstractDataset, abstractDataset2, n + 1);
        int n2 = 0;
        while (n2 < abstractDataset3.getSize() - 1) {
            if (abstractDataset3.getElementDoubleAbs(n2) >= 0.0 && abstractDataset3.getElementDoubleAbs(n2 + 1) < 0.0) {
                int n3 = n2;
                double d = 0.0;
                while (n3 > 0) {
                    if (!(abstractDataset3.getElementDoubleAbs(n3) >= 0.0)) break;
                    d += abstractDataset3.getElementDoubleAbs(n3);
                    --n3;
                }
                int n4 = n2 + 1;
                double d2 = 0.0;
                while (n4 < abstractDataset3.getSize() - 1) {
                    if (!(abstractDataset3.getElementDoubleAbs(n4) <= 0.0)) break;
                    d2 -= abstractDataset3.getElementDoubleAbs(n4);
                    ++n4;
                }
                if (Math.min(d, d2) > epslion) {
                    AbstractDataset abstractDataset4;
                    int[] nArray = new int[]{n3};
                    int[] nArray2 = new int[]{n4};
                    int[] nArray3 = new int[]{1};
                    AbstractDataset abstractDataset5 = abstractDataset.getSlice(nArray, nArray2, nArray3);
                    List<Double> list = DatasetUtils.crossings(abstractDataset5, abstractDataset4 = abstractDataset2.getSlice(nArray, nArray2, nArray3), abstractDataset4.max().doubleValue() / 2.0);
                    if (list.size() <= 1) {
                        list.clear();
                        list.add(Double.valueOf(n3));
                        list.add(Double.valueOf(n4));
                    }
                    IdentifiedPeak identifiedPeak = new IdentifiedPeak(abstractDataset.getElementDoubleAbs(n2), abstractDataset.getElementDoubleAbs(n3), abstractDataset.getElementDoubleAbs(n4), Math.min(d, d2), abstractDataset4.max().doubleValue() - abstractDataset4.min().doubleValue(), n3, n4, list);
                    if (bl) {
                        System.out.println("Back Position = " + abstractDataset.getElementDoubleAbs(n3) + " Peak Pos = " + abstractDataset.getElementDoubleAbs(n2) + " Forward Position = " + abstractDataset.getElementDoubleAbs(n4) + ". Y value at back pos = " + abstractDataset2.getElementDoubleAbs(n3) + " Y value at forward pos = " + abstractDataset2.getElementDoubleAbs(n4) + " height " + abstractDataset4.max() + " Area " + Math.min(d, d2) + " sum of area variables " + (d + d2));
                    }
                    arrayList.add(identifiedPeak);
                }
            }
            ++n2;
        }
        Collections.sort(arrayList, new Compare());
        if (bl && arrayList.size() <= 0) {
            System.err.println("No Peaks Found!!");
        }
        return arrayList;
    }

    private static class Compare
    implements Comparator<IdentifiedPeak> {
        private Compare() {
        }

        @Override
        public int compare(IdentifiedPeak identifiedPeak, IdentifiedPeak identifiedPeak2) {
            if (identifiedPeak.getArea() < identifiedPeak2.getArea()) {
                return 1;
            }
            if (identifiedPeak.getArea() > identifiedPeak2.getArea()) {
                return -1;
            }
            return 0;
        }
    }
}

