/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting;

import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.CompositeFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Gaussian;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Lorentzian;
import uk.ac.diamond.scisoft.analysis.fitting.functions.PearsonVII;
import uk.ac.diamond.scisoft.analysis.fitting.functions.PseudoVoigt;

public class Generic1DDatasetCreater {
    static final int dataRange = 100;
    static final double peakPos = 50.0;
    static final double defaultFWHM = 20.0;
    static final double defaultArea = 50.0;
    static final double delta = 0.5;
    static final double lambda = 0.1;
    static final boolean backgroundDominated = true;
    static final boolean autoStopping = true;
    static final double threshold = 0.1;
    static final int numPeaks = -1;
    static final int smoothing = 5;
    static final double accuracy = 1.0E-4;
    static final DoubleDataset xAxis = (DoubleDataset)AbstractDataset.arange(0.0, 100.0, 1.0, 6);

    public static DoubleDataset createGaussianDataset() {
        CompositeFunction compositeFunction = new CompositeFunction();
        compositeFunction.addFunction(new Gaussian(50.0, 50.0, 20.0, 50.0));
        return compositeFunction.makeDataset(xAxis);
    }

    public static DoubleDataset createPearsonVII() {
        CompositeFunction compositeFunction = new CompositeFunction();
        compositeFunction.addFunction(new PearsonVII(50.0, 50.0, 20.0, 50.0));
        return compositeFunction.makeDataset(xAxis);
    }

    public static DoubleDataset createLorentzianDataset() {
        CompositeFunction compositeFunction = new CompositeFunction();
        compositeFunction.addFunction(new Lorentzian(50.0, 50.0, 20.0, 50.0));
        return compositeFunction.makeDataset(xAxis);
    }

    public static DoubleDataset createPseudoVoigt() {
        CompositeFunction compositeFunction = new CompositeFunction();
        compositeFunction.addFunction(new PseudoVoigt(50.0, 50.0, 20.0, 50.0));
        return compositeFunction.makeDataset(xAxis);
    }
}

