/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.DifferentiableMultivariateVectorialFunction;
import org.apache.commons.math.analysis.MultivariateMatrixFunction;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.optimization.general.LevenbergMarquardtOptimizer;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;

public class Gaussian {
    private DoubleDataset dataset;
    private double[] weights;
    private double[] startPoint;

    public void setDataset(DoubleDataset doubleDataset) {
        this.dataset = doubleDataset;
    }

    public DoubleDataset getDataset() {
        return this.dataset;
    }

    public void optimise() {
        LevenbergMarquardtOptimizer levenbergMarquardtOptimizer = new LevenbergMarquardtOptimizer();
        ObjectiveFunction objectiveFunction = new ObjectiveFunction(2);
        try {
            levenbergMarquardtOptimizer.optimize((DifferentiableMultivariateVectorialFunction)objectiveFunction, this.dataset.getData(), this.weights, this.startPoint);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class ObjectiveFunction
    implements DifferentiableMultivariateVectorialFunction {
        int rank;

        public ObjectiveFunction(int n) {
            this.rank = n;
        }

        public double[] value(double[] dArray) throws FunctionEvaluationException, IllegalArgumentException {
            Array2DRowRealMatrix array2DRowRealMatrix = (Array2DRowRealMatrix)MatrixUtils.createRealMatrix((int)this.rank, (int)this.rank);
            int n = this.rank;
            double d = dArray[n];
            ++n;
            int n2 = 0;
            while (n2 < this.rank) {
                array2DRowRealMatrix.setEntry(n2, n2, dArray[n]);
                ++n;
                ++n2;
            }
            n2 = 0;
            while (n2 < this.rank) {
                double d2 = Math.sqrt(array2DRowRealMatrix.getEntry(n2, n2));
                int n3 = n2 + 1;
                while (n3 < this.rank) {
                    double d3 = Math.sqrt(array2DRowRealMatrix.getEntry(n3, n3)) * d2;
                    double d4 = d3 * dArray[n];
                    array2DRowRealMatrix.setEntry(n2, n3, d4);
                    array2DRowRealMatrix.setEntry(n3, n2, d4);
                    ++n;
                    ++n3;
                }
                ++n2;
            }
            LUDecompositionImpl lUDecompositionImpl = null;
            try {
                lUDecompositionImpl = new LUDecompositionImpl((RealMatrix)array2DRowRealMatrix);
            }
            catch (NonSquareMatrixException nonSquareMatrixException) {
                throw new IllegalArgumentException("Non-square covariance matrix");
            }
            Array2DRowRealMatrix array2DRowRealMatrix2 = (Array2DRowRealMatrix)lUDecompositionImpl.getSolver().getInverse();
            double d5 = 0.0;
            double[] dArray2 = null;
            return new double[]{d5 += ObjectiveFunction.gaussian(dArray2, dArray, d /= Math.sqrt(Math.pow(Math.PI * 2, this.rank) * lUDecompositionImpl.getDeterminant()), array2DRowRealMatrix2)};
        }

        private static double gaussian(double[] dArray, double[] dArray2, double d, Array2DRowRealMatrix array2DRowRealMatrix) {
            double[] dArray3 = (double[])dArray.clone();
            int n = 0;
            while (n < dArray3.length) {
                int n2 = n;
                dArray3[n2] = dArray3[n2] - dArray2[n];
                ++n;
            }
            double[] dArray4 = array2DRowRealMatrix.operate(dArray3);
            double d2 = 0.0;
            int n3 = 0;
            while (n3 < dArray3.length) {
                d2 += dArray4[n3] * dArray3[n3];
                ++n3;
            }
            double d3 = Math.exp(-0.5 * d2);
            return d * d3;
        }

        public MultivariateMatrixFunction jacobian() {
            return null;
        }
    }
}

