/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting;

import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.AFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.CompositeFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Polynomial;
import uk.ac.diamond.scisoft.analysis.optimize.ApacheConjugateGradient;
import uk.ac.diamond.scisoft.analysis.optimize.ApacheMultiDirectional;
import uk.ac.diamond.scisoft.analysis.optimize.ApacheNelderMead;
import uk.ac.diamond.scisoft.analysis.optimize.GeneticAlg;
import uk.ac.diamond.scisoft.analysis.optimize.GradientDescent;
import uk.ac.diamond.scisoft.analysis.optimize.IOptimizer;
import uk.ac.diamond.scisoft.analysis.optimize.LeastSquares;
import uk.ac.diamond.scisoft.analysis.optimize.LinearLeastSquares;
import uk.ac.diamond.scisoft.analysis.optimize.NelderMead;

public class Fitter {
    private static final double simplexQuality = 1.0E-6;
    public static double quality = 1.0E-4;
    public static Long seed = null;

    public static void simplexFit(AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) throws Exception {
        Fitter.simplexFit(1.0E-6, abstractDatasetArray, abstractDataset, iFunction);
    }

    public static void simplexFit(double d, AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) throws Exception {
        NelderMead nelderMead = new NelderMead(d);
        nelderMead.optimize(abstractDatasetArray, abstractDataset, iFunction);
    }

    public static void ApacheNelderMeadFit(AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) throws Exception {
        ApacheNelderMead apacheNelderMead = new ApacheNelderMead();
        apacheNelderMead.optimize(abstractDatasetArray, abstractDataset, iFunction);
    }

    public static void ApacheMultiDirectionFit(AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) throws Exception {
        ApacheMultiDirectional apacheMultiDirectional = new ApacheMultiDirectional();
        apacheMultiDirectional.optimize(abstractDatasetArray, abstractDataset, iFunction);
    }

    public static void ApacheConjugateGradientFit(AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) throws Exception {
        ApacheConjugateGradient apacheConjugateGradient = new ApacheConjugateGradient();
        apacheConjugateGradient.optimize(abstractDatasetArray, abstractDataset, iFunction);
    }

    public static void GDFit(AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) throws Exception {
        Fitter.GDFit(quality, abstractDatasetArray, abstractDataset, iFunction);
    }

    public static void GDFit(double d, AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) throws Exception {
        GradientDescent gradientDescent = new GradientDescent(d);
        gradientDescent.optimize(abstractDatasetArray, abstractDataset, iFunction);
    }

    public static void geneticFit(AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) {
        Fitter.geneticFit(quality, abstractDatasetArray, abstractDataset, iFunction);
    }

    public static void geneticFit(double d, AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) {
        GeneticAlg geneticAlg = seed == null ? new GeneticAlg(d) : new GeneticAlg(d, seed);
        geneticAlg.optimize(abstractDatasetArray, abstractDataset, iFunction);
    }

    public static void llsqFit(AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, IFunction iFunction) {
        LeastSquares leastSquares = new LeastSquares(0.0);
        leastSquares.optimize(abstractDatasetArray, abstractDataset, iFunction);
    }

    public static Polynomial polyFit(AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, double d, int n) {
        Polynomial polynomial = new Polynomial(n);
        Fitter.polyFit(abstractDatasetArray, abstractDataset, d, polynomial);
        return polynomial;
    }

    public static void polyFit(AbstractDataset[] abstractDatasetArray, AbstractDataset abstractDataset, double d, Polynomial polynomial) {
        LinearLeastSquares linearLeastSquares = new LinearLeastSquares(d);
        DoubleDataset doubleDataset = polynomial.makeMatrix(abstractDatasetArray[0]);
        double[] dArray = linearLeastSquares.solve(doubleDataset, abstractDataset, AbstractDataset.ones(abstractDataset));
        polynomial.setParameterValues(dArray);
    }

    public static CompositeFunction fit(IDataset iDataset, IDataset iDataset2, IOptimizer iOptimizer, AFunction ... aFunctionArray) throws Exception {
        CompositeFunction compositeFunction = new CompositeFunction();
        IDataset[] iDatasetArray = new IDataset[]{iDataset};
        int n = 0;
        while (n < aFunctionArray.length) {
            compositeFunction.addFunction(aFunctionArray[n]);
            ++n;
        }
        iOptimizer.optimize(iDatasetArray, iDataset2, compositeFunction);
        return compositeFunction;
    }
}

