/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting;

import java.util.Arrays;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.BrentSolver;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.Random;
import uk.ac.diamond.scisoft.analysis.fitting.AngleDerivativeFunction;
import uk.ac.diamond.scisoft.analysis.fitting.EllipseFitter;

public class EllipseFitterTest {
    @Test
    public void testOrthoDist() {
        AngleDerivativeFunction angleDerivativeFunction = new AngleDerivativeFunction();
        BrentSolver brentSolver = new BrentSolver(1.0E-6);
        double d = 10.2;
        double d2 = 3.1;
        double d3 = 0.17453292519943295;
        angleDerivativeFunction.setRadii(d, d2);
        angleDerivativeFunction.setAngle(d3);
        angleDerivativeFunction.setCoordinate(-5.0, 5.5);
        try {
            double d4 = Math.atan2(5.5, -5.0);
            if (d4 < 0.0) {
                d4 += Math.PI * 2;
            }
            d4 -= d3;
            double d5 = Math.ceil(d4 /= 1.5707963267948966) * 1.5707963267948966;
            double d6 = brentSolver.solve(100, (UnivariateRealFunction)angleDerivativeFunction, d5 - 1.5707963267948966, d5);
            Assert.assertEquals((String)"Angle found is not close enough", (double)1.93, (double)d6, (double)0.001);
        }
        catch (MaxIterationsExceededException maxIterationsExceededException) {
            System.err.println((Object)maxIterationsExceededException);
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            System.err.println((Object)functionEvaluationException);
        }
    }

    @Test
    public void testQuickEllipse() {
        double[] dArray = new double[]{344.2, 243.2, 0.7225663103256524, 0.2, -12.3};
        Random.seed(1277);
        DoubleDataset doubleDataset = Random.rand(0.0, Math.PI * 2, 10);
        AbstractDataset[] abstractDatasetArray = EllipseFitter.generateCoordinates(doubleDataset, dArray);
        AbstractDataset abstractDataset = Maths.add(abstractDatasetArray[0], Random.randn(0.0, 10.2, doubleDataset.getShape()));
        AbstractDataset abstractDataset2 = Maths.add(abstractDatasetArray[1], Random.randn(0.0, 10.2, doubleDataset.getShape()));
        System.err.println(abstractDataset);
        System.err.println(abstractDataset2);
        EllipseFitter ellipseFitter = new EllipseFitter();
        ellipseFitter.algebraicFit(abstractDataset, abstractDataset2);
        double[] dArray2 = ellipseFitter.getParameters();
        double[] dArray3 = new double[]{0.08, 0.05, 0.1, 6.0, -0.2};
        int n = 0;
        while (n < dArray.length) {
            Assert.assertEquals((String)("Algebraic fit: " + n), (double)dArray[n], (double)dArray2[n], (double)(dArray[n] * dArray3[n]));
            ++n;
        }
        System.err.println(Arrays.toString(dArray));
        System.err.println(Arrays.toString(dArray2));
        ellipseFitter.geometricFit(abstractDataset, abstractDataset2, dArray2);
        dArray2 = ellipseFitter.getParameters();
        System.err.println(Arrays.toString(dArray2));
        n = 0;
        while (n < dArray.length) {
            Assert.assertEquals((String)("Geometric fit: " + n), (double)dArray[n], (double)dArray2[n], (double)(dArray[n] * dArray3[n]));
            ++n;
        }
    }
}

