/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting;

import Jama.Matrix;
import java.util.Arrays;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.DifferentiableMultivariateVectorialFunction;
import org.apache.commons.math.analysis.MultivariateMatrixFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.BrentSolver;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.optimization.general.LevenbergMarquardtOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.LinearAlgebra;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.fitting.AngleDerivativeFunction;

public class EllipseFitter {
    private static final transient Logger logger = LoggerFactory.getLogger(EllipseFitter.class);
    AngleDerivativeFunction angleDerivative = new AngleDerivativeFunction();
    BrentSolver solver = new BrentSolver(1.0E-6);
    private double[] parameters = new double[5];
    private static final int PARAMETERS = 5;

    public double[] getParameters() {
        return this.parameters;
    }

    public UnivariateRealFunction getAngleDerivative() {
        return this.angleDerivative;
    }

    public void geometricFit(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, double[] dArray) {
        if (abstractDataset.getSize() < 5 || abstractDataset2.getSize() < 5) {
            throw new IllegalArgumentException("Need 5 or more points");
        }
        if (dArray == null) {
            dArray = EllipseFitter.quickfit(abstractDataset, abstractDataset2);
        } else if (dArray.length < 5) {
            throw new IllegalArgumentException("Need 5 parameters");
        }
        EllipseCoordinatesFunction ellipseCoordinatesFunction = new EllipseCoordinatesFunction(abstractDataset, abstractDataset2);
        LevenbergMarquardtOptimizer levenbergMarquardtOptimizer = new LevenbergMarquardtOptimizer();
        try {
            VectorialPointValuePair vectorialPointValuePair = levenbergMarquardtOptimizer.optimize((DifferentiableMultivariateVectorialFunction)ellipseCoordinatesFunction, ellipseCoordinatesFunction.getTarget(), ellipseCoordinatesFunction.getWeight(), ellipseCoordinatesFunction.calcAllInitValues(dArray));
            double[] dArray2 = vectorialPointValuePair.getPointRef();
            this.parameters[0] = dArray2[0] * dArray2[0];
            this.parameters[1] = dArray2[1] * dArray2[1];
            int n = 2;
            while (n < 5) {
                this.parameters[n] = dArray2[n];
                ++n;
            }
            logger.info("Ellipse fit: rms = {}, x^2 = {}", (Object)levenbergMarquardtOptimizer.getRMS(), (Object)levenbergMarquardtOptimizer.getChiSquare());
        }
        catch (FunctionEvaluationException functionEvaluationException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ConvergenceException convergenceException) {
            throw new IllegalArgumentException("Problem with optimizer converging");
        }
    }

    public void algebraicFit(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        if (abstractDataset.getSize() < 5 || abstractDataset2.getSize() < 5) {
            throw new IllegalArgumentException("Need 5 or more points");
        }
        double[] dArray = EllipseFitter.quickfit(abstractDataset, abstractDataset2);
        int n = 0;
        while (n < 5) {
            this.parameters[n] = dArray[n];
            ++n;
        }
    }

    private static double[] quickfit(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        AbstractDataset abstractDataset3 = Maths.square(abstractDataset);
        AbstractDataset abstractDataset4 = Maths.square(abstractDataset2);
        AbstractDataset abstractDataset5 = Maths.multiply(abstractDataset3, abstractDataset);
        AbstractDataset abstractDataset6 = Maths.multiply(abstractDataset4, abstractDataset2);
        AbstractDataset abstractDataset7 = Maths.multiply(abstractDataset, abstractDataset2);
        Matrix matrix = new Matrix(3, 3);
        matrix.set(0, 0, LinearAlgebra.dotProduct(abstractDataset3, abstractDataset3).getDouble(new int[0]));
        matrix.set(0, 1, LinearAlgebra.dotProduct(abstractDataset5, abstractDataset2).getDouble(new int[0]));
        matrix.set(0, 2, LinearAlgebra.dotProduct(abstractDataset3, abstractDataset4).getDouble(new int[0]));
        matrix.set(1, 0, matrix.get(0, 1));
        matrix.set(1, 1, matrix.get(0, 2));
        matrix.set(1, 2, LinearAlgebra.dotProduct(abstractDataset, abstractDataset6).getDouble(new int[0]));
        matrix.set(2, 0, matrix.get(0, 2));
        matrix.set(2, 1, matrix.get(1, 2));
        matrix.set(2, 2, LinearAlgebra.dotProduct(abstractDataset4, abstractDataset4).getDouble(new int[0]));
        Matrix matrix2 = new Matrix(3, 3);
        matrix2.set(0, 0, ((Number)abstractDataset5.sum()).doubleValue());
        matrix2.set(0, 1, LinearAlgebra.dotProduct(abstractDataset3, abstractDataset2).getDouble(new int[0]));
        matrix2.set(0, 2, ((Number)abstractDataset3.sum()).doubleValue());
        matrix2.set(1, 0, matrix2.get(0, 1));
        matrix2.set(1, 1, LinearAlgebra.dotProduct(abstractDataset, abstractDataset4).getDouble(new int[0]));
        matrix2.set(1, 2, ((Number)abstractDataset7.sum()).doubleValue());
        matrix2.set(2, 0, matrix2.get(1, 1));
        matrix2.set(2, 1, ((Number)abstractDataset6.sum()).doubleValue());
        matrix2.set(2, 2, ((Number)abstractDataset4.sum()).doubleValue());
        Matrix matrix3 = new Matrix(3, 3);
        matrix3.set(0, 0, matrix2.get(0, 2));
        matrix3.set(0, 1, matrix2.get(1, 2));
        matrix3.set(0, 2, ((Number)abstractDataset.sum()).doubleValue());
        matrix3.set(1, 0, matrix3.get(0, 1));
        matrix3.set(1, 1, matrix2.get(2, 2));
        matrix3.set(1, 2, ((Number)abstractDataset2.sum()).doubleValue());
        matrix3.set(2, 0, matrix3.get(0, 2));
        matrix3.set(2, 1, matrix3.get(1, 2));
        matrix3.set(2, 2, (double)abstractDataset.getSize());
        Matrix matrix4 = matrix3.solve(matrix2.transpose()).uminus();
        Matrix matrix5 = matrix.plus(matrix2.times(matrix4));
        Matrix matrix6 = new Matrix(new double[]{0.0, 0.0, 0.5, 0.0, -1.0, 0.0, 0.5, 0.0, 0.0}, 3);
        Matrix matrix7 = matrix6.times(matrix5);
        Matrix matrix8 = matrix7.eig().getV();
        double[][] dArray = matrix8.getArray();
        ArrayRealVector arrayRealVector = new ArrayRealVector(dArray[0]);
        ArrayRealVector arrayRealVector2 = new ArrayRealVector(dArray[1]);
        ArrayRealVector arrayRealVector3 = new ArrayRealVector(dArray[2]);
        arrayRealVector.mapMultiplyToSelf(4.0);
        ArrayRealVector arrayRealVector4 = arrayRealVector.ebeMultiply(arrayRealVector3).subtract(arrayRealVector2.ebeMultiply(arrayRealVector2));
        double[] dArray2 = arrayRealVector4.getData();
        int n = 0;
        while (n < 3) {
            if (dArray2[n] > 0.0) break;
            ++n;
        }
        if (n == 3) {
            throw new IllegalArgumentException("Could not find solution that satifies constraint");
        }
        arrayRealVector4 = new ArrayRealVector(new double[]{dArray[0][n], dArray[1][n], dArray[2][n]});
        dArray2 = arrayRealVector4.getDataRef();
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(matrix4.getArray(), false);
        dArray2 = array2DRowRealMatrix.operate(dArray2);
        double d4 = dArray2[0];
        double d5 = dArray2[1];
        double d6 = dArray2[2];
        double d7 = d2 * d2 - 4.0 * d * d3;
        if (d7 >= 0.0) {
            throw new IllegalArgumentException("Solution is not an ellipse");
        }
        if (d2 == 0.0) {
            throw new IllegalArgumentException("Solution is a circle");
        }
        double[] dArray3 = new double[5];
        dArray3[3] = (2.0 * d3 * d4 - d2 * d5) / d7;
        dArray3[4] = (2.0 * d * d5 - d2 * d4) / d7;
        double d8 = Math.sqrt((d - d3) * (d - d3) + d2 * d2);
        dArray3[0] = -2.0 * (d * d5 * d5 + d3 * d4 * d4 + d6 * d2 * d2 - d2 * d4 * d5 - 4.0 * d * d3 * d6) / d7;
        dArray3[1] = dArray3[0] / (d + d3 + d8);
        dArray3[0] = dArray3[0] / (d + d3 - d8);
        dArray3[0] = Math.sqrt(dArray3[0]);
        dArray3[1] = Math.sqrt(dArray3[1]);
        dArray3[2] = d2 == 0.0 ? 0.0 : 0.5 * Math.atan2(d2, d - d3);
        if (dArray3[0] < dArray3[1]) {
            double d9 = dArray3[0];
            dArray3[0] = dArray3[1];
            dArray3[1] = d9;
        } else {
            dArray3[2] = dArray3[2] + 1.5707963267948966;
        }
        return dArray3;
    }

    public static AbstractDataset[] generateCoordinates(AbstractDataset abstractDataset, double[] dArray) {
        if (dArray.length != 5) {
            throw new IllegalArgumentException("Need 5 parameters");
        }
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
        DoubleDataset doubleDataset = new DoubleDataset(abstractDataset.getShape());
        DoubleDataset doubleDataset2 = new DoubleDataset(abstractDataset.getShape());
        abstractDatasetArray[0] = doubleDataset;
        abstractDatasetArray[1] = doubleDataset2;
        double d = Math.cos(dArray[2]);
        double d2 = Math.sin(dArray[2]);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d3 = abstractDataset.getElementDoubleAbs(indexIterator.index);
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            doubleDataset.setAbs(n, dArray[3] + dArray[0] * d * d4 - dArray[1] * d2 * d5);
            doubleDataset2.setAbs(n, dArray[4] + dArray[0] * d2 * d4 + dArray[1] * d * d5);
            ++n;
        }
        return abstractDatasetArray;
    }

    class EllipseCoordinatesFunction
    implements DifferentiableMultivariateVectorialFunction {
        private AbstractDataset X;
        private AbstractDataset Y;
        private DoubleDataset v;
        private double[][] j;
        private int n;
        private int m;
        private double[] ca;
        private double[] sa;

        public EllipseCoordinatesFunction(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
            this.setPoints(abstractDataset, abstractDataset2);
        }

        public void setPoints(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
            this.X = abstractDataset;
            this.Y = abstractDataset2;
            this.n = this.X.getSize();
            this.m = 2 * this.n;
            this.v = new DoubleDataset(this.m);
            this.j = new double[this.m][5 + this.n];
            int n = 0;
            while (n < this.m) {
                this.j[n][3] = 1.0;
                this.j[++n][4] = 1.0;
                ++n;
            }
            this.ca = new double[this.n];
            this.sa = new double[this.n];
        }

        public double[] getTarget() {
            double[] dArray = new double[this.m];
            IndexIterator indexIterator = this.X.getIterator();
            IndexIterator indexIterator2 = this.Y.getIterator();
            int n = 0;
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                dArray[n++] = this.X.getElementDoubleAbs(indexIterator.index);
                dArray[n++] = this.Y.getElementDoubleAbs(indexIterator2.index);
            }
            return dArray;
        }

        public double[] getWeight() {
            double[] dArray = new double[this.m];
            Arrays.fill(dArray, 1.0);
            return dArray;
        }

        public double[] calcAllInitValues(double[] dArray) {
            double[] dArray2 = new double[this.n + 5];
            int n = 0;
            while (n < dArray.length) {
                dArray2[n] = dArray[n];
                ++n;
            }
            double d = Math.sqrt(dArray[0]);
            double d2 = Math.sqrt(dArray[1]);
            double d3 = dArray[2];
            double d4 = dArray[3];
            double d5 = dArray[4];
            EllipseFitter.this.angleDerivative.setRadii(d, d2);
            EllipseFitter.this.angleDerivative.setAngle(d3);
            IndexIterator indexIterator = this.X.getIterator();
            IndexIterator indexIterator2 = this.Y.getIterator();
            int n2 = 5;
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d6 = this.X.getElementDoubleAbs(indexIterator.index) - d4;
                double d7 = this.Y.getElementDoubleAbs(indexIterator2.index) - d5;
                EllipseFitter.this.angleDerivative.setCoordinate(d6, d7);
                try {
                    double d8 = Math.atan2(d7, d6);
                    if (d8 < 0.0) {
                        d8 += Math.PI * 2;
                    }
                    d8 -= d3;
                    double d9 = Math.ceil(d8 /= 1.5707963267948966) * 1.5707963267948966;
                    double d10 = EllipseFitter.this.solver.solve(100, (UnivariateRealFunction)EllipseFitter.this.angleDerivative, d9 - 1.5707963267948966, d9);
                    dArray2[n2++] = d10;
                }
                catch (MaxIterationsExceededException maxIterationsExceededException) {
                    throw new IllegalArgumentException("Problem with solver converging as iterations exceed limit");
                }
                catch (FunctionEvaluationException functionEvaluationException) {}
            }
            return dArray2;
        }

        public double[] value(double[] dArray) throws FunctionEvaluationException, IllegalArgumentException {
            double[] dArray2 = this.v.getData();
            double d = dArray[0] * dArray[0];
            double d2 = dArray[1] * dArray[1];
            double d3 = Math.cos(dArray[2]);
            double d4 = Math.sin(dArray[2]);
            double d5 = dArray[3];
            double d6 = dArray[4];
            int n = 0;
            while (n < this.n) {
                double d7 = dArray[n + 5];
                double d8 = Math.cos(d7);
                double d9 = Math.sin(d7);
                this.ca[n] = d8;
                this.sa[n] = d9;
                dArray2[2 * n] = d5 + d * d3 * d8 - d2 * d4 * d9;
                dArray2[2 * n + 1] = d6 + d * d4 * d8 + d2 * d3 * d9;
                ++n;
            }
            return dArray2;
        }

        private void calculateJacobian(double[] dArray) {
            double d = 2.0 * dArray[0];
            double d2 = dArray[0] * dArray[0];
            double d3 = 2.0 * dArray[1];
            double d4 = dArray[1] * dArray[1];
            double d5 = Math.cos(dArray[2]);
            double d6 = Math.sin(dArray[2]);
            int n = 0;
            while (n < this.n) {
                double d7 = this.ca[n];
                double d8 = this.sa[n];
                double d9 = d5 * d7;
                double d10 = d5 * d8;
                double d11 = d6 * d7;
                double d12 = d6 * d8;
                int n2 = 2 * n;
                int n3 = 2 * n + 1;
                this.j[n2][0] = d * d9;
                this.j[n2][1] = -d3 * d12;
                this.j[n2][2] = -d2 * d11 - d4 * d10;
                this.j[n2][5 + n] = -d2 * d10 - d4 * d11;
                this.j[n3][0] = d * d11;
                this.j[n3][1] = d3 * d10;
                this.j[n3][2] = d2 * d9 - d4 * d12;
                this.j[n3][5 + n] = -d2 * d12 + d4 * d9;
                ++n;
            }
        }

        public MultivariateMatrixFunction jacobian() {
            return new MultivariateMatrixFunction(){

                public double[][] value(double[] dArray) throws FunctionEvaluationException, IllegalArgumentException {
                    EllipseCoordinatesFunction.this.calculateJacobian(dArray);
                    return EllipseCoordinatesFunction.this.j;
                }
            };
        }
    }
}

