/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting;

import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.fitting.Generic1DDatasetCreater;
import uk.ac.diamond.scisoft.analysis.fitting.Generic1DFitter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.APeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Gaussian;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Lorentzian;
import uk.ac.diamond.scisoft.analysis.fitting.functions.PearsonVII;
import uk.ac.diamond.scisoft.analysis.optimize.ApacheConjugateGradient;

@Ignore(value="Test not finished and is failing. 9 Nov 11")
public class ApacheConjugateGradientFittingTest {
    static DoubleDataset gaussian;
    static DoubleDataset lorentzian;
    static DoubleDataset pearsonVII;
    static DoubleDataset pseudoVoigt;
    static DoubleDataset xAxis;
    static double accuracy;
    static int smoothing;
    static int numPeaks;
    static double pos;
    static double fwhm;
    static double area;
    static double delta;
    private static List<APeak> fittedGaussian;
    private static List<APeak> fittedLorenzian;
    private static List<APeak> fittedPearsonVII;
    private static List<APeak> fittedPseudoVoigt;

    static {
        delta = 0.1;
    }

    public static void doFitting() {
        fittedGaussian = Generic1DFitter.fitPeaks(xAxis, gaussian, new Gaussian(1.0, 1.0, 1.0, 1.0), new ApacheConjugateGradient(), smoothing, numPeaks);
        fittedLorenzian = Generic1DFitter.fitPeaks(xAxis, lorentzian, new Lorentzian(1.0, 1.0, 1.0, 1.0), new ApacheConjugateGradient(), smoothing, numPeaks);
        fittedPearsonVII = Generic1DFitter.fitPeaks(xAxis, pearsonVII, new PearsonVII(1.0, 1.0, 1.0, 1.0), new ApacheConjugateGradient(), smoothing, numPeaks);
        fittedPseudoVoigt = Generic1DFitter.fitPeaks(xAxis, pseudoVoigt, new PearsonVII(1.0, 1.0, 1.0, 1.0), new ApacheConjugateGradient(), smoothing, numPeaks);
    }

    @BeforeClass
    public static void setupTestEnvrionment() {
        gaussian = Generic1DDatasetCreater.createGaussianDataset();
        lorentzian = Generic1DDatasetCreater.createLorentzianDataset();
        pearsonVII = Generic1DDatasetCreater.createPearsonVII();
        pseudoVoigt = Generic1DDatasetCreater.createPseudoVoigt();
        xAxis = Generic1DDatasetCreater.xAxis;
        accuracy = 1.0E-4;
        smoothing = 5;
        numPeaks = -1;
        pos = 50.0;
        fwhm = 20.0;
        area = 50.0;
        delta = 0.5;
        ApacheConjugateGradientFittingTest.doFitting();
    }

    @Test
    public void testNumberOfPeaksFoundGaussian() {
        Assert.assertEquals((double)1.0, (double)fittedGaussian.size(), (double)0.0);
    }

    @Test
    public void testNumberOfPeaksFoundLorenzian() {
        Assert.assertEquals((double)1.0, (double)fittedLorenzian.size(), (double)0.0);
    }

    @Test
    public void testNumberOfPeaksFoundPearsonVII() {
        Assert.assertEquals((double)1.0, (double)fittedPearsonVII.size(), (double)0.0);
    }

    @Test
    public void testNumberOfPeaksFoundPseudoVoigt() {
        Assert.assertEquals((double)1.0, (double)fittedPseudoVoigt.size(), (double)0.0);
    }

    @Test
    public void testPeakPosGaussian() {
        Assert.assertEquals((double)pos, (double)fittedGaussian.get(0).getPosition(), (double)delta);
    }

    @Test
    public void testPeakPosLorenzian() {
        Assert.assertEquals((double)pos, (double)fittedLorenzian.get(0).getPosition(), (double)delta);
    }

    @Test
    public void testPeakPosPearsonVII() {
        Assert.assertEquals((double)pos, (double)fittedPearsonVII.get(0).getPosition(), (double)delta);
    }

    @Test
    public void testPeakPosPseudoVoigt() {
        Assert.assertEquals((double)pos, (double)fittedPseudoVoigt.get(0).getPosition(), (double)delta);
    }

    @Test
    public void testFWHMGaussian() {
        Assert.assertEquals((double)fwhm, (double)fittedGaussian.get(0).getFWHM(), (double)delta);
    }

    @Test
    public void testFWHMLorenzian() {
        Assert.assertEquals((double)fwhm, (double)fittedLorenzian.get(0).getFWHM(), (double)delta);
    }

    @Test
    public void testFWHMPearsonVII() {
        Assert.assertEquals((double)fwhm, (double)fittedPearsonVII.get(0).getFWHM(), (double)delta);
    }

    @Test
    public void testFWHMPseudoVoigt() {
        Assert.assertEquals((double)fwhm, (double)fittedPseudoVoigt.get(0).getFWHM(), (double)delta);
    }

    @Test
    public void testAreaGaussian() {
        Assert.assertEquals((double)area, (double)fittedGaussian.get(0).getArea(), (double)delta);
    }

    @Test
    public void testAreaLorenzian() {
        Assert.assertEquals((double)area, (double)fittedLorenzian.get(0).getArea(), (double)delta);
    }

    @Test
    public void testAreaPearsonVII() {
        Assert.assertEquals((double)area, (double)fittedPearsonVII.get(0).getArea(), (double)delta);
    }

    @Test
    public void testAreaPseudoVoigt() {
        Assert.assertEquals((double)area, (double)fittedPseudoVoigt.get(0).getArea(), (double)delta);
    }
}

