/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.fitting;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;

class AngleDerivativeFunction
implements UnivariateRealFunction {
    double ra;
    double rb;
    double alpha;
    double A;
    double B;
    double C;

    AngleDerivativeFunction() {
    }

    public void setRadii(double d, double d2) {
        this.ra = d;
        this.rb = d2;
        this.A = this.ra * this.ra - this.rb * this.rb;
    }

    public void setAngle(double d) {
        this.alpha = d;
    }

    public void setCoordinate(double d, double d2) {
        double d3 = Math.cos(this.alpha);
        double d4 = Math.sin(this.alpha);
        this.B = -this.ra * (d * d3 + d2 * d4);
        this.C = -this.rb * (d * d4 - d2 * d3);
    }

    public double value(double d) throws FunctionEvaluationException {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return (this.A * d2 + this.B) * d3 + this.C * d2;
    }
}

