/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.diffraction;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.diffraction.Resolution;

public class ResolutionTest {
    DetectorProperties detector;
    DiffractionCrystalEnvironment diffexp;

    @Before
    public void initialise() {
        double d = 0.1026;
        int[] nArray = new int[]{3072, 3072};
        Vector3d vector3d = new Vector3d(105.37, 108.86, 170.0);
        Vector3d vector3d2 = new Vector3d(0.0, 0.0, 1.0);
        Matrix3d matrix3d = new Matrix3d(0.984657762021401, 0.017187265168157, -0.17364817766693, 0.012961831885909, 0.985184016468007, 0.171010071662834, 0.174014604574351, -0.170637192932859, 0.969846310392954);
        double d2 = 0.97966;
        this.detector = new DetectorProperties(vector3d, vector3d2, nArray[0], nArray[1], d, d, matrix3d);
        this.diffexp = new DiffractionCrystalEnvironment(d2);
    }

    @Test
    public void compareVectorToOrigin() {
        Vector3d vector3d = new Vector3d(130.0, 120.0, 200.0);
        this.detector.setOrigin(vector3d);
        Assert.assertEquals((Object)this.detector.pixelPosition(0, 0), (Object)vector3d);
        vector3d = new Vector3d(-130.0, 120.0, 200.0);
        this.detector.setOrigin(vector3d);
        Assert.assertEquals((Object)this.detector.pixelPosition(0, 0), (Object)vector3d);
        vector3d = new Vector3d(130.0, -120.0, 200.0);
        this.detector.setOrigin(vector3d);
        Assert.assertEquals((Object)this.detector.pixelPosition(0, 0), (Object)vector3d);
        vector3d = new Vector3d(130.0, 120.0, -200.0);
        this.detector.setOrigin(vector3d);
        Assert.assertEquals((Object)this.detector.pixelPosition(0, 0), (Object)vector3d);
        vector3d = new Vector3d(-130.0, -120.0, 200.0);
        this.detector.setOrigin(vector3d);
        Assert.assertEquals((Object)this.detector.pixelPosition(0, 0), (Object)vector3d);
        vector3d = new Vector3d(130.0, -120.0, -200.0);
        this.detector.setOrigin(vector3d);
        Assert.assertEquals((Object)this.detector.pixelPosition(0, 0), (Object)vector3d);
        vector3d = new Vector3d(-130.0, -120.0, -200.0);
        this.detector.setOrigin(vector3d);
        Assert.assertEquals((Object)this.detector.pixelPosition(0, 0), (Object)vector3d);
    }

    @Test
    public void testDetectorSize() {
        double d = this.detector.getDetectorSizeH();
        double d2 = this.detector.getDetectorSizeV();
        double d3 = Math.sqrt(d * d + d2 * d2);
        int[] nArray = new int[8];
        nArray[3] = 3072;
        nArray[4] = 3072;
        nArray[6] = 3072;
        nArray[7] = 3072;
        int[] nArray2 = nArray;
        Vector3d vector3d = Resolution.pixelToPixelVector(this.detector, nArray2[0], nArray2[1], nArray2[6], nArray2[7]);
        Assert.assertEquals((double)d3, (double)vector3d.length(), (double)1.0E-5);
        Matrix3d matrix3d = this.detector.getOrientation();
        matrix3d.rotY(1.5);
        this.detector.setOrientation(matrix3d);
        vector3d = Resolution.pixelToPixelVector(this.detector, nArray2[0], nArray2[1], nArray2[6], nArray2[7]);
        Assert.assertEquals((double)d3, (double)vector3d.length(), (double)1.0E-5);
        this.detector.setOrigin(new Vector3d(-150.0, 250.0, 389.0));
        vector3d = Resolution.pixelToPixelVector(this.detector, nArray2[0], nArray2[1], nArray2[6], nArray2[7]);
        Assert.assertEquals((double)d3, (double)vector3d.length(), (double)1.0E-5);
    }

    @Test
    public void dspacingFromPx() {
        int[] nArray = new int[]{854, 899, 864, 897, 864, 897, 874, 894, 884, 892, 894, 889, 904, 886, 914, 884, 924, 882};
        try {
            double[] dArray = Resolution.peakDistances(nArray, this.detector, this.diffexp);
            double d = 0.0;
            int n = 0;
            while (n < dArray.length) {
                d += dArray[n++];
            }
            Assert.assertEquals((double)164.0, (double)(d /= (double)dArray.length), (double)1.0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

